/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import com.adobe.marketing.mobile.AnalyticsExtension;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.EventData;
import com.adobe.marketing.mobile.EventSource;
import com.adobe.marketing.mobile.EventType;
import com.adobe.marketing.mobile.Log;
import com.adobe.marketing.mobile.Module;
import com.adobe.marketing.mobile.ModuleEventListener;
import com.adobe.marketing.mobile.StringUtils;

class AnalyticsListenerHubSharedState
extends ModuleEventListener<AnalyticsExtension> {
    private static final String LOG_TAG = AnalyticsListenerHubSharedState.class.getSimpleName();

    AnalyticsListenerHubSharedState(AnalyticsExtension module, EventType type, EventSource source) {
        super((Module)module, type, source);
    }

    public void hear(Event event) {
        EventData eventData = event.getData();
        if (eventData == null || eventData.isEmpty()) {
            Log.warning((String)LOG_TAG, (String)"hear - Ignoring Shared State update event as eventData is invalid", (Object[])new Object[0]);
            return;
        }
        final String stateOwner = eventData.optString("stateowner", null);
        if (!StringUtils.isNullOrEmpty((String)stateOwner)) {
            Log.trace((String)LOG_TAG, (String)"hear - Submitting Shared State update event for processing.", (Object[])new Object[0]);
            ((AnalyticsExtension)this.parentModule).getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ((AnalyticsExtension)AnalyticsListenerHubSharedState.this.parentModule).handleSharedStateUpdateEvent(stateOwner);
                }
            });
        }
    }
}

