/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import com.adobe.marketing.mobile.AnalyticsExtension;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.EventData;
import com.adobe.marketing.mobile.EventSource;
import com.adobe.marketing.mobile.EventType;
import com.adobe.marketing.mobile.Log;
import com.adobe.marketing.mobile.Module;
import com.adobe.marketing.mobile.ModuleEventListener;
import com.adobe.marketing.mobile.StringUtils;
import com.adobe.marketing.mobile.Variant;
import java.util.Map;

class AnalyticsListenerRulesEngineResponseContent
extends ModuleEventListener<AnalyticsExtension> {
    private static final String LOG_TAG = AnalyticsListenerRulesEngineResponseContent.class.getSimpleName();

    AnalyticsListenerRulesEngineResponseContent(AnalyticsExtension module, EventType type, EventSource source) {
        super((Module)module, type, source);
    }

    public void hear(final Event event) {
        EventData eventData;
        EventData eventData2 = eventData = event == null ? null : event.getData();
        if (eventData == null) {
            Log.warning((String)LOG_TAG, (String)"hear - Ignoring Rules Engine Track response content event as event data is null.  ", (Object[])new Object[0]);
            return;
        }
        Map triggeredConsequence = eventData.optVariantMap("triggeredconsequence", null);
        if (triggeredConsequence == null || triggeredConsequence.isEmpty()) {
            Log.warning((String)LOG_TAG, (String)"hear - Not a triggered rule. Return.", (Object[])new Object[0]);
            return;
        }
        String consequenceType = Variant.optVariantFromMap((Map)triggeredConsequence, (String)"type").optString(null);
        if (StringUtils.isNullOrEmpty((String)consequenceType)) {
            Log.warning((String)LOG_TAG, (String)"hear - Triggered rule is not Analytics type. Ignoring Rules Engine Track response content event.", (Object[])new Object[0]);
            return;
        }
        if ("an".equals(consequenceType)) {
            Log.trace((String)LOG_TAG, (String)"hear - Submitting Rules Engine Track response content event for processing.", (Object[])new Object[0]);
            ((AnalyticsExtension)this.parentModule).getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ((AnalyticsExtension)AnalyticsListenerRulesEngineResponseContent.this.parentModule).handleAnalyticsConsequenceEvent(event);
                }
            });
        } else {
            Log.debug((String)LOG_TAG, (String)"hear - Triggered rule is not a valid Analytics type. Cannot handle.", (Object[])new Object[0]);
        }
    }
}

