/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import com.adobe.marketing.mobile.AnalyticsState;
import com.adobe.marketing.mobile.ContextData;
import com.adobe.marketing.mobile.ContextDataUtil;
import com.adobe.marketing.mobile.VisitorID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class AnalyticsRequestSerializer {
    private static final int REQUEST_STRINGBUILDER_CAPACITY = 2048;

    AnalyticsRequestSerializer() {
    }

    String buildRequest(AnalyticsState state, Map<String, String> data, Map<String, String> vars) {
        HashMap<String, String> analyticsVars;
        HashMap<String, String> hashMap = analyticsVars = vars != null ? new HashMap<String, String>(vars) : new HashMap();
        if (data != null) {
            Iterator<Map.Entry<String, String>> it = data.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> kvPair = it.next();
                String key = kvPair.getKey();
                if (key == null) {
                    it.remove();
                    continue;
                }
                if (!key.startsWith("&&")) continue;
                analyticsVars.put(key.substring("&&".length()), kvPair.getValue());
                it.remove();
            }
        }
        analyticsVars.put("c", (String)ContextDataUtil.translateContextData(data));
        StringBuilder requestString = new StringBuilder(2048);
        requestString.append("ndh=1");
        if (state != null && state.isVisitorIDServiceEnabled() && state.getSerializedVisitorIDsList() != null) {
            requestString.append(state.getSerializedVisitorIDsList());
        }
        ContextDataUtil.serializeToQueryString(analyticsVars, (StringBuilder)requestString);
        return requestString.toString();
    }

    static String generateAnalyticsCustomerIdString(List<VisitorID> visitorIDs) {
        if (visitorIDs == null) {
            return null;
        }
        HashMap<String, String> visitorIdMap = new HashMap<String, String>();
        for (VisitorID visitorID : visitorIDs) {
            visitorIdMap.put(AnalyticsRequestSerializer.serializeIdentifierKeyForAnalyticsID(visitorID.getIdType()), visitorID.getId());
            visitorIdMap.put(AnalyticsRequestSerializer.serializeAuthenticationKeyForAnalyticsID(visitorID.getIdType()), String.valueOf(visitorID.getAuthenticationState().getValue()));
        }
        HashMap<String, ContextData> translatedIds = new HashMap<String, ContextData>();
        translatedIds.put("cid", ContextDataUtil.translateContextData(visitorIdMap));
        StringBuilder requestString = new StringBuilder(2048);
        ContextDataUtil.serializeToQueryString(translatedIds, (StringBuilder)requestString);
        return requestString.toString();
    }

    private static String serializeIdentifierKeyForAnalyticsID(String idType) {
        return idType + ".id";
    }

    private static String serializeAuthenticationKeyForAnalyticsID(String idType) {
        return idType + ".as";
    }
}

