/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import com.adobe.marketing.mobile.AnalyticsConstants;
import com.adobe.marketing.mobile.AnalyticsRequestSerializer;
import com.adobe.marketing.mobile.EventData;
import com.adobe.marketing.mobile.Log;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.StringUtils;
import com.adobe.marketing.mobile.URLBuilder;
import com.adobe.marketing.mobile.VariantException;
import com.adobe.marketing.mobile.VisitorID;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AnalyticsState {
    private static final String LOG_TAG = AnalyticsState.class.getSimpleName();
    private boolean analyticsForwardingEnabled = false;
    private boolean offlineEnabled = false;
    private int batchLimit = 0;
    private MobilePrivacyStatus privacyStatus = AnalyticsConstants.Default.DEFAULT_PRIVACY_STATUS;
    private int referrerTimeout = 0;
    private boolean assuranceSessionActive = false;
    private boolean backdateSessionInfoEnabled = false;
    private String marketingCloudOrganizationID;
    private String rsids;
    private String server;
    private String marketingCloudID;
    private String locationHint;
    private String advertisingIdentifier;
    private String blob;
    private String serializedVisitorIDsList;
    private String applicationID;
    private Map<String, String> defaultData = new HashMap<String, String>();
    private int sessionTimeout = 300000;
    private long lifecycleMaxSessionLength = 0L;
    private long lifecycleSessionStartTimestamp = 0L;

    AnalyticsState(Map<String, EventData> dataMap) {
        if (dataMap == null) {
            return;
        }
        for (Map.Entry<String, EventData> data : dataMap.entrySet()) {
            if ("com.adobe.module.configuration".equals(data.getKey())) {
                this.extractConfigurationInfo(data.getValue());
                continue;
            }
            if ("com.adobe.module.lifecycle".equals(data.getKey())) {
                this.extractLifecycleInfo(data.getValue());
                continue;
            }
            if ("com.adobe.module.identity".equals(data.getKey())) {
                this.extractIdentityInfo(data.getValue());
                continue;
            }
            if ("com.adobe.module.places".equals(data.getKey())) {
                this.extractPlacesInfo(data.getValue());
                continue;
            }
            if (!"com.adobe.assurance".equals(data.getKey())) continue;
            this.extractAssuranceInfo(data.getValue());
        }
    }

    private void extractConfigurationInfo(EventData configuration) {
        if (configuration == null) {
            Log.trace((String)LOG_TAG, (String)"extractConfigurationInfo - Failed to extract configuration data as event data was null.", (Object[])new Object[0]);
            return;
        }
        this.server = configuration.optString("analytics.server", null);
        this.rsids = configuration.optString("analytics.rsids", null);
        this.analyticsForwardingEnabled = configuration.optBoolean("analytics.aamForwardingEnabled", false);
        this.offlineEnabled = configuration.optBoolean("analytics.offlineEnabled", false);
        this.batchLimit = configuration.optInteger("analytics.batchLimit", 0);
        int referrerTimeoutFromConfig = configuration.optInteger("analytics.launchHitDelay", 0);
        if (referrerTimeoutFromConfig >= 0) {
            this.referrerTimeout = referrerTimeoutFromConfig;
        }
        this.marketingCloudOrganizationID = configuration.optString("experienceCloud.org", null);
        this.backdateSessionInfoEnabled = configuration.optBoolean("analytics.backdatePreviousSessionInfo", false);
        this.privacyStatus = MobilePrivacyStatus.fromString((String)configuration.optString("global.privacy", AnalyticsConstants.Default.DEFAULT_PRIVACY_STATUS.getValue()));
        this.sessionTimeout = configuration.optInteger("lifecycle.sessionTimeout", 300000);
    }

    private void extractIdentityInfo(EventData identityInfo) {
        if (identityInfo == null) {
            Log.trace((String)LOG_TAG, (String)"extractIdentityInfo - Failed to extract identity data as event data was null.", (Object[])new Object[0]);
            return;
        }
        this.marketingCloudID = identityInfo.optString("mid", null);
        this.blob = identityInfo.optString("blob", null);
        this.locationHint = identityInfo.optString("locationhint", null);
        this.advertisingIdentifier = identityInfo.optString("advertisingidentifier", null);
        if (identityInfo.containsKey("visitoridslist")) {
            try {
                List visitorIdsList = identityInfo.getTypedList("visitoridslist", VisitorID.VARIANT_SERIALIZER);
                this.serializedVisitorIDsList = AnalyticsRequestSerializer.generateAnalyticsCustomerIdString(visitorIdsList);
            }
            catch (VariantException ex) {
                Log.debug((String)LOG_TAG, (String)"extractIdentityInfo - The format of the serializedVisitorIDsList list is invalid: %s", (Object[])new Object[]{ex});
                return;
            }
        }
    }

    private void extractPlacesInfo(EventData placesInfo) {
        String regionName;
        if (placesInfo == null) {
            Log.trace((String)LOG_TAG, (String)"extractPlacesInfo - Failed to extract places data (event data was null).", (Object[])new Object[0]);
            return;
        }
        Map placesContextData = placesInfo.optStringMap("currentpoi", null);
        if (placesContextData == null) {
            return;
        }
        String regionId = (String)placesContextData.get("regionid");
        if (!StringUtils.isNullOrEmpty((String)regionId)) {
            this.defaultData.put("a.loc.poi.id", regionId);
        }
        if (!StringUtils.isNullOrEmpty((String)(regionName = (String)placesContextData.get("regionname")))) {
            this.defaultData.put("a.loc.poi", regionName);
        }
    }

    private void extractLifecycleInfo(EventData lifecycleData) {
        String appId;
        String runMode;
        String carrier;
        String deviceResolution;
        String deviceName;
        if (lifecycleData == null) {
            Log.trace((String)LOG_TAG, (String)"extractLifecycleInfo - Failed to extract lifecycle data (event data was null).", (Object[])new Object[0]);
            return;
        }
        this.lifecycleSessionStartTimestamp = lifecycleData.optLong("starttimestampmillis", 0L);
        this.lifecycleMaxSessionLength = lifecycleData.optLong("maxsessionlength", 0L);
        Map lifecycleContextData = lifecycleData.optStringMap("lifecyclecontextdata", null);
        if (lifecycleContextData == null || lifecycleContextData.isEmpty()) {
            return;
        }
        String osVersion = (String)lifecycleContextData.get("osversion");
        if (!StringUtils.isNullOrEmpty((String)osVersion)) {
            this.defaultData.put("a.OSVersion", osVersion);
        }
        if (!StringUtils.isNullOrEmpty((String)(deviceName = (String)lifecycleContextData.get("devicename")))) {
            this.defaultData.put("a.DeviceName", deviceName);
        }
        if (!StringUtils.isNullOrEmpty((String)(deviceResolution = (String)lifecycleContextData.get("resolution")))) {
            this.defaultData.put("a.Resolution", deviceResolution);
        }
        if (!StringUtils.isNullOrEmpty((String)(carrier = (String)lifecycleContextData.get("carriername")))) {
            this.defaultData.put("a.CarrierName", carrier);
        }
        if (!StringUtils.isNullOrEmpty((String)(runMode = (String)lifecycleContextData.get("runmode")))) {
            this.defaultData.put("a.RunMode", runMode);
        }
        if (!StringUtils.isNullOrEmpty((String)(appId = (String)lifecycleContextData.get("appid")))) {
            this.defaultData.put("a.AppID", appId);
            this.applicationID = appId;
        }
    }

    private void extractAssuranceInfo(EventData assuranceInfo) {
        if (assuranceInfo == null) {
            Log.trace((String)LOG_TAG, (String)"extractAssuranceInfo - Failed to extract assurance data (event data was null).", (Object[])new Object[0]);
            return;
        }
        String assuranceSessionId = assuranceInfo.optString("sessionid", null);
        this.assuranceSessionActive = !StringUtils.isNullOrEmpty((String)assuranceSessionId);
    }

    final Map<String, String> getAnalyticsIdVisitorParameters() {
        HashMap<String, String> analyticsIdVisitorParameters = new HashMap<String, String>();
        if (StringUtils.isNullOrEmpty((String)this.marketingCloudID)) {
            return analyticsIdVisitorParameters;
        }
        analyticsIdVisitorParameters.put("mid", this.marketingCloudID);
        if (!StringUtils.isNullOrEmpty((String)this.blob)) {
            analyticsIdVisitorParameters.put("aamb", this.blob);
        }
        if (!StringUtils.isNullOrEmpty((String)this.locationHint)) {
            analyticsIdVisitorParameters.put("aamlh", this.locationHint);
        }
        return analyticsIdVisitorParameters;
    }

    String getSerializedVisitorIDsList() {
        return this.serializedVisitorIDsList;
    }

    Map<String, String> getDefaultData() {
        return this.defaultData;
    }

    String getMarketingCloudId() {
        return this.marketingCloudID;
    }

    String getAdvertisingIdentifier() {
        return this.advertisingIdentifier;
    }

    String getApplicationID() {
        return this.applicationID;
    }

    void setApplicationID(String applicationID) {
        this.applicationID = applicationID;
    }

    int getReferrerTimeout() {
        return this.referrerTimeout;
    }

    boolean isAnalyticsConfigured() {
        return !StringUtils.isNullOrEmpty((String)this.rsids) && !StringUtils.isNullOrEmpty((String)this.server);
    }

    String getBaseURL(String sdkVersion) {
        URLBuilder urlBuilder = new URLBuilder();
        urlBuilder.enableSSL(true).setServer(this.server).addPath("b").addPath("ss").addPath(this.rsids).addPath(this.getAnalyticsResponseType()).addPath(sdkVersion).addPath("s");
        String url = urlBuilder.build();
        if (url == null) {
            return "";
        }
        return url;
    }

    boolean isVisitorIDServiceEnabled() {
        return !StringUtils.isNullOrEmpty((String)this.marketingCloudOrganizationID);
    }

    private String getAnalyticsResponseType() {
        return this.analyticsForwardingEnabled ? "10" : "0";
    }

    boolean isAnalyticsForwardingEnabled() {
        return this.analyticsForwardingEnabled;
    }

    void setAnalyticsForwardingEnabled(boolean analyticsForwardingEnabled) {
        this.analyticsForwardingEnabled = analyticsForwardingEnabled;
    }

    boolean isOfflineTrackingEnabled() {
        return this.offlineEnabled;
    }

    void setOfflineEnabled(boolean offlineEnabled) {
        this.offlineEnabled = offlineEnabled;
    }

    int getBatchLimit() {
        return this.batchLimit;
    }

    void setBatchLimit(int batchLimit) {
        this.batchLimit = batchLimit;
    }

    void setReferrerTimeout(int referrerTimeout) {
        this.referrerTimeout = referrerTimeout;
    }

    String getMarketingCloudOrganizationID() {
        return this.marketingCloudOrganizationID;
    }

    void setMarketingCloudOrganizationID(String marketingCloudOrganizationID) {
        this.marketingCloudOrganizationID = marketingCloudOrganizationID;
    }

    String getRsids() {
        return this.rsids;
    }

    void setRsids(String rsids) {
        this.rsids = rsids;
    }

    String getServer() {
        return this.server;
    }

    void setServer(String server) {
        this.server = server;
    }

    MobilePrivacyStatus getPrivacyStatus() {
        return this.privacyStatus;
    }

    void setPrivacyStatus(MobilePrivacyStatus privacyStatus) {
        this.privacyStatus = privacyStatus;
    }

    boolean isOptIn() {
        return this.privacyStatus == MobilePrivacyStatus.OPT_IN;
    }

    void setBackdateSessionInfoEnabled(boolean backdateSessionInfoEnabled) {
        this.backdateSessionInfoEnabled = backdateSessionInfoEnabled;
    }

    boolean isBackdateSessionInfoEnabled() {
        return this.backdateSessionInfoEnabled;
    }

    boolean isAssuranceSessionActive() {
        return this.assuranceSessionActive;
    }

    int getSessionTimeout() {
        return this.sessionTimeout;
    }

    long getLifecycleMaxSessionLength() {
        return this.lifecycleMaxSessionLength;
    }

    long getLifecycleSessionStartTimestamp() {
        return this.lifecycleSessionStartTimestamp;
    }
}

