/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.bridge;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.TimeUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class EdgeBridgeExtension
extends Extension {
    private static final String LOG_SOURCE = "EdgeBridgeExtension";

    protected EdgeBridgeExtension(ExtensionApi extensionApi) {
        super(extensionApi);
    }

    @NonNull
    protected String getName() {
        return "com.adobe.edge.bridge";
    }

    @NonNull
    protected String getFriendlyName() {
        return "Edge Bridge";
    }

    @NonNull
    protected String getVersion() {
        return "2.1.0";
    }

    protected void onRegistered() {
        this.getApi().registerEventListener("com.adobe.eventType.generic.track", "com.adobe.eventSource.requestContent", this::handleTrackRequest);
        this.getApi().registerEventListener("com.adobe.eventType.rulesEngine", "com.adobe.eventSource.responseContent", this::handleRulesEngineResponse);
    }

    void handleTrackRequest(@NonNull Event event) {
        Map eventData = event.getEventData();
        if (this.isNullOrEmpty(eventData)) {
            Log.trace((String)"EdgeBridge", (String)LOG_SOURCE, (String)"Unable to handle track request event with id '%s': event data is missing or empty.", (Object[])new Object[]{event.getUniqueIdentifier()});
            return;
        }
        this.dispatchTrackRequest(eventData, event);
    }

    void handleRulesEngineResponse(@NonNull Event event) {
        Map eventData = event.getEventData();
        if (this.isNullOrEmpty(eventData)) {
            Log.trace((String)"EdgeBridge", (String)LOG_SOURCE, (String)"Ignoring Rules Engine response event with id '%s': event data is missing or empty.", (Object[])new Object[]{event.getUniqueIdentifier()});
            return;
        }
        Map consequence = DataReader.optTypedMap(Object.class, (Map)eventData, (String)"triggeredconsequence", null);
        if (this.isNullOrEmpty(consequence)) {
            Log.trace((String)"EdgeBridge", (String)LOG_SOURCE, (String)"Ignoring Rule Engine response event with id '%s': consequence data is invalid or empty.", (Object[])new Object[]{event.getUniqueIdentifier()});
            return;
        }
        String type = DataReader.optString((Map)consequence, (String)"type", null);
        if (!"an".equals(type)) {
            return;
        }
        String id = DataReader.optString((Map)consequence, (String)"id", null);
        if (StringUtils.isNullOrEmpty((String)id)) {
            Log.trace((String)"EdgeBridge", (String)LOG_SOURCE, (String)"Ignoring Rule Engine response event with id '%s': consequence id is invalid or empty.", (Object[])new Object[]{event.getUniqueIdentifier()});
            return;
        }
        Map detail = DataReader.optTypedMap(Object.class, (Map)consequence, (String)"detail", null);
        if (this.isNullOrEmpty(detail)) {
            Log.trace((String)"EdgeBridge", (String)LOG_SOURCE, (String)"Ignoring Rule Engine response event with id '%s': consequence detail is invalid or empty.", (Object[])new Object[]{event.getUniqueIdentifier()});
            return;
        }
        this.dispatchTrackRequest(detail, event);
    }

    private void dispatchTrackRequest(Map<String, Object> data, Event parentEvent) {
        HashMap<String, String> xdmData = new HashMap<String, String>();
        xdmData.put("eventType", "analytics.track");
        xdmData.put("timestamp", TimeUtils.getISO8601UTCDateWithMilliseconds((Date)new Date(parentEvent.getTimestamp())));
        HashMap<String, Map<String, Object>> eventData = new HashMap<String, Map<String, Object>>();
        eventData.put("xdm", xdmData);
        eventData.put("data", data);
        Event event = new Event.Builder("Edge Bridge Request", "com.adobe.eventType.edge", "com.adobe.eventSource.requestContent").chainToParentEvent(parentEvent).setEventData(eventData).build();
        this.getApi().dispatch(event);
    }

    private boolean isNullOrEmpty(Map map) {
        return map == null || map.isEmpty();
    }
}

