/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

final class ECID {
    private static final String LOG_SOURCE = "ECID";
    private final String ecidString;

    ECID() {
        UUID uuid = UUID.randomUUID();
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        this.ecidString = String.format(Locale.US, "%019d%019d", most < 0L ? -most : most, least < 0L ? -least : least);
    }

    ECID(String ecidString) {
        if (StringUtils.isNullOrEmpty((String)ecidString)) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Creating an ECID with null or empty ecidString is not allowed, generating a new ECID.", (Object[])new Object[0]);
            this.ecidString = new ECID().toString();
            return;
        }
        this.ecidString = ecidString;
    }

    public String toString() {
        return this.ecidString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECID ecid = (ECID)o;
        return Objects.equals(this.ecidString, ecid.ecidString);
    }

    public int hashCode() {
        return Objects.hash(this.ecidString);
    }
}

