/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.edge.identity.ECID;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Map;

final class EventUtils {
    EventUtils() {
    }

    static boolean isAdIdEvent(Event event) {
        Map data = event.getEventData();
        return data.containsKey("advertisingidentifier");
    }

    static boolean isGetUrlVariablesRequestEvent(Event event) {
        return event != null && DataReader.optBoolean((Map)event.getEventData(), (String)"urlvariables", (boolean)false);
    }

    static boolean isSharedStateUpdateFor(String stateOwnerName, Event event) {
        if (StringUtils.isNullOrEmpty((String)stateOwnerName) || event == null) {
            return false;
        }
        String stateOwner = DataReader.optString((Map)event.getEventData(), (String)"stateowner", (String)"");
        return stateOwnerName.equals(stateOwner);
    }

    static String getAdId(Event event) {
        Map data = event.getEventData();
        String adID = DataReader.optString((Map)data, (String)"advertisingidentifier", null);
        return adID == null || "00000000-0000-0000-0000-000000000000".equals(adID) ? "" : adID;
    }

    static ECID getECID(Map<String, Object> identityDirectSharedState) {
        String legacyEcidString = DataReader.optString(identityDirectSharedState, (String)"mid", null);
        return legacyEcidString == null ? null : new ECID(legacyEcidString);
    }

    static String getOrgId(Map<String, Object> configurationSharedState) {
        return DataReader.optString(configurationSharedState, (String)"experienceCloud.org", null);
    }
}

