/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AdobeCallbackWithError;
import com.adobe.marketing.mobile.AdobeError;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.edge.identity.IdentityExtension;
import com.adobe.marketing.mobile.edge.identity.IdentityItem;
import com.adobe.marketing.mobile.edge.identity.IdentityMap;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Identity {
    public static final Class<? extends Extension> EXTENSION = IdentityExtension.class;
    private static final long CALLBACK_TIMEOUT_MILLIS = 500L;
    private static final String LOG_SOURCE = "Identity";

    private Identity() {
    }

    @NonNull
    public static String extensionVersion() {
        return "3.0.0";
    }

    public static void getExperienceCloudId(final @NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Unexpected null callback, provide a callback to retrieve current ECID.", (Object[])new Object[0]);
            return;
        }
        Event event = new Event.Builder("Edge Identity Request ECID", "com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.requestIdentity").build();
        AdobeCallbackWithError<Event> callbackWithError = new AdobeCallbackWithError<Event>(){

            public void call(Event responseEvent) {
                if (responseEvent == null || responseEvent.getEventData() == null) {
                    Identity.returnError(callback, AdobeError.UNEXPECTED_ERROR);
                    return;
                }
                IdentityMap identityMap = IdentityMap.fromXDMMap(responseEvent.getEventData());
                if (identityMap == null) {
                    Log.debug((String)"EdgeIdentity", (String)Identity.LOG_SOURCE, (String)"Failed to read IdentityMap from response event, invoking error callback with AdobeError.UNEXPECTED_ERROR", (Object[])new Object[0]);
                    Identity.returnError(callback, AdobeError.UNEXPECTED_ERROR);
                    return;
                }
                List<IdentityItem> ecidItems = identityMap.getIdentityItemsForNamespace("ECID");
                if (ecidItems == null || ecidItems.isEmpty() || ecidItems.get(0).getId() == null) {
                    callback.call((Object)"");
                } else {
                    callback.call((Object)ecidItems.get(0).getId());
                }
            }

            public void fail(AdobeError adobeError) {
                Identity.returnError(callback, adobeError);
                Log.debug((String)"EdgeIdentity", (String)Identity.LOG_SOURCE, (String)String.format("Failed to dispatch %s event: Error : %s.", "Edge Identity Request ECID", adobeError.getErrorName()), (Object[])new Object[0]);
            }
        };
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)500L, (AdobeCallbackWithError)callbackWithError);
    }

    public static void getUrlVariables(final @NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Unexpected null callback, provide a callback to retrieve current visitor identifiers (URLVariables) query string.", (Object[])new Object[0]);
            return;
        }
        Event event = new Event.Builder("Edge Identity Request URL Variables", "com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.requestIdentity").setEventData((Map)new HashMap<String, Object>(){
            {
                this.put("urlvariables", true);
            }
        }).build();
        AdobeCallbackWithError<Event> callbackWithError = new AdobeCallbackWithError<Event>(){

            public void call(Event responseEvent) {
                if (responseEvent == null || responseEvent.getEventData() == null) {
                    Identity.returnError(callback, AdobeError.UNEXPECTED_ERROR);
                    return;
                }
                Map data = responseEvent.getEventData();
                String urlVariableString = DataReader.optString((Map)data, (String)"urlvariables", null);
                if (urlVariableString == null) {
                    Identity.returnError(callback, AdobeError.UNEXPECTED_ERROR);
                    return;
                }
                callback.call((Object)urlVariableString);
            }

            public void fail(AdobeError adobeError) {
                Identity.returnError(callback, adobeError);
                Log.debug((String)"EdgeIdentity", (String)Identity.LOG_SOURCE, (String)String.format("Failed to dispatch %s event: Error : %s.", "Edge Identity Request URL Variables", adobeError.getErrorName()), (Object[])new Object[0]);
            }
        };
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)500L, (AdobeCallbackWithError)callbackWithError);
    }

    public static void updateIdentities(@NonNull IdentityMap identityMap) {
        if (identityMap == null || identityMap.isEmpty()) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Unable to updateIdentities, IdentityMap is null or empty", (Object[])new Object[0]);
            return;
        }
        Event updateIdentitiesEvent = new Event.Builder("Edge Identity Update Identities", "com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.updateIdentity").setEventData(identityMap.asXDMMap(false)).build();
        MobileCore.dispatchEvent((Event)updateIdentitiesEvent);
    }

    public static void removeIdentity(@NonNull IdentityItem item, @NonNull String namespace) {
        if (StringUtils.isNullOrEmpty((String)namespace)) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Unable to removeIdentity, namespace is null or empty", (Object[])new Object[0]);
            return;
        }
        if (item == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Unable to removeIdentity, IdentityItem is null", (Object[])new Object[0]);
            return;
        }
        IdentityMap identityMap = new IdentityMap();
        identityMap.addItem(item, namespace);
        Event removeIdentitiesEvent = new Event.Builder("Edge Identity Remove Identities", "com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.removeIdentity").setEventData(identityMap.asXDMMap(false)).build();
        MobileCore.dispatchEvent((Event)removeIdentitiesEvent);
    }

    public static void getIdentities(final @NonNull AdobeCallback<IdentityMap> callback) {
        if (callback == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Unexpected null callback, provide a callback to retrieve current IdentityMap.", (Object[])new Object[0]);
            return;
        }
        Event event = new Event.Builder("Edge Identity Request Identities", "com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.requestIdentity").build();
        AdobeCallbackWithError<Event> callbackWithError = new AdobeCallbackWithError<Event>(){

            public void call(Event responseEvent) {
                if (responseEvent == null || responseEvent.getEventData() == null) {
                    Identity.returnError(callback, AdobeError.UNEXPECTED_ERROR);
                    return;
                }
                IdentityMap identityMap = IdentityMap.fromXDMMap(responseEvent.getEventData());
                if (identityMap == null) {
                    Log.debug((String)"EdgeIdentity", (String)Identity.LOG_SOURCE, (String)"Failed to read IdentityMap from response event, invoking error callback with AdobeError.UNEXPECTED_ERROR", (Object[])new Object[0]);
                    Identity.returnError(callback, AdobeError.UNEXPECTED_ERROR);
                    return;
                }
                callback.call((Object)identityMap);
            }

            public void fail(AdobeError adobeError) {
                Identity.returnError(callback, adobeError);
                Log.debug((String)"EdgeIdentity", (String)Identity.LOG_SOURCE, (String)String.format("Failed to dispatch %s event: Error : %s.", "Edge Identity Request Identities", adobeError.getErrorName()), (Object[])new Object[0]);
            }
        };
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)500L, (AdobeCallbackWithError)callbackWithError);
    }

    private static <T> void returnError(AdobeCallback<T> callback, AdobeError error) {
        AdobeCallbackWithError adobeCallbackWithError;
        if (callback == null) {
            return;
        }
        AdobeCallbackWithError adobeCallbackWithError2 = adobeCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        if (adobeCallbackWithError != null) {
            adobeCallbackWithError.fail(error);
        }
    }
}

