/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResolver;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.edge.identity.ECID;
import com.adobe.marketing.mobile.edge.identity.EventUtils;
import com.adobe.marketing.mobile.edge.identity.IdentityMap;
import com.adobe.marketing.mobile.edge.identity.IdentityState;
import com.adobe.marketing.mobile.edge.identity.SharedStateCallback;
import com.adobe.marketing.mobile.edge.identity.URLUtils;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.TimeUtils;
import java.util.HashMap;
import java.util.Map;

class IdentityExtension
extends Extension {
    private static final String LOG_SOURCE = "IdentityExtension";
    private final SharedStateCallback sharedStateHandle = new SharedStateCallback(){

        @Override
        public SharedStateResult getSharedState(String stateOwner, Event event) {
            return IdentityExtension.this.getApi().getSharedState(stateOwner, event, false, SharedStateResolution.LAST_SET);
        }

        @Override
        public void createXDMSharedState(Map<String, Object> state, Event event) {
            IdentityExtension.this.getApi().createXDMSharedState(state, event);
        }
    };
    private final IdentityState state;

    protected IdentityExtension(ExtensionApi extensionApi) {
        this(extensionApi, new IdentityState());
    }

    @VisibleForTesting
    IdentityExtension(ExtensionApi extensionApi, IdentityState state) {
        super(extensionApi);
        this.state = state;
    }

    @NonNull
    protected String getName() {
        return "com.adobe.edge.identity";
    }

    @NonNull
    protected String getFriendlyName() {
        return "Edge Identity";
    }

    @NonNull
    protected String getVersion() {
        return "3.0.0";
    }

    protected void onRegistered() {
        super.onRegistered();
        this.getApi().registerEventListener("com.adobe.eventType.generic.identity", "com.adobe.eventSource.requestContent", this::handleRequestContent);
        this.getApi().registerEventListener("com.adobe.eventType.generic.identity", "com.adobe.eventSource.requestReset", this::handleRequestReset);
        this.getApi().registerEventListener("com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.requestIdentity", this::handleRequestIdentity);
        this.getApi().registerEventListener("com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.updateIdentity", this::handleUpdateIdentities);
        this.getApi().registerEventListener("com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.removeIdentity", this::handleRemoveIdentity);
        this.getApi().registerEventListener("com.adobe.eventType.hub", "com.adobe.eventSource.sharedState", this::handleIdentityDirectECIDUpdate);
    }

    public boolean readyForEvent(@NonNull Event event) {
        if (!this.state.bootupIfReady(this.sharedStateHandle)) {
            return false;
        }
        if (EventUtils.isGetUrlVariablesRequestEvent(event)) {
            SharedStateResult configurationStateResult = this.sharedStateHandle.getSharedState("com.adobe.module.configuration", event);
            return configurationStateResult != null && configurationStateResult.getStatus() == SharedStateStatus.SET;
        }
        return true;
    }

    void handleRequestIdentity(@NonNull Event event) {
        if (EventUtils.isGetUrlVariablesRequestEvent(event)) {
            this.handleUrlVariablesRequest(event);
        } else {
            this.handleGetIdentifiersRequest(event);
        }
    }

    void handleUrlVariablesRequest(@NonNull Event event) {
        String ecidString;
        SharedStateResult configSharedStateResult = this.sharedStateHandle.getSharedState("com.adobe.module.configuration", event);
        Map configurationState = configSharedStateResult != null ? configSharedStateResult.getValue() : null;
        String orgId = EventUtils.getOrgId(configurationState);
        if (StringUtils.isNullOrEmpty((String)orgId)) {
            this.handleUrlVariableResponse(event, null, "Cannot process getUrlVariables request Identity event, Experience Cloud Org ID not found in configuration.");
            return;
        }
        ECID ecid = this.state.getIdentityProperties().getECID();
        String string = ecidString = ecid != null ? ecid.toString() : null;
        if (StringUtils.isNullOrEmpty((String)ecidString)) {
            this.handleUrlVariableResponse(event, null, "Cannot process getUrlVariables request Identity event, ECID not found.");
            return;
        }
        String urlVariablesString = URLUtils.generateURLVariablesPayload(String.valueOf(TimeUtils.getUnixTimeInSeconds()), ecidString, orgId);
        this.handleUrlVariableResponse(event, urlVariablesString);
    }

    private void handleUrlVariableResponse(@NonNull Event event, String urlVariables) {
        this.handleUrlVariableResponse(event, urlVariables, null);
    }

    private void handleUrlVariableResponse(@NonNull Event event, final String urlVariables, String errorMsg) {
        Event responseEvent = new Event.Builder("Edge Identity Response URL Variables", "com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.responseIdentity").setEventData((Map)new HashMap<String, Object>(){
            {
                this.put("urlvariables", urlVariables);
            }
        }).inResponseToEvent(event).build();
        if (StringUtils.isNullOrEmpty((String)urlVariables) && !StringUtils.isNullOrEmpty((String)errorMsg)) {
            Log.warning((String)"EdgeIdentity", (String)LOG_SOURCE, (String)errorMsg, (Object[])new Object[0]);
        }
        this.getApi().dispatch(responseEvent);
    }

    void handleUpdateIdentities(@NonNull Event event) {
        SharedStateResolver resolver = this.getApi().createPendingXDMSharedState(event);
        Map eventData = event.getEventData();
        if (eventData == null) {
            Log.trace((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Cannot update identifiers, event data is null.", (Object[])new Object[0]);
            resolver.resolve(this.state.getIdentityProperties().toXDMData());
            return;
        }
        IdentityMap map = IdentityMap.fromXDMMap(eventData);
        if (map == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Failed to update identifiers as no identifiers were found in the event data.", (Object[])new Object[0]);
            resolver.resolve(this.state.getIdentityProperties().toXDMData());
            return;
        }
        this.state.updateCustomerIdentifiers(map);
        resolver.resolve(this.state.getIdentityProperties().toXDMData());
    }

    void handleRemoveIdentity(@NonNull Event event) {
        SharedStateResolver resolver = this.getApi().createPendingXDMSharedState(event);
        Map eventData = event.getEventData();
        if (eventData == null) {
            Log.trace((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Cannot remove identifiers, event data is null.", (Object[])new Object[0]);
            resolver.resolve(this.state.getIdentityProperties().toXDMData());
            return;
        }
        IdentityMap map = IdentityMap.fromXDMMap(eventData);
        if (map == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Failed to remove identifiers as no identifiers were found in the event data.", (Object[])new Object[0]);
            resolver.resolve(this.state.getIdentityProperties().toXDMData());
            return;
        }
        this.state.removeCustomerIdentifiers(map);
        resolver.resolve(this.state.getIdentityProperties().toXDMData());
    }

    private void handleGetIdentifiersRequest(@NonNull Event event) {
        Map<String, Object> xdmData = this.state.getIdentityProperties().toXDMData(true);
        Event responseEvent = new Event.Builder("Edge Identity Response Content One Time", "com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.responseIdentity").setEventData(xdmData).inResponseToEvent(event).build();
        this.getApi().dispatch(responseEvent);
    }

    void handleRequestReset(@NonNull Event event) {
        SharedStateResolver resolver = this.getApi().createPendingXDMSharedState(event);
        this.state.resetIdentifiers();
        resolver.resolve(this.state.getIdentityProperties().toXDMData());
        Event responseEvent = new Event.Builder("Edge Identity Reset Identities Complete", "com.adobe.eventType.edgeIdentity", "com.adobe.eventSource.resetComplete").inResponseToEvent(event).build();
        this.getApi().dispatch(responseEvent);
    }

    void handleIdentityDirectECIDUpdate(@NonNull Event event) {
        Map identityState;
        if (!EventUtils.isSharedStateUpdateFor("com.adobe.module.identity", event)) {
            return;
        }
        SharedStateResult identitySharedStateResult = this.sharedStateHandle.getSharedState("com.adobe.module.identity", event);
        Map map = identityState = identitySharedStateResult != null ? identitySharedStateResult.getValue() : null;
        if (identityState == null) {
            return;
        }
        ECID legacyEcid = EventUtils.getECID(identityState);
        if (this.state.updateLegacyExperienceCloudId(legacyEcid)) {
            this.shareIdentityXDMSharedState(event);
        }
    }

    void handleRequestContent(@NonNull Event event) {
        if (!EventUtils.isAdIdEvent(event)) {
            return;
        }
        this.state.updateAdvertisingIdentifier(event, this.sharedStateHandle);
    }

    private void shareIdentityXDMSharedState(Event event) {
        this.sharedStateHandle.createXDMSharedState(this.state.getIdentityProperties().toXDMData(), event);
    }
}

