/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.edge.identity.AuthenticatedState;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class IdentityItem {
    private static final String LOG_SOURCE = "IdentityItem";
    private final String id;
    private final AuthenticatedState authenticatedState;
    private final boolean primary;

    public IdentityItem(@NonNull String id, @Nullable AuthenticatedState authenticatedState, boolean primary) {
        if (id == null) {
            throw new IllegalArgumentException("id must be non-null");
        }
        this.id = id;
        this.authenticatedState = authenticatedState != null ? authenticatedState : AuthenticatedState.AMBIGUOUS;
        this.primary = primary;
    }

    public IdentityItem(@NonNull String id) {
        this(id, AuthenticatedState.AMBIGUOUS, false);
    }

    public IdentityItem(@NonNull IdentityItem item) {
        this(item.id, item.authenticatedState, item.primary);
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public AuthenticatedState getAuthenticatedState() {
        return this.authenticatedState;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    @NonNull
    public String toString() {
        return "{\"id\": \"" + this.id + "\", \"" + "authenticatedState" + "\": \"" + (this.authenticatedState == null ? "null" : this.authenticatedState.getName()) + "\", \"" + "primary" + "\": " + this.primary + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityItem that = (IdentityItem)o;
        return this.id.equalsIgnoreCase(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    Map<String, Object> toObjectMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.id != null) {
            map.put("id", this.id);
        }
        if (this.authenticatedState != null) {
            map.put("authenticatedState", this.authenticatedState.getName());
        } else {
            map.put("authenticatedState", AuthenticatedState.AMBIGUOUS.getName());
        }
        map.put("primary", this.primary);
        return map;
    }

    static IdentityItem fromData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        try {
            String id = DataReader.getString(data, (String)"id");
            AuthenticatedState authenticatedState = AuthenticatedState.fromString(DataReader.optString(data, (String)"authenticatedState", (String)AuthenticatedState.AMBIGUOUS.getName()));
            boolean primary = DataReader.optBoolean(data, (String)"primary", (boolean)false);
            return new IdentityItem(id, authenticatedState, primary);
        }
        catch (DataReaderException e) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Failed to create IdentityItem from data.", (Object[])new Object[0]);
        }
        catch (IllegalArgumentException e) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Failed to create IdentityItem from data as 'id' is null. %s", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        return null;
    }
}

