/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.edge.identity.IdentityItem;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.MapUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IdentityMap {
    private static final String LOG_SOURCE = "IdentityMap";
    private final Map<String, List<IdentityItem>> identityItems = new HashMap<String, List<IdentityItem>>();

    @NonNull
    public List<IdentityItem> getIdentityItemsForNamespace(@NonNull String namespace) {
        ArrayList<IdentityItem> copyItems = new ArrayList<IdentityItem>();
        if (StringUtils.isNullOrEmpty((String)namespace)) {
            return copyItems;
        }
        List<IdentityItem> items = this.identityItems.get(namespace);
        if (items == null) {
            return copyItems;
        }
        for (IdentityItem item : items) {
            copyItems.add(new IdentityItem(item));
        }
        return copyItems;
    }

    @NonNull
    public List<String> getNamespaces() {
        return new ArrayList<String>(this.identityItems.keySet());
    }

    public void addItem(@NonNull IdentityItem item, @NonNull String namespace) {
        this.addItem(item, namespace, false);
    }

    public void removeItem(@NonNull IdentityItem item, @NonNull String namespace) {
        if (item == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Remove item ignored as must contain a non-null IdentityItem.", (Object[])new Object[0]);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)namespace)) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Remove item ignored as must contain a non-null/non-empty namespace.", (Object[])new Object[0]);
            return;
        }
        this.removeItemFromMap(item, namespace);
    }

    public boolean isEmpty() {
        return this.identityItems.isEmpty();
    }

    @NonNull
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{\"").append("identityMap").append("\": {");
        for (Map.Entry<String, List<IdentityItem>> me : this.identityItems.entrySet()) {
            b.append("\"").append(me.getKey()).append("\": [");
            for (IdentityItem item : me.getValue()) {
                b.append(item).append(",");
            }
            if (!me.getValue().isEmpty()) {
                b.deleteCharAt(b.length() - 1);
            }
            b.append("],");
        }
        if (!this.identityItems.isEmpty()) {
            b.deleteCharAt(b.length() - 1);
        }
        b.append("}}");
        return b.toString();
    }

    void addItem(IdentityItem item, String namespace, boolean isFirstItem) {
        if (item == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Add item ignored as must contain a non-null IdentityItem.", (Object[])new Object[0]);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)namespace)) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Add item ignored as must contain a non-null/non-empty namespace.", (Object[])new Object[0]);
            return;
        }
        this.addItemToMap(item, namespace, isFirstItem);
    }

    void merge(IdentityMap map) {
        if (map == null) {
            return;
        }
        for (String namespace : map.identityItems.keySet()) {
            for (IdentityItem identityItem : map.identityItems.get(namespace)) {
                this.addItem(identityItem, namespace);
            }
        }
    }

    void remove(IdentityMap map) {
        if (map == null) {
            return;
        }
        for (String namespace : map.identityItems.keySet()) {
            for (IdentityItem identityItem : map.identityItems.get(namespace)) {
                this.removeItem(identityItem, namespace);
            }
        }
    }

    boolean clearItemsForNamespace(String namespace) {
        if (namespace == null) {
            return false;
        }
        boolean isRemoved = false;
        ArrayList<String> filteredNamespaces = new ArrayList<String>();
        for (String eachNamespace : this.identityItems.keySet()) {
            if (!namespace.equalsIgnoreCase(eachNamespace)) continue;
            isRemoved = true;
            filteredNamespaces.add(eachNamespace);
        }
        for (String eachNamespace : filteredNamespaces) {
            this.identityItems.remove(eachNamespace);
        }
        return isRemoved;
    }

    Map<String, Object> asXDMMap(boolean allowEmpty) {
        HashMap<String, Object> xdmMap = new HashMap<String, Object>();
        HashMap identityMap = new HashMap();
        for (String namespace : this.identityItems.keySet()) {
            ArrayList<Map<String, Object>> namespaceIds = new ArrayList<Map<String, Object>>();
            for (IdentityItem identityItem : this.identityItems.get(namespace)) {
                namespaceIds.add(identityItem.toObjectMap());
            }
            identityMap.put(namespace, namespaceIds);
        }
        if (!identityMap.isEmpty() || allowEmpty) {
            xdmMap.put("identityMap", identityMap);
        }
        return xdmMap;
    }

    static IdentityMap fromXDMMap(Map<String, Object> map) {
        if (MapUtils.isNullOrEmpty(map)) {
            return null;
        }
        Map identityMapDict = DataReader.optTypedMap(Object.class, map, (String)"identityMap", null);
        if (identityMapDict == null) {
            return null;
        }
        IdentityMap identityMap = new IdentityMap();
        for (String namespace : identityMapDict.keySet()) {
            List immutableIdList = DataReader.optTypedListOfMap(Object.class, (Map)identityMapDict, (String)namespace, null);
            if (immutableIdList == null) continue;
            for (Map idMap : immutableIdList) {
                IdentityItem item = IdentityItem.fromData(idMap);
                if (item == null) continue;
                identityMap.addItemToMap(item, namespace, false);
            }
        }
        return identityMap;
    }

    private void addItemToMap(IdentityItem newItem, String namespace, boolean isFirstItem) {
        if (StringUtils.isNullOrEmpty((String)newItem.getId())) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Unable to add IdentityItem to IdentityMap with null or empty identifier value: %s", (Object[])new Object[]{newItem});
            return;
        }
        List<Object> itemList = this.identityItems.containsKey(namespace) ? this.identityItems.get(namespace) : new ArrayList();
        int index = itemList.indexOf(newItem);
        if (index >= 0) {
            itemList.set(index, newItem);
        } else if (isFirstItem) {
            itemList.add(0, newItem);
        } else {
            itemList.add(newItem);
        }
        this.identityItems.put(namespace, itemList);
    }

    private void removeItemFromMap(IdentityItem item, String namespace) {
        if (!this.identityItems.containsKey(namespace)) {
            return;
        }
        List<IdentityItem> itemList = this.identityItems.get(namespace);
        itemList.remove(item);
        if (itemList.isEmpty()) {
            this.identityItems.remove(namespace);
        }
    }
}

