/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import com.adobe.marketing.mobile.edge.identity.AuthenticatedState;
import com.adobe.marketing.mobile.edge.identity.ECID;
import com.adobe.marketing.mobile.edge.identity.IdentityItem;
import com.adobe.marketing.mobile.edge.identity.IdentityMap;
import com.adobe.marketing.mobile.edge.identity.Utils;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class IdentityProperties {
    private static final String LOG_SOURCE = "IdentityProperties";
    private static final List<String> reservedNamespaces = Arrays.asList("ECID", "GAID", "IDFA");
    private final IdentityMap identityMap;

    IdentityProperties() {
        this.identityMap = new IdentityMap();
    }

    IdentityProperties(Map<String, Object> xdmData) {
        IdentityMap map = IdentityMap.fromXDMMap(xdmData);
        this.identityMap = map == null ? new IdentityMap() : map;
    }

    String getAdId() {
        List<IdentityItem> adIdItems = this.identityMap.getIdentityItemsForNamespace("GAID");
        if (Utils.isNullOrEmpty(adIdItems) || adIdItems.get(0) == null) {
            return null;
        }
        return adIdItems.get(0).getId();
    }

    void setAdId(String newAdId) {
        String currentAdId = this.getAdId();
        if (currentAdId != null && !currentAdId.equalsIgnoreCase(newAdId)) {
            IdentityItem previousAdIdItem = new IdentityItem(currentAdId);
            this.identityMap.removeItem(previousAdIdItem, "GAID");
        }
        if (StringUtils.isNullOrEmpty((String)newAdId)) {
            return;
        }
        IdentityItem newAdIdItem = new IdentityItem(newAdId, AuthenticatedState.AMBIGUOUS, false);
        this.identityMap.addItem(newAdIdItem, "GAID");
    }

    void setECID(ECID newEcid) {
        ECID currentECID = this.getECID();
        if (currentECID != null) {
            IdentityItem previousECIDItem = new IdentityItem(currentECID.toString());
            this.identityMap.removeItem(previousECIDItem, "ECID");
        }
        if (newEcid == null) {
            this.setECIDSecondary(null);
            this.identityMap.clearItemsForNamespace("ECID");
        } else {
            IdentityItem newECIDItem = new IdentityItem(newEcid.toString(), AuthenticatedState.AMBIGUOUS, false);
            this.identityMap.addItem(newECIDItem, "ECID", true);
        }
    }

    ECID getECID() {
        List<IdentityItem> ecidItems = this.identityMap.getIdentityItemsForNamespace("ECID");
        if (ecidItems != null && !ecidItems.isEmpty() && ecidItems.get(0) != null && !StringUtils.isNullOrEmpty((String)ecidItems.get(0).getId())) {
            return new ECID(ecidItems.get(0).getId());
        }
        return null;
    }

    void setECIDSecondary(ECID newSecondaryEcid) {
        ECID ecidSecondary = this.getECIDSecondary();
        if (ecidSecondary != null) {
            IdentityItem previousECIDItem = new IdentityItem(ecidSecondary.toString());
            this.identityMap.removeItem(previousECIDItem, "ECID");
        }
        if (this.getECID() == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Cannot set secondary ECID value as no primary ECID exists.", (Object[])new Object[0]);
            return;
        }
        if (newSecondaryEcid != null) {
            IdentityItem newSecondaryECIDItem = new IdentityItem(newSecondaryEcid.toString(), AuthenticatedState.AMBIGUOUS, false);
            this.identityMap.addItem(newSecondaryECIDItem, "ECID");
        }
    }

    ECID getECIDSecondary() {
        List<IdentityItem> ecidItems = this.identityMap.getIdentityItemsForNamespace("ECID");
        if (ecidItems != null && ecidItems.size() > 1 && ecidItems.get(1) != null && !StringUtils.isNullOrEmpty((String)ecidItems.get(1).getId())) {
            return new ECID(ecidItems.get(1).getId());
        }
        return null;
    }

    void updateCustomerIdentifiers(IdentityMap map) {
        this.removeIdentitiesWithReservedNamespaces(map);
        this.identityMap.merge(map);
    }

    void removeCustomerIdentifiers(IdentityMap map) {
        this.removeIdentitiesWithReservedNamespaces(map);
        this.identityMap.remove(map);
    }

    Map<String, Object> toXDMData() {
        return this.toXDMData(false);
    }

    Map<String, Object> toXDMData(boolean allowEmpty) {
        return this.identityMap.asXDMMap(allowEmpty);
    }

    private void removeIdentitiesWithReservedNamespaces(IdentityMap identityMap) {
        for (String reservedNamespace : reservedNamespaces) {
            if (!identityMap.clearItemsForNamespace(reservedNamespace)) continue;
            if (reservedNamespace.equalsIgnoreCase("GAID") || reservedNamespace.equalsIgnoreCase("IDFA")) {
                Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)String.format("Operation not allowed for namespace %s; use MobileCore.setAdvertisingIdentifier instead.", reservedNamespace), (Object[])new Object[0]);
                continue;
            }
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)String.format("Updating/Removing identifiers in namespace %s is not allowed.", reservedNamespace), (Object[])new Object[0]);
        }
    }
}

