/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.edge.identity.ECID;
import com.adobe.marketing.mobile.edge.identity.EventUtils;
import com.adobe.marketing.mobile.edge.identity.IdentityMap;
import com.adobe.marketing.mobile.edge.identity.IdentityProperties;
import com.adobe.marketing.mobile.edge.identity.IdentityStorageManager;
import com.adobe.marketing.mobile.edge.identity.SharedStateCallback;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.MapUtils;
import java.util.HashMap;
import java.util.Map;

class IdentityState {
    private static final String LOG_SOURCE = "IdentityState";
    private final IdentityStorageManager identityStorageManager;
    private IdentityProperties identityProperties;
    private boolean hasBooted;

    IdentityState() {
        this(new IdentityStorageManager(ServiceProvider.getInstance().getDataStoreService()));
    }

    @VisibleForTesting
    IdentityState(IdentityStorageManager identityStorageManager) {
        this.identityStorageManager = identityStorageManager;
        IdentityProperties persistedProperties = identityStorageManager.loadPropertiesFromPersistence();
        this.identityProperties = persistedProperties != null ? persistedProperties : new IdentityProperties();
    }

    @NonNull
    IdentityProperties getIdentityProperties() {
        return this.identityProperties;
    }

    boolean bootupIfReady(SharedStateCallback callback) {
        if (this.hasBooted) {
            return true;
        }
        if (this.identityProperties.getECID() == null) {
            SharedStateResult eventHubStateResult = callback.getSharedState("com.adobe.module.eventhub", null);
            if (eventHubStateResult == null || eventHubStateResult.getStatus() != SharedStateStatus.SET) {
                return false;
            }
            ECID directIdentityEcid = this.identityStorageManager.loadEcidFromDirectIdentityPersistence();
            if (directIdentityEcid != null) {
                this.identityProperties.setECID(directIdentityEcid);
                Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)("On bootup Loading ECID from direct Identity extension '" + directIdentityEcid + "'"), (Object[])new Object[0]);
            } else if (this.isIdentityDirectRegistered(eventHubStateResult.getValue())) {
                SharedStateResult sharedStateResult = callback.getSharedState("com.adobe.module.identity", null);
                if (sharedStateResult == null || sharedStateResult.getStatus() != SharedStateStatus.SET) {
                    Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"On bootup direct Identity extension is registered, waiting for its state change.", (Object[])new Object[0]);
                    return false;
                }
                Map identityDirectSharedState = sharedStateResult.getValue();
                this.handleECIDFromIdentityDirect(EventUtils.getECID(identityDirectSharedState));
            } else {
                this.identityProperties.setECID(new ECID());
                Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)("Generating new ECID on bootup '" + this.identityProperties.getECID().toString() + "'"), (Object[])new Object[0]);
            }
            this.identityStorageManager.savePropertiesToPersistence(this.identityProperties);
        }
        this.hasBooted = true;
        Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Edge Identity has successfully booted up", (Object[])new Object[0]);
        callback.createXDMSharedState(this.identityProperties.toXDMData(), null);
        return this.hasBooted;
    }

    void resetIdentifiers() {
        this.identityProperties = new IdentityProperties();
        this.identityProperties.setECID(new ECID());
        this.identityProperties.setECIDSecondary(null);
        this.identityStorageManager.savePropertiesToPersistence(this.identityProperties);
    }

    void updateCustomerIdentifiers(IdentityMap map) {
        this.identityProperties.updateCustomerIdentifiers(map);
        this.identityStorageManager.savePropertiesToPersistence(this.identityProperties);
    }

    void removeCustomerIdentifiers(IdentityMap map) {
        this.identityProperties.removeCustomerIdentifiers(map);
        this.identityStorageManager.savePropertiesToPersistence(this.identityProperties);
    }

    void updateAdvertisingIdentifier(Event event, SharedStateCallback callback) {
        String currentAdId;
        String newAdId = EventUtils.getAdId(event);
        if (this.identityProperties == null) {
            this.identityProperties = new IdentityProperties();
        }
        if ((currentAdId = this.identityProperties.getAdId()) == null) {
            currentAdId = "";
        }
        if (currentAdId.equals(newAdId)) {
            return;
        }
        this.identityProperties.setAdId(newAdId);
        if (newAdId.isEmpty() || currentAdId.isEmpty()) {
            this.dispatchAdIdConsentRequestEvent(newAdId.isEmpty() ? "n" : "y");
        }
        this.identityStorageManager.savePropertiesToPersistence(this.identityProperties);
        callback.createXDMSharedState(this.identityProperties.toXDMData(), event);
    }

    boolean updateLegacyExperienceCloudId(ECID legacyEcid) {
        ECID ecid = this.identityProperties.getECID();
        ECID ecidSecondary = this.identityProperties.getECIDSecondary();
        if (legacyEcid != null && (legacyEcid.equals(ecid) || legacyEcid.equals(ecidSecondary))) {
            return false;
        }
        if (legacyEcid == null && ecidSecondary == null) {
            return false;
        }
        this.identityProperties.setECIDSecondary(legacyEcid);
        this.identityStorageManager.savePropertiesToPersistence(this.identityProperties);
        Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)("Identity direct ECID updated to '" + legacyEcid + "', updating the IdentityMap"), (Object[])new Object[0]);
        return true;
    }

    private void handleECIDFromIdentityDirect(ECID legacyEcid) {
        if (legacyEcid != null) {
            this.identityProperties.setECID(legacyEcid);
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)("Identity direct ECID '" + legacyEcid + "' was migrated to Edge Identity, updating the IdentityMap"), (Object[])new Object[0]);
        } else {
            this.identityProperties.setECID(new ECID());
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)("Identity direct ECID is null, generating new ECID '" + this.identityProperties.getECID() + "', updating the IdentityMap"), (Object[])new Object[0]);
        }
    }

    private boolean isIdentityDirectRegistered(Map<String, Object> eventHubSharedState) {
        if (eventHubSharedState == null) {
            return false;
        }
        Map extensions = DataReader.optTypedMap(Object.class, eventHubSharedState, (String)"extensions", null);
        Map identityDirectInfo = DataReader.optTypedMap(Object.class, (Map)extensions, (String)"com.adobe.module.identity", null);
        return !MapUtils.isNullOrEmpty((Map)identityDirectInfo);
    }

    private Map<String, Object> buildConsentAdIdRequestData(String consentVal) {
        HashMap<String, String> consentValMap = new HashMap<String, String>();
        consentValMap.put("val", consentVal);
        consentValMap.put("idType", "GAID");
        HashMap<String, HashMap<String, String>> adIDMap = new HashMap<String, HashMap<String, String>>();
        adIDMap.put("adID", consentValMap);
        HashMap<String, Object> consentMap = new HashMap<String, Object>();
        consentMap.put("consents", adIDMap);
        return consentMap;
    }

    private void dispatchAdIdConsentRequestEvent(String consentVal) {
        Map<String, Object> consentData = this.buildConsentAdIdRequestData(consentVal);
        Event consentEvent = new Event.Builder("Consent Update Request for Ad ID", "com.adobe.eventType.edgeConsent", "com.adobe.eventSource.updateConsent").setEventData(consentData).build();
        MobileCore.dispatchEvent((Event)consentEvent);
    }
}

