/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import com.adobe.marketing.mobile.edge.identity.ECID;
import com.adobe.marketing.mobile.edge.identity.IdentityProperties;
import com.adobe.marketing.mobile.services.DataStoring;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.util.JSONUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class IdentityStorageManager {
    private static final String LOG_SOURCE = "IdentityStorageManager";
    private final NamedCollection edgeIdentityStore;
    private final NamedCollection directIdentityStore;

    IdentityStorageManager(DataStoring dataStoreService) {
        this.edgeIdentityStore = dataStoreService.getNamedCollection("com.adobe.edge.identity");
        this.directIdentityStore = dataStoreService.getNamedCollection("visitorIDServiceDataStore");
    }

    IdentityProperties loadPropertiesFromPersistence() {
        if (this.edgeIdentityStore == null) {
            Log.warning((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"EdgeIdentity named collection is null. Unable to load saved identity properties from persistence.", (Object[])new Object[0]);
            return null;
        }
        String jsonString = this.edgeIdentityStore.getString("identity.properties", null);
        if (jsonString == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"No previous properties were stored in persistence. Current identity properties are null", (Object[])new Object[0]);
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            Map propertyMap = JSONUtils.toMap((JSONObject)jsonObject);
            return new IdentityProperties(propertyMap);
        }
        catch (JSONException exception) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Serialization error while reading properties jsonString from persistence. Unable to load saved identity properties from persistence.", (Object[])new Object[0]);
            return null;
        }
    }

    void savePropertiesToPersistence(IdentityProperties properties) {
        if (this.edgeIdentityStore == null) {
            Log.warning((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"EdgeIdentity named collection is null. Unable to write identity properties to persistence.", (Object[])new Object[0]);
            return;
        }
        if (properties == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Identity Properties are null, removing them from persistence.", (Object[])new Object[0]);
            this.edgeIdentityStore.remove("identity.properties");
            return;
        }
        JSONObject jsonObject = new JSONObject(properties.toXDMData());
        String jsonString = jsonObject.toString();
        this.edgeIdentityStore.setString("identity.properties", jsonString);
    }

    ECID loadEcidFromDirectIdentityPersistence() {
        if (this.directIdentityStore == null) {
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)"Identity direct named collection is null. Unable to load ECID from Identity Direct persistence.", (Object[])new Object[0]);
            return null;
        }
        String ecidString = this.directIdentityStore.getString("ADOBEMOBILE_PERSISTED_MID", null);
        return StringUtils.isNullOrEmpty((String)ecidString) ? null : new ECID(ecidString);
    }
}

