/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.edge.identity;

import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;

class URLUtils {
    private static final String LOG_SOURCE = "URLUtils";

    URLUtils() {
    }

    static String generateURLVariablesPayload(String ts, String ecid, String orgId) {
        StringBuilder urlFragment = new StringBuilder();
        try {
            String theIdString = URLUtils.appendKVPToVisitorIdString(null, "TS", ts);
            theIdString = URLUtils.appendKVPToVisitorIdString(theIdString, "MCMID", ecid);
            theIdString = URLUtils.appendKVPToVisitorIdString(theIdString, "MCORGID", orgId);
            urlFragment.append("adobe_mc");
            urlFragment.append("=");
            if (StringUtils.isNullOrEmpty((String)theIdString)) {
                urlFragment.append("null");
            } else {
                urlFragment.append(URLEncoder.encode(theIdString, Charset.forName("UTF-8").name()));
            }
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            urlFragment.append("null");
            Log.debug((String)"EdgeIdentity", (String)LOG_SOURCE, (String)String.format("Failed to encode urlVariable string: %s", e), (Object[])new Object[0]);
        }
        return urlFragment.toString();
    }

    static String appendKVPToVisitorIdString(String originalString, String key, String value) {
        if (StringUtils.isNullOrEmpty((String)key) || StringUtils.isNullOrEmpty((String)value)) {
            return originalString;
        }
        String newUrlVariable = String.format("%s=%s", key, value);
        if (StringUtils.isNullOrEmpty((String)originalString)) {
            return newUrlVariable;
        }
        return String.format("%s|%s", originalString, newUrlVariable);
    }
}

