/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.identity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.identity.IdentityConstants;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Map;

final class ConfigurationSharedStateIdentity {
    private final String orgID;
    private final MobilePrivacyStatus privacyStatus;
    private final String experienceCloudServer;

    ConfigurationSharedStateIdentity(Map<String, Object> sharedState) {
        this.orgID = DataReader.optString(sharedState, (String)"experienceCloud.org", null);
        String server = DataReader.optString(sharedState, (String)"experienceCloud.server", (String)"dpm.demdex.net");
        this.experienceCloudServer = StringUtils.isNullOrEmpty((String)server) ? "dpm.demdex.net" : server;
        this.privacyStatus = MobilePrivacyStatus.fromString((String)DataReader.optString(sharedState, (String)"global.privacy", (String)IdentityConstants.Defaults.DEFAULT_MOBILE_PRIVACY.getValue()));
    }

    @Nullable
    String getOrgID() {
        return this.orgID;
    }

    @NonNull
    MobilePrivacyStatus getPrivacyStatus() {
        return this.privacyStatus;
    }

    @NonNull
    String getExperienceCloudServer() {
        return this.experienceCloudServer;
    }

    boolean canSyncIdentifiersWithCurrentConfiguration() {
        return !StringUtils.isNullOrEmpty((String)this.orgID) && this.privacyStatus != MobilePrivacyStatus.OPT_OUT;
    }
}

