/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.widget.RemoteViews;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AEPPushNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationCompatBuilderExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.RemoteViewsExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.BasicPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.NotificationData;
import com.adobe.marketing.mobile.services.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\fJ9\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0013JA\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/BasicNotificationBuilder;", "", "()V", "SELF_TAG", "", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/BasicPushTemplate;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "broadcastReceiverClass", "Landroid/content/BroadcastReceiver;", "createRemindPendingIntent", "Landroid/app/PendingIntent;", "channelId", "createRemindPendingIntent$notificationbuilder_phoneRelease", "fallbackToBasicNotification", "data", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;", "fallbackToBasicNotification$notificationbuilder_phoneRelease", "notificationbuilder_phoneRelease"})
public final class BasicNotificationBuilder {
    @NotNull
    public static final BasicNotificationBuilder INSTANCE = new BasicNotificationBuilder();
    @NotNull
    private static final String SELF_TAG = "BasicNotificationBuilder";

    private BasicNotificationBuilder() {
    }

    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull BasicPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) throws NotificationConstructionFailedException {
        NotificationCompat.Builder notificationBuilder;
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Building a basic template push notification.", (Object[])new Object[0]);
            String packageName = context.getPackageName();
            RemoteViews smallLayout = new RemoteViews(packageName, R.layout.push_template_collapsed);
            RemoteViews expandedLayout = new RemoteViews(packageName, R.layout.push_template_expanded);
            Object object = context.getSystemService("notification");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
            NotificationManager notificationManager = (NotificationManager)object;
            String channelIdToUse = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, pushTemplate);
            notificationBuilder = AEPPushNotificationBuilder.INSTANCE.construct(context, pushTemplate, channelIdToUse, trackerActivityClass, smallLayout, expandedLayout, R.id.basic_expanded_layout);
            RemoteViewsExtensionsKt.setRemoteViewImage(expandedLayout, pushTemplate.getImageUrl$notificationbuilder_phoneRelease(), R.id.expanded_template_image);
            NotificationCompatBuilderExtensionsKt.addActionButtons(notificationBuilder, context, trackerActivityClass, pushTemplate.getActionButtonsList$notificationbuilder_phoneRelease(), pushTemplate.getData().getBundle());
            String string = pushTemplate.getRemindLaterText$notificationbuilder_phoneRelease();
            if (string == null) break block1;
            String remindLaterText = string;
            boolean bl = false;
            if (pushTemplate.getRemindLaterTimestamp$notificationbuilder_phoneRelease() != null || pushTemplate.getRemindLaterDuration$notificationbuilder_phoneRelease() != null) {
                PendingIntent remindIntent = INSTANCE.createRemindPendingIntent$notificationbuilder_phoneRelease(context, broadcastReceiverClass, channelIdToUse, pushTemplate);
                notificationBuilder.addAction(0, (CharSequence)remindLaterText, remindIntent);
            }
        }
        return notificationBuilder;
    }

    @NotNull
    public final NotificationCompat.Builder fallbackToBasicNotification$notificationbuilder_phoneRelease(@NotNull Context context, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass, @NotNull NotificationData data) throws NotificationConstructionFailedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BasicPushTemplate basicPushTemplate = new BasicPushTemplate(data);
        return this.construct(context, basicPushTemplate, trackerActivityClass, broadcastReceiverClass);
    }

    @VisibleForTesting
    @Nullable
    public final PendingIntent createRemindPendingIntent$notificationbuilder_phoneRelease(@NotNull Context context, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass, @NotNull String channelId, @NotNull BasicPushTemplate pushTemplate) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        if (broadcastReceiverClass == null) {
            return null;
        }
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Creating a remind later pending intent from a push template object.", (Object[])new Object[0]);
        Intent remindIntent = AEPPushNotificationBuilder.INSTANCE.createIntent$notificationbuilder_phoneRelease("remind_clicked", pushTemplate);
        remindIntent.putExtra("adb_channel_id", channelId);
        Class<? extends BroadcastReceiver> it = broadcastReceiverClass;
        boolean bl = false;
        remindIntent.setClass(context.getApplicationContext(), broadcastReceiverClass);
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)remindIntent, (int)0xA000000);
    }
}

