/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.PushTemplateImageUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AEPPushNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.BasicNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.RemoteViewsExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.CarouselPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.ManualCarouselPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\fJ<\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0001\u00a2\u0006\u0002\b\u0018J/\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001dJ*\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0002J*\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0002J_\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b(JW\u0010)\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010*\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b+Jd\u0010,\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0006\u0010&\u001a\u00020'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0002J:\u0010-\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/ManualCarouselNotificationBuilder;", "", "()V", "SELF_TAG", "", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ManualCarouselPushTemplate;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "broadcastReceiverClass", "Landroid/content/BroadcastReceiver;", "createCarouselNavigationClickPendingIntent", "Landroid/app/PendingIntent;", "intentAction", "channelId", "downloadCarouselItems", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/CarouselPushTemplate$CarouselItem;", "items", "downloadCarouselItems$notificationbuilder_phoneRelease", "getCarouselIndices", "Lkotlin/Triple;", "", "carouselSize", "getCarouselIndices$notificationbuilder_phoneRelease", "getNewIndicesForNavigateLeft", "centerIndex", "listSize", "getNewIndicesForNavigateRight", "populateFilmstripCarouselImages", "", "validCarouselItems", "newIndices", "expandedLayout", "Landroid/widget/RemoteViews;", "populateFilmstripCarouselImages$notificationbuilder_phoneRelease", "populateManualCarouselImages", "packageName", "populateManualCarouselImages$notificationbuilder_phoneRelease", "setupCarouselImages", "setupNavigationButtons", "notificationbuilder_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nManualCarouselNotificationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualCarouselNotificationBuilder.kt\ncom/adobe/marketing/mobile/notificationbuilder/internal/builders/ManualCarouselNotificationBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,474:1\n1549#2:475\n1620#2,3:476\n*S KotlinDebug\n*F\n+ 1 ManualCarouselNotificationBuilder.kt\ncom/adobe/marketing/mobile/notificationbuilder/internal/builders/ManualCarouselNotificationBuilder\n*L\n53#1:475\n53#1:476,3\n*E\n"})
public final class ManualCarouselNotificationBuilder {
    @NotNull
    public static final ManualCarouselNotificationBuilder INSTANCE = new ManualCarouselNotificationBuilder();
    @NotNull
    private static final String SELF_TAG = "ManualCarouselNotificationBuilder";

    private ManualCarouselNotificationBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull ManualCarouselPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) throws NotificationConstructionFailedException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Building a manual carousel template push notification.", (Object[])new Object[0]);
        Iterable iterable = pushTemplate.getCarouselItems$notificationbuilder_phoneRelease();
        PushTemplateImageUtils pushTemplateImageUtils = PushTemplateImageUtils.INSTANCE;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CarouselPushTemplate.CarouselItem carouselItem = (CarouselPushTemplate.CarouselItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getImageUri());
        }
        int downloadedImagesCount = pushTemplateImageUtils.cacheImages$notificationbuilder_phoneRelease((List)destination$iv$iv);
        if (downloadedImagesCount < 3) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"Less than 3 images are available for the manual carousel push template, falling back to a basic push template.", (Object[])new Object[0]);
            return BasicNotificationBuilder.INSTANCE.fallbackToBasicNotification$notificationbuilder_phoneRelease(context, trackerActivityClass, broadcastReceiverClass, pushTemplate.getData());
        }
        String packageName = context.getPackageName();
        RemoteViews smallLayout = new RemoteViews(packageName, R.layout.push_template_collapsed);
        RemoteViews expandedLayout = Intrinsics.areEqual((Object)pushTemplate.getCarouselLayout$notificationbuilder_phoneRelease(), (Object)"filmstrip") ? new RemoteViews(packageName, R.layout.push_template_filmstrip_carousel) : new RemoteViews(packageName, R.layout.push_template_manual_carousel);
        List<CarouselPushTemplate.CarouselItem> validCarouselItems = this.downloadCarouselItems$notificationbuilder_phoneRelease(pushTemplate.getCarouselItems$notificationbuilder_phoneRelease());
        Triple<Integer, Integer, Integer> carouselIndices = this.getCarouselIndices$notificationbuilder_phoneRelease(pushTemplate, validCarouselItems.size());
        pushTemplate.setCenterImageIndex$notificationbuilder_phoneRelease(((Number)carouselIndices.getSecond()).intValue());
        this.setupCarouselImages(context, carouselIndices, pushTemplate, trackerActivityClass, expandedLayout, validCarouselItems, packageName);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        String channelIdToUse = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, pushTemplate);
        NotificationCompat.Builder notificationBuilder = AEPPushNotificationBuilder.INSTANCE.construct(context, pushTemplate, channelIdToUse, trackerActivityClass, smallLayout, expandedLayout, R.id.carousel_container_layout);
        this.setupNavigationButtons(context, pushTemplate, broadcastReceiverClass, expandedLayout, channelIdToUse);
        return notificationBuilder;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final List<CarouselPushTemplate.CarouselItem> downloadCarouselItems$notificationbuilder_phoneRelease(@NotNull List<CarouselPushTemplate.CarouselItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        List validCarouselItems = new ArrayList();
        for (CarouselPushTemplate.CarouselItem item : items) {
            String imageUri = item.getImageUri();
            Bitmap pushImage = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(imageUri);
            if (pushImage == null) {
                Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Failed to retrieve an image from " + imageUri + ", will not create a new carousel item."), (Object[])new Object[0]);
                continue;
            }
            validCarouselItems.add(item);
        }
        return validCarouselItems;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Triple<Integer, Integer, Integer> getCarouselIndices$notificationbuilder_phoneRelease(@NotNull ManualCarouselPushTemplate pushTemplate, int carouselSize) {
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Object carouselIndices = null;
        String string = pushTemplate.getIntentAction$notificationbuilder_phoneRelease();
        carouselIndices = (string != null ? ((CharSequence)string).length() > 0 : false) ? (Intrinsics.areEqual((Object)pushTemplate.getIntentAction$notificationbuilder_phoneRelease(), (Object)"manual_left") || Intrinsics.areEqual((Object)pushTemplate.getIntentAction$notificationbuilder_phoneRelease(), (Object)"filmstrip_left") ? this.getNewIndicesForNavigateLeft(pushTemplate.getCenterImageIndex$notificationbuilder_phoneRelease(), carouselSize) : this.getNewIndicesForNavigateRight(pushTemplate.getCenterImageIndex$notificationbuilder_phoneRelease(), carouselSize)) : (Intrinsics.areEqual((Object)pushTemplate.getCarouselLayout$notificationbuilder_phoneRelease(), (Object)"filmstrip") ? new Triple((Object)0, (Object)1, (Object)2) : new Triple((Object)(carouselSize - 1), (Object)0, (Object)1));
        return carouselIndices;
    }

    private final void setupCarouselImages(Context context, Triple<Integer, Integer, Integer> newIndices, ManualCarouselPushTemplate pushTemplate, Class<? extends Activity> trackerActivityClass, RemoteViews expandedLayout, List<CarouselPushTemplate.CarouselItem> validCarouselItems, String packageName) {
        if (Intrinsics.areEqual((Object)pushTemplate.getCarouselLayout$notificationbuilder_phoneRelease(), (Object)"filmstrip")) {
            this.populateFilmstripCarouselImages$notificationbuilder_phoneRelease(context, validCarouselItems, newIndices, pushTemplate, trackerActivityClass, expandedLayout);
        } else {
            this.populateManualCarouselImages$notificationbuilder_phoneRelease(context, validCarouselItems, packageName, ((Number)newIndices.getSecond()).intValue(), pushTemplate, trackerActivityClass, expandedLayout);
        }
    }

    private final void setupNavigationButtons(Context context, ManualCarouselPushTemplate pushTemplate, Class<? extends BroadcastReceiver> broadcastReceiverClass, RemoteViews expandedLayout, String channelId) {
        Pair clickPair = Intrinsics.areEqual((Object)pushTemplate.getCarouselLayout$notificationbuilder_phoneRelease(), (Object)"default") ? new Pair((Object)"manual_left", (Object)"manual_right") : new Pair((Object)"filmstrip_left", (Object)"filmstrip_right");
        PendingIntent pendingIntentLeftButton = this.createCarouselNavigationClickPendingIntent(context, pushTemplate, (String)clickPair.getFirst(), broadcastReceiverClass, channelId);
        PendingIntent pendingIntentRightButton = this.createCarouselNavigationClickPendingIntent(context, pushTemplate, (String)clickPair.getSecond(), broadcastReceiverClass, channelId);
        expandedLayout.setOnClickPendingIntent(R.id.leftImageButton, pendingIntentLeftButton);
        expandedLayout.setOnClickPendingIntent(R.id.rightImageButton, pendingIntentRightButton);
    }

    @VisibleForTesting(otherwise=2)
    public final void populateManualCarouselImages$notificationbuilder_phoneRelease(@NotNull Context context, @NotNull List<CarouselPushTemplate.CarouselItem> items, @Nullable String packageName, int centerIndex, @NotNull ManualCarouselPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass, @NotNull RemoteViews expandedLayout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Intrinsics.checkNotNullParameter((Object)expandedLayout, (String)"expandedLayout");
        for (CarouselPushTemplate.CarouselItem item : items) {
            String interactionUri;
            String imageUri = item.getImageUri();
            Bitmap pushImage = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(imageUri);
            if (pushImage == null) {
                Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Failed to retrieve an image from " + imageUri + ", will not create a new carousel item."), (Object[])new Object[0]);
                continue;
            }
            RemoteViews carouselItemRemoteView = new RemoteViews(packageName, R.layout.push_template_carousel_item);
            carouselItemRemoteView.setImageViewBitmap(R.id.carousel_item_image_view, pushImage);
            carouselItemRemoteView.setTextViewText(R.id.carousel_item_caption, (CharSequence)item.getCaptionText());
            CharSequence charSequence = item.getInteractionUri();
            String string = interactionUri = charSequence == null || charSequence.length() == 0 ? pushTemplate.getActionUri$notificationbuilder_phoneRelease() : item.getInteractionUri();
            if (interactionUri != null) {
                boolean bl = false;
                RemoteViewsExtensionsKt.setRemoteViewClickAction(carouselItemRemoteView, context, trackerActivityClass, R.id.carousel_item_image_view, interactionUri, null, pushTemplate.getData().getBundle());
            }
            expandedLayout.addView(R.id.manual_carousel_view_flipper, carouselItemRemoteView);
            expandedLayout.setDisplayedChild(R.id.manual_carousel_view_flipper, centerIndex);
        }
    }

    @VisibleForTesting(otherwise=2)
    public final void populateFilmstripCarouselImages$notificationbuilder_phoneRelease(@NotNull Context context, @NotNull List<CarouselPushTemplate.CarouselItem> validCarouselItems, @NotNull Triple<Integer, Integer, Integer> newIndices, @NotNull ManualCarouselPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass, @NotNull RemoteViews expandedLayout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(validCarouselItems, (String)"validCarouselItems");
        Intrinsics.checkNotNullParameter(newIndices, (String)"newIndices");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Intrinsics.checkNotNullParameter((Object)expandedLayout, (String)"expandedLayout");
        String centerCaptionText = validCarouselItems.get(((Number)newIndices.getSecond()).intValue()).getCaptionText();
        expandedLayout.setTextViewText(R.id.manual_carousel_filmstrip_caption, (CharSequence)centerCaptionText);
        String assetCacheLocation = PushTemplateImageUtils.INSTANCE.getAssetCacheLocation$notificationbuilder_phoneRelease();
        CharSequence charSequence = assetCacheLocation;
        if (charSequence == null || charSequence.length() == 0) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"Asset cache location is null or empty, unable to retrieve filmstrip carousel images.", (Object[])new Object[0]);
            return;
        }
        Bitmap newLeftImage = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(validCarouselItems.get(((Number)newIndices.getFirst()).intValue()).getImageUri());
        expandedLayout.setImageViewBitmap(R.id.manual_carousel_filmstrip_left, newLeftImage);
        Bitmap newCenterImage = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(validCarouselItems.get(((Number)newIndices.getSecond()).intValue()).getImageUri());
        expandedLayout.setImageViewBitmap(R.id.manual_carousel_filmstrip_center, newCenterImage);
        Bitmap newRightImage = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(validCarouselItems.get(((Number)newIndices.getThird()).intValue()).getImageUri());
        expandedLayout.setImageViewBitmap(R.id.manual_carousel_filmstrip_right, newRightImage);
        CharSequence charSequence2 = validCarouselItems.get(((Number)newIndices.getSecond()).intValue()).getInteractionUri();
        String interactionUri = !(charSequence2 == null || charSequence2.length() == 0) ? validCarouselItems.get(((Number)newIndices.getSecond()).intValue()).getInteractionUri() : pushTemplate.getActionUri$notificationbuilder_phoneRelease();
        RemoteViewsExtensionsKt.setRemoteViewClickAction(expandedLayout, context, trackerActivityClass, R.id.manual_carousel_filmstrip_center, interactionUri, null, pushTemplate.getData().getBundle());
    }

    private final Triple<Integer, Integer, Integer> getNewIndicesForNavigateLeft(int centerIndex, int listSize) {
        int newCenterIndex = (centerIndex - 1 + listSize) % listSize;
        int newLeftIndex = (newCenterIndex - 1 + listSize) % listSize;
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Calculated new indices. New center index is " + newCenterIndex + ", new left index is " + newLeftIndex + ", and new right index is " + centerIndex + '.'), (Object[])new Object[0]);
        return new Triple((Object)newLeftIndex, (Object)newCenterIndex, (Object)centerIndex);
    }

    private final Triple<Integer, Integer, Integer> getNewIndicesForNavigateRight(int centerIndex, int listSize) {
        int newCenterIndex = (centerIndex + 1) % listSize;
        int newRightIndex = (newCenterIndex + 1) % listSize;
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Calculated new indices. New center index is " + newCenterIndex + ", new left index is " + centerIndex + ", and new right index is " + newRightIndex + '.'), (Object[])new Object[0]);
        return new Triple((Object)centerIndex, (Object)newCenterIndex, (Object)newRightIndex);
    }

    private final PendingIntent createCarouselNavigationClickPendingIntent(Context context, ManualCarouselPushTemplate pushTemplate, String intentAction, Class<? extends BroadcastReceiver> broadcastReceiverClass, String channelId) {
        if (broadcastReceiverClass == null) {
            return null;
        }
        Intent clickIntent = AEPPushNotificationBuilder.INSTANCE.createIntent$notificationbuilder_phoneRelease(intentAction, pushTemplate);
        clickIntent.putExtra("adb_channel_id", channelId);
        clickIntent.putExtra("centerImageIndex", String.valueOf(pushTemplate.getCenterImageIndex$notificationbuilder_phoneRelease()));
        Class<? extends BroadcastReceiver> it = broadcastReceiverClass;
        boolean bl = false;
        clickIntent.setClass(context, broadcastReceiverClass);
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)clickIntent, (int)0xA000000);
    }
}

