/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.PendingIntentUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.PushTemplateImageUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AEPPushNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.RemoteViewsExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.ProductCatalogPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000e2\u0010\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000eJ<\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J2\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002JH\u0010\u001a\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002J2\u0010\u001f\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010 \u001a\u00020\u0017*\u00020\u00192\u0006\u0010!\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010#\u001a\u00020\u0017*\u00020\u00192\u0006\u0010!\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/ProductCatalogNotificationBuilder;", "", "()V", "SELF_TAG", "", "downloadedImageCount", "", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductCatalogPushTemplate;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "broadcastReceiverClass", "Landroid/content/BroadcastReceiver;", "createThumbnailInteractionPendingIntent", "Landroid/app/PendingIntent;", "channelId", "currentIndex", "populateCenterImage", "", "expandedLayout", "Landroid/widget/RemoteViews;", "populateThumbnails", "channelIdToUse", "catalogItems", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductCatalogPushTemplate$CatalogItem;", "setupCtaButton", "setCtaButtonColor", "containerViewId", "buttonColor", "setCtaButtonTextColor", "buttonTextColor", "notificationbuilder_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nProductCatalogNotificationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductCatalogNotificationBuilder.kt\ncom/adobe/marketing/mobile/notificationbuilder/internal/builders/ProductCatalogNotificationBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n1549#2:340\n1620#2,3:341\n*S KotlinDebug\n*F\n+ 1 ProductCatalogNotificationBuilder.kt\ncom/adobe/marketing/mobile/notificationbuilder/internal/builders/ProductCatalogNotificationBuilder\n*L\n53#1:340\n53#1:341,3\n*E\n"})
public final class ProductCatalogNotificationBuilder {
    @NotNull
    public static final ProductCatalogNotificationBuilder INSTANCE = new ProductCatalogNotificationBuilder();
    @NotNull
    private static final String SELF_TAG = "ProductCatalogNotificationBuilder";
    private static int downloadedImageCount;

    private ProductCatalogNotificationBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull ProductCatalogPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) throws NotificationConstructionFailedException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Building a product catalog push notification.", (Object[])new Object[0]);
        Iterable $this$map$iv = pushTemplate.getCatalogItems$notificationbuilder_phoneRelease();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProductCatalogPushTemplate.CatalogItem catalogItem = (ProductCatalogPushTemplate.CatalogItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getImg());
        }
        List catalogImageUris = (List)destination$iv$iv;
        downloadedImageCount = PushTemplateImageUtils.INSTANCE.cacheImages$notificationbuilder_phoneRelease(catalogImageUris);
        if (downloadedImageCount != catalogImageUris.size()) {
            Log.error((String)"PushTemplates", (String)SELF_TAG, (String)"Failed to download all images for the product catalog notification.", (Object[])new Object[0]);
            throw new NotificationConstructionFailedException("Failed to download all images for the product catalog notification.");
        }
        String packageName = context.getPackageName();
        RemoteViews smallLayout = new RemoteViews(packageName, R.layout.push_template_collapsed);
        RemoteViews expandedLayout = Intrinsics.areEqual((Object)pushTemplate.getDisplayLayout$notificationbuilder_phoneRelease(), (Object)"vertical") ? new RemoteViews(packageName, R.layout.push_tempate_vertical_catalog) : new RemoteViews(packageName, R.layout.push_template_horizontal_catalog);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        String channelIdToUse = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, pushTemplate);
        NotificationCompat.Builder notificationBuilder = AEPPushNotificationBuilder.INSTANCE.construct(context, pushTemplate, channelIdToUse, trackerActivityClass, smallLayout, expandedLayout, R.id.catalog_container_layout);
        List<ProductCatalogPushTemplate.CatalogItem> catalogItems = pushTemplate.getCatalogItems$notificationbuilder_phoneRelease();
        this.populateCenterImage(context, trackerActivityClass, expandedLayout, pushTemplate);
        expandedLayout.setTextViewText(R.id.product_title, (CharSequence)catalogItems.get(pushTemplate.getCurrentIndex$notificationbuilder_phoneRelease()).getTitle());
        expandedLayout.setTextViewText(R.id.product_description, (CharSequence)catalogItems.get(pushTemplate.getCurrentIndex$notificationbuilder_phoneRelease()).getBody());
        expandedLayout.setTextViewText(R.id.product_price, (CharSequence)catalogItems.get(pushTemplate.getCurrentIndex$notificationbuilder_phoneRelease()).getPrice());
        this.setupCtaButton(context, trackerActivityClass, expandedLayout, pushTemplate);
        this.populateThumbnails(context, broadcastReceiverClass, channelIdToUse, expandedLayout, catalogItems, pushTemplate);
        return notificationBuilder;
    }

    private final void populateCenterImage(Context context, Class<? extends Activity> trackerActivityClass, RemoteViews expandedLayout, ProductCatalogPushTemplate pushTemplate) {
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Populating center image for product catalog notification.", (Object[])new Object[0]);
        Bitmap pushImage = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(pushTemplate.getCatalogItems$notificationbuilder_phoneRelease().get(pushTemplate.getCurrentIndex$notificationbuilder_phoneRelease()).getImg());
        expandedLayout.setImageViewBitmap(R.id.product_image, pushImage);
        expandedLayout.setOnClickPendingIntent(R.id.product_image, PendingIntentUtils.INSTANCE.createPendingIntentForTrackerActivity$notificationbuilder_phoneRelease(context, trackerActivityClass, pushTemplate.getCatalogItems$notificationbuilder_phoneRelease().get(pushTemplate.getCurrentIndex$notificationbuilder_phoneRelease()).getUri(), "product_image_clicked", pushTemplate.getData().getBundle()));
    }

    private final void populateThumbnails(Context context, Class<? extends BroadcastReceiver> broadcastReceiverClass, String channelIdToUse, RemoteViews expandedLayout, List<ProductCatalogPushTemplate.CatalogItem> catalogItems, ProductCatalogPushTemplate pushTemplate) {
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Populating product catalog thumbnails.", (Object[])new Object[0]);
        Object[] objectArray = new Integer[]{R.id.product_thumbnail_1, R.id.product_thumbnail_2, R.id.product_thumbnail_3};
        List thumbIds = CollectionsKt.listOf((Object[])objectArray);
        int n = catalogItems.size();
        for (int index = 0; index < n; ++index) {
            Bitmap thumbImage = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(catalogItems.get(index).getImg());
            if (thumbImage == null) {
                Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"No image found for catalog item thumbnail.", (Object[])new Object[0]);
                throw new NotificationConstructionFailedException("No image found for catalog item thumbnail.");
            }
            expandedLayout.setImageViewBitmap(((Number)thumbIds.get(index)).intValue(), thumbImage);
            PendingIntent pendingIntentThumbnailInteraction = this.createThumbnailInteractionPendingIntent(context, broadcastReceiverClass, channelIdToUse, pushTemplate, index);
            expandedLayout.setOnClickPendingIntent(((Number)thumbIds.get(index)).intValue(), pendingIntentThumbnailInteraction);
        }
    }

    private final void setupCtaButton(Context context, Class<? extends Activity> trackerActivityClass, RemoteViews expandedLayout, ProductCatalogPushTemplate pushTemplate) {
        this.setCtaButtonColor(expandedLayout, R.id.cta_button, pushTemplate.getCtaButtonColor$notificationbuilder_phoneRelease());
        expandedLayout.setTextViewText(R.id.cta_button, (CharSequence)pushTemplate.getCtaButtonText$notificationbuilder_phoneRelease());
        this.setCtaButtonTextColor(expandedLayout, R.id.cta_button, pushTemplate.getCtaButtonTextColor$notificationbuilder_phoneRelease());
        expandedLayout.setOnClickPendingIntent(R.id.cta_button, PendingIntentUtils.INSTANCE.createPendingIntentForTrackerActivity$notificationbuilder_phoneRelease(context, trackerActivityClass, pushTemplate.getCtaButtonUri$notificationbuilder_phoneRelease(), "cta_button_clicked", pushTemplate.getData().getBundle()));
    }

    private final void setCtaButtonColor(RemoteViews $this$setCtaButtonColor, int containerViewId, String buttonColor) {
        RemoteViewsExtensionsKt.setElementColor($this$setCtaButtonColor, containerViewId, '#' + buttonColor, "setBackgroundColor", "product catalog cta button");
    }

    private final void setCtaButtonTextColor(RemoteViews $this$setCtaButtonTextColor, int containerViewId, String buttonTextColor) {
        RemoteViewsExtensionsKt.setElementColor($this$setCtaButtonTextColor, containerViewId, '#' + buttonTextColor, "setTextColor", "product catalog cta button");
    }

    private final PendingIntent createThumbnailInteractionPendingIntent(Context context, Class<? extends BroadcastReceiver> broadcastReceiverClass, String channelId, ProductCatalogPushTemplate pushTemplate, int currentIndex) {
        Intent intent;
        if (broadcastReceiverClass == null) {
            return null;
        }
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Creating a thumbnail interaction pending intent for thumbnail at index " + currentIndex), (Object[])new Object[0]);
        Intent $this$createThumbnailInteractionPendingIntent_u24lambda_u241 = intent = AEPPushNotificationBuilder.INSTANCE.createIntent$notificationbuilder_phoneRelease("thumbnail_clicked", pushTemplate);
        boolean bl = false;
        $this$createThumbnailInteractionPendingIntent_u24lambda_u241.setClass(context.getApplicationContext(), broadcastReceiverClass);
        $this$createThumbnailInteractionPendingIntent_u24lambda_u241.putExtra("adb_channel_id", channelId);
        $this$createThumbnailInteractionPendingIntent_u24lambda_u241.putExtra("catalogItemIndex", String.valueOf(currentIndex));
        Intent thumbnailClickIntent = intent;
        String string = pushTemplate.getTag$notificationbuilder_phoneRelease();
        return PendingIntent.getBroadcast((Context)context, (int)((string != null ? string.hashCode() : 0) + currentIndex), (Intent)thumbnailClickIntent, (int)0xA000000);
    }
}

