/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.internal.PushTemplateType;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AutoCarouselNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.BasicNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.InputBoxNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.LegacyNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.ManualCarouselNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.MultiIconNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.ProductCatalogNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.ProductRatingNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.TimerNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.ZeroBezelNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AutoCarouselPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.BasicPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.CarouselPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.InputBoxPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.ManualCarouselPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.MultiIconPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.ProductCatalogPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.ProductRatingPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.TimerPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.ZeroBezelPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.IntentData;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.MapData;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.NotificationData;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\u000bH\u0007J@\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\u000bH\u0007J<\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/NotificationBuilder;", "", "()V", "SELF_TAG", "", "VERSION", "constructNotificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "intent", "Landroid/content/Intent;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "broadcastReceiverClass", "Landroid/content/BroadcastReceiver;", "messageData", "", "createNotificationBuilder", "context", "Landroid/content/Context;", "notificationData", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;", "version", "notificationbuilder_phoneRelease"})
public final class NotificationBuilder {
    @NotNull
    public static final NotificationBuilder INSTANCE = new NotificationBuilder();
    @NotNull
    private static final String SELF_TAG = "NotificationBuilder";
    @NotNull
    private static final String VERSION = "3.0.1";

    private NotificationBuilder() {
    }

    @JvmStatic
    @NotNull
    public static final String version() {
        return VERSION;
    }

    @JvmStatic
    @NotNull
    public static final NotificationCompat.Builder constructNotificationBuilder(@NotNull Map<String, String> messageData, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) throws NotificationConstructionFailedException, IllegalArgumentException {
        Intrinsics.checkNotNullParameter(messageData, (String)"messageData");
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            throw new NotificationConstructionFailedException("Application context is null, cannot build a notification.");
        }
        Context context2 = context;
        if (messageData.isEmpty()) {
            throw new NotificationConstructionFailedException("Message data is empty, cannot build a notification.");
        }
        MapData notificationData = new MapData(messageData);
        return INSTANCE.createNotificationBuilder(context2, notificationData, trackerActivityClass, broadcastReceiverClass);
    }

    @JvmStatic
    @NotNull
    public static final NotificationCompat.Builder constructNotificationBuilder(@NotNull Intent intent, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) throws NotificationConstructionFailedException, IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            throw new NotificationConstructionFailedException("Application context is null, cannot build a notification.");
        }
        Context context2 = context;
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            throw new NotificationConstructionFailedException("Intent extras are null, cannot re-build the notification.");
        }
        Bundle extras = bundle;
        IntentData intentData = new IntentData(extras, intent.getAction());
        return INSTANCE.createNotificationBuilder(context2, intentData, trackerActivityClass, broadcastReceiverClass);
    }

    private final NotificationCompat.Builder createNotificationBuilder(Context context, NotificationData notificationData, Class<? extends Activity> trackerActivityClass, Class<? extends BroadcastReceiver> broadcastReceiverClass) {
        PushTemplateType pushTemplateType = PushTemplateType.Companion.fromString(notificationData.getString("adb_template_type"));
        switch (WhenMappings.$EnumSwitchMapping$0[pushTemplateType.ordinal()]) {
            case 1: {
                BasicPushTemplate basicPushTemplate = new BasicPushTemplate(notificationData);
                return BasicNotificationBuilder.INSTANCE.construct(context, basicPushTemplate, trackerActivityClass, broadcastReceiverClass);
            }
            case 2: {
                CarouselPushTemplate carouselPushTemplate;
                CarouselPushTemplate carouselPushTemplate2 = carouselPushTemplate = CarouselPushTemplate.Companion.invoke(notificationData);
                if (carouselPushTemplate2 instanceof AutoCarouselPushTemplate) {
                    return AutoCarouselNotificationBuilder.INSTANCE.construct(context, (AutoCarouselPushTemplate)carouselPushTemplate, trackerActivityClass, broadcastReceiverClass);
                }
                if (carouselPushTemplate2 instanceof ManualCarouselPushTemplate) {
                    return ManualCarouselNotificationBuilder.INSTANCE.construct(context, (ManualCarouselPushTemplate)carouselPushTemplate, trackerActivityClass, broadcastReceiverClass);
                }
                Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"Unknown carousel push template type, creating a legacy style notification.", (Object[])new Object[0]);
                return LegacyNotificationBuilder.INSTANCE.construct(context, new BasicPushTemplate(notificationData), trackerActivityClass);
            }
            case 3: {
                ZeroBezelPushTemplate zeroBezelPushTemplate = new ZeroBezelPushTemplate(notificationData);
                return ZeroBezelNotificationBuilder.INSTANCE.construct(context, zeroBezelPushTemplate, trackerActivityClass);
            }
            case 4: {
                return InputBoxNotificationBuilder.INSTANCE.construct(context, new InputBoxPushTemplate(notificationData), trackerActivityClass, broadcastReceiverClass);
            }
            case 5: {
                return ProductCatalogNotificationBuilder.INSTANCE.construct(context, new ProductCatalogPushTemplate(notificationData), trackerActivityClass, broadcastReceiverClass);
            }
            case 6: {
                return ProductRatingNotificationBuilder.INSTANCE.construct(context, new ProductRatingPushTemplate(notificationData), trackerActivityClass, broadcastReceiverClass);
            }
            case 7: {
                return TimerNotificationBuilder.INSTANCE.construct(context, new TimerPushTemplate(notificationData), trackerActivityClass, broadcastReceiverClass);
            }
            case 8: {
                return MultiIconNotificationBuilder.INSTANCE.construct(context, new MultiIconPushTemplate(notificationData), trackerActivityClass);
            }
            case 9: {
                return LegacyNotificationBuilder.INSTANCE.construct(context, new BasicPushTemplate(notificationData), trackerActivityClass);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PushTemplateType.values().length];
            try {
                nArray[PushTemplateType.BASIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushTemplateType.CAROUSEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushTemplateType.ZERO_BEZEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushTemplateType.INPUT_BOX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushTemplateType.PRODUCT_CATALOG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushTemplateType.PRODUCT_RATING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushTemplateType.TIMER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushTemplateType.MULTI_ICON.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushTemplateType.UNKNOWN.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

