/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.core.app.NotificationManagerCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.internal.PendingIntentUtils;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.TimeUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/RemindLaterHandler;", "", "()V", "SELF_TAG", "", "handleRemindIntent", "", "remindLaterIntent", "Landroid/content/Intent;", "broadcastReceiverClass", "Ljava/lang/Class;", "Landroid/content/BroadcastReceiver;", "notificationbuilder_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nRemindLaterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemindLaterHandler.kt\ncom/adobe/marketing/mobile/notificationbuilder/RemindLaterHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class RemindLaterHandler {
    @NotNull
    public static final RemindLaterHandler INSTANCE = new RemindLaterHandler();
    @NotNull
    private static final String SELF_TAG = "RemindLaterHandler";

    private RemindLaterHandler() {
    }

    @JvmStatic
    public static final void handleRemindIntent(@NotNull Intent remindLaterIntent, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) throws NotificationConstructionFailedException, IllegalArgumentException {
        block6: {
            long triggerTimeInSeconds;
            Intrinsics.checkNotNullParameter((Object)remindLaterIntent, (String)"remindLaterIntent");
            Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
            if (context == null) {
                throw new NotificationConstructionFailedException("Application context is null, cannot schedule notification for later.");
            }
            Context context2 = context;
            Bundle bundle = remindLaterIntent.getExtras();
            if (bundle == null) {
                throw new NotificationConstructionFailedException("Intent extras are null, cannot schedule notification for later.");
            }
            Bundle intentExtras = bundle;
            Object object = intentExtras.getString("adb_rem_ts");
            long remindLaterTimestamp = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
            Object object2 = intentExtras.getString("adb_rem_sec");
            long remindLaterDuration = object2 != null && (object2 = StringsKt.toLongOrNull((String)object2)) != null ? (Long)object2 : 0L;
            long secondsUntilFireDate = remindLaterDuration > 0L ? remindLaterDuration : remindLaterTimestamp - TimeUtils.getUnixTimeInSeconds();
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context2);
            Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(context)");
            NotificationManagerCompat notificationManager = notificationManagerCompat;
            String tag = intentExtras.getString("adb_tag");
            if (secondsUntilFireDate <= 0L) {
                String string = tag;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    notificationManager.cancel(tag.hashCode());
                }
                throw new IllegalArgumentException("Remind later timestamp or duration is less than or equal to current timestamp, cannot schedule notification for later.");
            }
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Remind later pressed, will reschedule the notification to be displayed " + secondsUntilFireDate + " seconds from now"), (Object[])new Object[0]);
            long l = triggerTimeInSeconds = remindLaterDuration > 0L ? remindLaterDuration + TimeUtils.getUnixTimeInSeconds() : remindLaterTimestamp;
            if (broadcastReceiverClass == null) {
                Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"Broadcast receiver class is null, cannot schedule notification for later.", (Object[])new Object[0]);
                String string = tag;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    notificationManager.cancel(tag.hashCode());
                }
                return;
            }
            Intent scheduledIntent = new Intent("scheduled_notification_broadcast");
            scheduledIntent.setFlags(0x20000000);
            scheduledIntent.putExtras(intentExtras);
            PendingIntentUtils.INSTANCE.scheduleNotification$notificationbuilder_phoneRelease(context2, scheduledIntent, broadcastReceiverClass, triggerTimeInSeconds);
            String string = tag;
            if (string == null) break block6;
            String it = string;
            boolean bl = false;
            notificationManager.cancel(tag.hashCode());
        }
    }
}

