/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationCompatBuilderExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.RemoteViewsExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AEPPushTemplate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/AEPPushNotificationBuilder;", "", "()V", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/AEPPushTemplate;", "channelIdToUse", "", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "smallLayout", "Landroid/widget/RemoteViews;", "expandedLayout", "containerLayoutViewId", "", "createIntent", "Landroid/content/Intent;", "action", "template", "createIntent$notificationbuilder_phoneRelease", "notificationbuilder_phoneRelease"})
public final class AEPPushNotificationBuilder {
    @NotNull
    public static final AEPPushNotificationBuilder INSTANCE = new AEPPushNotificationBuilder();

    private AEPPushNotificationBuilder() {
    }

    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull AEPPushTemplate pushTemplate, @NotNull String channelIdToUse, @Nullable Class<? extends Activity> trackerActivityClass, @NotNull RemoteViews smallLayout, @NotNull RemoteViews expandedLayout, int containerLayoutViewId) throws NotificationConstructionFailedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Intrinsics.checkNotNullParameter((Object)channelIdToUse, (String)"channelIdToUse");
        Intrinsics.checkNotNullParameter((Object)smallLayout, (String)"smallLayout");
        Intrinsics.checkNotNullParameter((Object)expandedLayout, (String)"expandedLayout");
        String titleText = pushTemplate.getTitle$notificationbuilder_phoneRelease();
        String smallBodyText = pushTemplate.getBody$notificationbuilder_phoneRelease();
        String expandedBodyText = pushTemplate.getExpandedBodyText$notificationbuilder_phoneRelease();
        smallLayout.setTextViewText(R.id.notification_title, (CharSequence)titleText);
        smallLayout.setTextViewText(R.id.notification_body, (CharSequence)smallBodyText);
        expandedLayout.setTextViewText(R.id.notification_title, (CharSequence)titleText);
        expandedLayout.setTextViewText(R.id.notification_body_expanded, (CharSequence)expandedBodyText);
        RemoteViewsExtensionsKt.setNotificationBackgroundColor(smallLayout, pushTemplate.getBackgroundColor$notificationbuilder_phoneRelease(), R.id.basic_small_layout);
        RemoteViewsExtensionsKt.setNotificationBackgroundColor(expandedLayout, pushTemplate.getBackgroundColor$notificationbuilder_phoneRelease(), containerLayoutViewId);
        RemoteViewsExtensionsKt.setNotificationTitleTextColor(smallLayout, pushTemplate.getTitleTextColor$notificationbuilder_phoneRelease(), R.id.notification_title);
        RemoteViewsExtensionsKt.setNotificationTitleTextColor(expandedLayout, pushTemplate.getTitleTextColor$notificationbuilder_phoneRelease(), R.id.notification_title);
        RemoteViewsExtensionsKt.setNotificationBodyTextColor(smallLayout, pushTemplate.getBodyTextColor$notificationbuilder_phoneRelease(), R.id.notification_body);
        RemoteViewsExtensionsKt.setNotificationBodyTextColor(expandedLayout, pushTemplate.getBodyTextColor$notificationbuilder_phoneRelease(), R.id.notification_body_expanded);
        RemoteViewsExtensionsKt.setRemoteViewImage(smallLayout, pushTemplate.getLargeIcon$notificationbuilder_phoneRelease(), R.id.large_icon);
        RemoteViewsExtensionsKt.setRemoteViewImage(expandedLayout, pushTemplate.getLargeIcon$notificationbuilder_phoneRelease(), R.id.large_icon);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelIdToUse).setTicker((CharSequence)pushTemplate.getTicker$notificationbuilder_phoneRelease()).setNumber(pushTemplate.getBadgeCount$notificationbuilder_phoneRelease()).setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setCustomContentView(smallLayout).setCustomBigContentView(expandedLayout);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, channel\u2026ntentView(expandedLayout)");
        NotificationCompat.Builder builder2 = NotificationCompatBuilderExtensionsKt.setSmallIcon(builder, context, pushTemplate.getSmallIcon$notificationbuilder_phoneRelease(), pushTemplate.getSmallIconColor$notificationbuilder_phoneRelease()).setVisibility(pushTemplate.getVisibility$notificationbuilder_phoneRelease().getValue());
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"Builder(context, channel\u2026emplate.visibility.value)");
        NotificationCompat.Builder builder3 = NotificationCompatBuilderExtensionsKt.setNotificationDeleteAction(NotificationCompatBuilderExtensionsKt.setNotificationClickAction(builder2, context, trackerActivityClass, pushTemplate.getActionUri$notificationbuilder_phoneRelease(), pushTemplate.getData().getBundle()), context, trackerActivityClass);
        if (Build.VERSION.SDK_INT <= 21) {
            builder3.setOnlyAlertOnce(true);
            builder3.setCustomHeadsUpContentView(expandedLayout);
        }
        if (Build.VERSION.SDK_INT == 23 || Build.VERSION.SDK_INT == 22) {
            builder3.setCustomHeadsUpContentView(smallLayout);
        }
        if (!pushTemplate.isFromIntent$notificationbuilder_phoneRelease()) {
            NotificationCompatBuilderExtensionsKt.setSound(builder3, context, pushTemplate.getSound$notificationbuilder_phoneRelease());
        }
        if (Build.VERSION.SDK_INT < 26) {
            builder3.setPriority(1).setVibrate(new long[0]);
        }
        return builder3;
    }

    @NotNull
    public final Intent createIntent$notificationbuilder_phoneRelease(@NotNull String action, @NotNull AEPPushTemplate template) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intent intent = new Intent(action);
        intent.setFlags(0x20000000);
        intent.putExtras(template.getData().getBundle());
        return intent;
    }
}

