/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AEPPushNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.RemoteViewsExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.MultiIconPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\fJJ\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/MultiIconNotificationBuilder;", "", "()V", "SELF_TAG", "", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/MultiIconPushTemplate;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "populateIconsForMultiIconTemplate", "", "notificationLayout", "Landroid/widget/RemoteViews;", "items", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/MultiIconPushTemplate$MultiIconTemplateItem;", "packageName", "setCancelIcon", "notificationbuilder_phoneRelease"})
public final class MultiIconNotificationBuilder {
    @NotNull
    public static final MultiIconNotificationBuilder INSTANCE = new MultiIconNotificationBuilder();
    @NotNull
    public static final String SELF_TAG = "MultiIconNotificationBuilder";

    private MultiIconNotificationBuilder() {
    }

    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull MultiIconPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Building an icon template push notification.", (Object[])new Object[0]);
        String packageName = context.getPackageName();
        RemoteViews notificationLayout = new RemoteViews(packageName, R.layout.push_template_multi_icon);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        String channelIdToUse = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, pushTemplate);
        this.populateIconsForMultiIconTemplate(context, trackerActivityClass, notificationLayout, pushTemplate, pushTemplate.getTemplateItemList$notificationbuilder_phoneRelease(), packageName);
        this.setCancelIcon(notificationLayout, pushTemplate);
        Bundle closeButtonIntentExtra = new Bundle(pushTemplate.getData().getBundle());
        closeButtonIntentExtra.putString("adb_sticky", "false");
        Intent dismissIntent = new Intent("Notification Dismissed");
        Class<? extends Activity> clazz = trackerActivityClass;
        if (clazz != null) {
            Class<? extends Activity> it = clazz;
            boolean bl = false;
            dismissIntent.setClass(context.getApplicationContext(), trackerActivityClass);
        }
        dismissIntent.setFlags(0x20000000);
        dismissIntent.putExtras(closeButtonIntentExtra);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)dismissIntent, (int)0xC000000);
        notificationLayout.setOnClickPendingIntent(R.id.five_icon_close_button, pendingIntent);
        return AEPPushNotificationBuilder.INSTANCE.construct(context, pushTemplate, channelIdToUse, trackerActivityClass, notificationLayout, notificationLayout, R.id.carousel_container_layout);
    }

    private final void setCancelIcon(RemoteViews notificationLayout, MultiIconPushTemplate pushTemplate) {
        String iconString = pushTemplate.getCancelIcon$notificationbuilder_phoneRelease();
        RemoteViewsExtensionsKt.setRemoteViewImage(notificationLayout, iconString, R.id.five_icon_close_button);
    }

    private final void populateIconsForMultiIconTemplate(Context context, Class<? extends Activity> trackerActivityClass, RemoteViews notificationLayout, MultiIconPushTemplate pushTemplate, List<MultiIconPushTemplate.MultiIconTemplateItem> items, String packageName) {
        int validImagesAddedCount = 0;
        Iterator<MultiIconPushTemplate.MultiIconTemplateItem> iterator = items.iterator();
        while (iterator.hasNext()) {
            RemoteViews iconItem = new RemoteViews(packageName, R.layout.multi_icon_template_item);
            MultiIconPushTemplate.MultiIconTemplateItem item = iterator.next();
            if (RemoteViewsExtensionsKt.setRemoteViewImage(iconItem, item.getIconUrl(), R.id.icon_item_image_view)) {
                ++validImagesAddedCount;
            }
            if (trackerActivityClass != null) {
                boolean bl = false;
                String string = item.getActionUri();
                if (string == null) {
                    string = pushTemplate.getActionUri$notificationbuilder_phoneRelease();
                }
                String interactionUri = string;
                RemoteViewsExtensionsKt.setRemoteViewClickAction(iconItem, context, trackerActivityClass, R.id.icon_item_image_view, interactionUri, null, pushTemplate.getData().getBundle());
            }
            notificationLayout.addView(R.id.icons_layout_linear, iconItem);
        }
        if (validImagesAddedCount < 3) {
            throw new NotificationConstructionFailedException("Valid icons are less then 3, cannot build a notification.");
        }
    }
}

