/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.extensions;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.adobe.marketing.mobile.services.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u0003*\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0016\u0010\u0007\u001a\u00020\b*\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"SELF_TAG", "", "getDefaultAppIcon", "", "Landroid/content/Context;", "getIconWithResourceName", "iconName", "getSoundUriForResourceName", "Landroid/net/Uri;", "soundName", "notificationbuilder_phoneRelease"})
public final class AppResourceExtensionsKt {
    @NotNull
    private static final String SELF_TAG = "AppResourceExtensions";

    public static final int getIconWithResourceName(@NotNull Context $this$getIconWithResourceName, @Nullable String iconName) {
        Intrinsics.checkNotNullParameter((Object)$this$getIconWithResourceName, (String)"<this>");
        CharSequence charSequence = iconName;
        return charSequence == null || charSequence.length() == 0 ? 0 : $this$getIconWithResourceName.getResources().getIdentifier(iconName, "drawable", $this$getIconWithResourceName.getPackageName());
    }

    public static final int getDefaultAppIcon(@NotNull Context $this$getDefaultAppIcon) {
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultAppIcon, (String)"<this>");
        String packageName = $this$getDefaultAppIcon.getPackageName();
        try {
            return $this$getDefaultAppIcon.getPackageManager().getApplicationInfo((String)packageName, (int)0).icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Package manager NameNotFoundException while reading default application icon: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            return -1;
        }
    }

    @NotNull
    public static final Uri getSoundUriForResourceName(@NotNull Context $this$getSoundUriForResourceName, @Nullable String soundName) {
        Intrinsics.checkNotNullParameter((Object)$this$getSoundUriForResourceName, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder().append("android.resource://").append($this$getSoundUriForResourceName.getPackageName()).append("/raw/");
        String string = soundName;
        if (string == null) {
            string = "";
        }
        Uri uri = Uri.parse((String)stringBuilder.append(string).toString());
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(\n        ContentRe\u2026  (soundName ?: \"\")\n    )");
        return uri;
    }
}

