/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ui.InAppMessage;
import com.adobe.marketing.mobile.services.ui.Presentable;
import com.adobe.marketing.mobile.services.ui.PresentationError;
import com.adobe.marketing.mobile.services.ui.message.InAppMessageEventListener;
import com.adobe.marketing.mobile.target.TargetPreviewManager;

class TargetPreviewFullscreenEventListener
implements InAppMessageEventListener {
    private static final String CLASS_NAME = "TargetPreviewFullscreenDelegate";
    private final TargetPreviewManager targetPreviewManager;

    TargetPreviewFullscreenEventListener(TargetPreviewManager previewManager) {
        this.targetPreviewManager = previewManager;
    }

    public void onDismiss(@NonNull Presentable<InAppMessage> presentable) {
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"Target preview selection screen was dismissed", (Object[])new Object[0]);
    }

    public void onError(@NonNull Presentable<InAppMessage> presentable, @NonNull PresentationError presentationError) {
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"onError - Failed to display Target preview selection screen.", (Object[])new Object[0]);
    }

    public void onHide(@NonNull Presentable<InAppMessage> presentable) {
    }

    public void onShow(@NonNull Presentable<InAppMessage> presentable) {
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"Target preview selection screen was displayed", (Object[])new Object[0]);
    }

    public void onBackPressed(@NonNull Presentable<InAppMessage> presentable) {
    }

    public boolean onUrlLoading(@NonNull Presentable<InAppMessage> presentable, @NonNull String url) {
        Log.debug((String)"Target", (String)CLASS_NAME, (String)String.format("Target preview override url received: %s", url), (Object[])new Object[0]);
        this.targetPreviewManager.previewConfirmedWithUrl(presentable, url);
        return true;
    }
}

