/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.ui.FloatingButton;
import com.adobe.marketing.mobile.services.ui.InAppMessage;
import com.adobe.marketing.mobile.services.ui.Presentable;
import com.adobe.marketing.mobile.services.ui.Presentation;
import com.adobe.marketing.mobile.services.ui.PresentationUtilityProvider;
import com.adobe.marketing.mobile.services.ui.UIService;
import com.adobe.marketing.mobile.services.ui.floatingbutton.FloatingButtonEventListener;
import com.adobe.marketing.mobile.services.ui.floatingbutton.FloatingButtonSettings;
import com.adobe.marketing.mobile.services.ui.message.InAppMessageEventListener;
import com.adobe.marketing.mobile.services.ui.message.InAppMessageSettings;
import com.adobe.marketing.mobile.services.uri.UriOpening;
import com.adobe.marketing.mobile.target.TargetPreviewButtonEventListener;
import com.adobe.marketing.mobile.target.TargetPreviewFullscreenEventListener;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.DefaultPresentationUtilityProvider;
import com.adobe.marketing.mobile.util.StreamUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.URLBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

class TargetPreviewManager {
    private static final String CLASS_NAME = "TargetPreviewManager";
    static final String CHARSET_UTF_8 = "UTF-8";
    private final Networking networkService;
    private final UIService uiService;
    private final UriOpening uriService;
    private final Context context;
    protected String previewParams;
    protected String token;
    protected String endPoint;
    protected String webViewHtml;
    protected String restartUrl;
    private Boolean fetchingWebView;
    private String clientCode;
    protected Presentable<FloatingButton> floatingButtonPresentable;

    TargetPreviewManager(Networking networkService, UIService uiService, UriOpening uriService, Context context) {
        this.networkService = networkService;
        this.uiService = uiService;
        this.uriService = uriService;
        this.context = context;
        this.fetchingWebView = false;
    }

    protected String getPreviewParameters() {
        return this.previewParams;
    }

    protected String getPreviewToken() {
        return this.token;
    }

    protected void setRestartDeepLink(String restartDeepLink) {
        this.restartUrl = restartDeepLink;
    }

    protected void enterPreviewModeWithDeepLinkParams(String clientCode, String deepLink) {
        URI url;
        if (this.networkService == null) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"enterPreviewModeWithDeepLinkParams - Unable to enter preview mode, NetworkServices is not available.", (Object[])new Object[0]);
            return;
        }
        if (this.uiService == null) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"enterPreviewModeWithDeepLinkParams - Unable to enter preview mode, UIService is not available.", (Object[])new Object[0]);
            return;
        }
        if (this.uriService == null) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"enterPreviewModeWithDeepLinkParams - Unable to enter preview mode, UriOpening is not available.", (Object[])new Object[0]);
            return;
        }
        this.clientCode = clientCode;
        if (StringUtils.isNullOrEmpty((String)deepLink)) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"enterPreviewModeWithDeepLinkParams - Unable to enter preview mode with empty/invalid url", (Object[])new Object[0]);
            return;
        }
        try {
            url = URI.create(deepLink);
        }
        catch (IllegalArgumentException e) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)String.format("enterPreviewModeWithDeepLinkParams - Unable to enter preview mode, Invalid deep link provided, %s. Error (%s)", deepLink, e.getMessage()), (Object[])new Object[0]);
            return;
        }
        String query = url.getRawQuery();
        Map<String, String> queryParams = TargetUtils.extractQueryParameters(query);
        if (TargetUtils.isNullOrEmpty(queryParams)) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)String.format("enterPreviewModeWithDeepLinkParams - Unable to enter preview mode. Cannot retrieve preview token from provided deeplink : %s", deepLink), (Object[])new Object[0]);
            return;
        }
        if (this.setupTargetPreviewParameters(queryParams)) {
            this.createAndShowFloatingButton();
            this.fetchWebView();
        }
    }

    protected void previewConfirmedWithUrl(Presentable<InAppMessage> message, String stringUrl) {
        URI url;
        message.dismiss();
        try {
            url = URI.create(stringUrl);
        }
        catch (Exception e) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"previewConfirmedWithUrl - Invalid URL obtained from Target Preview Message %s", (Object[])new Object[]{stringUrl});
            return;
        }
        String scheme = url.getScheme();
        if (!"adbinapp".equals(scheme)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"previewConfirmedWithUrl - Provided deeplink scheme is not equal to the target scheme", (Object[])new Object[0]);
            return;
        }
        String host = url.getHost();
        if ("cancel".equals(host)) {
            this.resetTargetPreviewProperties();
        } else if ("confirm".equals(host)) {
            String query = url.getRawQuery();
            Map<String, String> queryParams = TargetUtils.extractQueryParameters(query);
            if (TargetUtils.isNullOrEmpty(queryParams)) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)String.format("previewConfirmedWithUrl - Target Preview URL does not have preview query parameter : URL : %s", query), (Object[])new Object[0]);
                return;
            }
            String previewParameters = queryParams.get("at_preview_params");
            try {
                if (!StringUtils.isNullOrEmpty((String)previewParameters)) {
                    this.previewParams = URLDecoder.decode(previewParameters, CHARSET_UTF_8);
                }
            }
            catch (UnsupportedEncodingException e) {
                Log.error((String)"Target", (String)CLASS_NAME, (String)"Unable to URL decode the preview parameters, Error %s", (Object[])new Object[]{e});
            }
            if (StringUtils.isNullOrEmpty((String)this.restartUrl)) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"previewConfirmedWithUrl - Empty Preview restart url", (Object[])new Object[0]);
            } else if (!this.uriService.openUri(this.restartUrl)) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"previewConfirmedWithUrl - Failed to load given preview restart url %s", (Object[])new Object[]{this.restartUrl});
            }
        }
    }

    protected void fetchWebView() {
        if (this.fetchingWebView.booleanValue()) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"fetchWebView - TargetPreview was already initialized. Fetching webView in progress.", (Object[])new Object[0]);
            return;
        }
        this.fetchingWebView = true;
        String targetUrl = this.getUrlForTargetPreviewRequest();
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"fetchWebView - Sending preview request to url %s", (Object[])new Object[]{targetUrl});
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Accept", "text/html");
        requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        NetworkRequest request = new NetworkRequest(targetUrl, HttpMethod.GET, null, requestHeaders, 2, 2);
        this.networkService.connectAsync(request, connection -> {
            if (connection == null) {
                Log.error((String)"Target", (String)CLASS_NAME, (String)"Target Preview unable to open connect to fetch webview", (Object[])new Object[0]);
                this.fetchingWebView = false;
                return;
            }
            if (connection.getResponseCode() == 200) {
                String serverResponse = StreamUtils.readAsString((InputStream)connection.getInputStream());
                if (!StringUtils.isNullOrEmpty((String)serverResponse)) {
                    this.webViewHtml = serverResponse;
                    Log.debug((String)"Target", (String)CLASS_NAME, (String)"Successfully fetched webview for preview mode, response body %s", (Object[])new Object[]{this.webViewHtml});
                    this.createAndShowMessage();
                }
            } else {
                Log.error((String)"Target", (String)CLASS_NAME, (String)String.format("Failed to fetch preview webview with connection status %s, response body %s", connection.getResponseCode(), connection.getResponseMessage()), (Object[])new Object[0]);
            }
            connection.close();
            this.fetchingWebView = false;
        });
    }

    protected void resetTargetPreviewProperties() {
        this.token = null;
        this.webViewHtml = null;
        this.endPoint = null;
        this.restartUrl = null;
        this.previewParams = null;
        if (this.floatingButtonPresentable != null) {
            this.floatingButtonPresentable.dismiss();
            this.floatingButtonPresentable = null;
        }
    }

    private boolean setupTargetPreviewParameters(Map<String, String> previewParameters) {
        try {
            String previewEndPoint = previewParameters.get("at_preview_endpoint");
            if (!StringUtils.isNullOrEmpty((String)previewEndPoint)) {
                this.endPoint = URLDecoder.decode(previewEndPoint, CHARSET_UTF_8);
            } else {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"setupTargetPreviewParameters - Using the Default endpoint", (Object[])new Object[0]);
                this.endPoint = "hal.testandtarget.omniture.com";
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"Decode error while extracting preview endpoint, Error %s", (Object[])new Object[]{e});
        }
        try {
            String encodedToken = previewParameters.get("at_preview_token");
            if (!StringUtils.isNullOrEmpty((String)encodedToken)) {
                this.token = URLDecoder.decode(encodedToken, CHARSET_UTF_8);
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"Decode error while extracting preview token, Error %s", (Object[])new Object[]{e});
        }
        return false;
    }

    private void createAndShowFloatingButton() {
        if (this.floatingButtonPresentable != null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"createAndShowFloatingButton - Floating button already exists", (Object[])new Object[0]);
            return;
        }
        AssetManager assetManager = this.context.getAssets();
        if (assetManager == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"createAndShowFloatingButton - Unable to instantiate the floating button for target preview, cannot find button image", (Object[])new Object[0]);
            return;
        }
        try {
            String backgroundImageString = StreamUtils.readAsString((InputStream)assetManager.open("encoded_button_image.txt"));
            byte[] backgroundImage = Base64.decode((String)backgroundImageString, (int)0);
            Bitmap floatingButtonImage = BitmapFactory.decodeStream((InputStream)new ByteArrayInputStream(backgroundImage));
            this.floatingButtonPresentable = this.uiService.create((Presentation)new FloatingButton(new FloatingButtonSettings.Builder().initialGraphic(floatingButtonImage).build(), (FloatingButtonEventListener)new TargetPreviewButtonEventListener(this)), (PresentationUtilityProvider)new DefaultPresentationUtilityProvider());
            this.floatingButtonPresentable.show();
        }
        catch (Exception e) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"createAndShowFloatingButton - Unable to instantiate the floating button for target preview %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    private void createAndShowMessage() {
        InAppMessageSettings inAppMessageSettings = new InAppMessageSettings.Builder().content(this.webViewHtml).backgroundColor("#FFFFFFF").backdropOpacity(1.0f).build();
        try {
            Presentable inAppMessagePresentable = this.uiService.create((Presentation)new InAppMessage(inAppMessageSettings, (InAppMessageEventListener)new TargetPreviewFullscreenEventListener(this)), (PresentationUtilityProvider)new DefaultPresentationUtilityProvider());
            inAppMessagePresentable.show();
        }
        catch (Exception e) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"createAndShowMessage - Unable to instantiate the full screen message for target preview %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    private String getUrlForTargetPreviewRequest() {
        return new URLBuilder().enableSSL(true).setServer(this.endPoint).addPath("ui").addPath("admin").addPath(this.clientCode).addPath("preview").addQueryParameter("token", this.token).build();
    }
}

