/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import com.adobe.marketing.mobile.VisitorID;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.target.TargetOrder;
import com.adobe.marketing.mobile.target.TargetParameters;
import com.adobe.marketing.mobile.target.TargetPrefetch;
import com.adobe.marketing.mobile.target.TargetPreviewManager;
import com.adobe.marketing.mobile.target.TargetProduct;
import com.adobe.marketing.mobile.target.TargetRequest;
import com.adobe.marketing.mobile.target.TargetState;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TargetRequestBuilder {
    private static final String CLASS_NAME = "TargetRequestBuilder";
    private final DeviceInforming deviceInfoService;
    private final TargetPreviewManager targetPreviewManager;
    private final TargetState targetState;

    TargetRequestBuilder(DeviceInforming deviceInfoService, TargetPreviewManager targetPreviewManager, TargetState targetState) {
        this.deviceInfoService = deviceInfoService;
        this.targetPreviewManager = targetPreviewManager;
        this.targetState = targetState;
    }

    JSONObject getRequestPayload(List<TargetPrefetch> prefetchArray, List<TargetRequest> executeArray, TargetParameters parameters, List<JSONObject> notifications, String propertyToken, Map<String, Object> identitySharedState, Map<String, String> lifecycleData) {
        try {
            JSONObject previewParameters;
            JSONArray executeMboxesNode;
            JSONObject defaultParamJson = this.getDefaultJsonObject(null, null, null, this.targetState.getEnvironmentId(), identitySharedState);
            JSONArray prefetchMboxesNode = this.getPrefetchMboxes(prefetchArray, parameters, lifecycleData);
            if (prefetchMboxesNode != null && prefetchMboxesNode.length() > 0) {
                JSONObject prefetchJson = new JSONObject();
                prefetchJson.put("mboxes", (Object)prefetchMboxesNode);
                defaultParamJson.put("prefetch", (Object)prefetchJson);
            }
            if (notifications != null && !notifications.isEmpty()) {
                defaultParamJson.put("notifications", (Object)new JSONArray(notifications));
            }
            if ((executeMboxesNode = this.getExecuteMboxes(executeArray, parameters, lifecycleData)) != null && executeMboxesNode.length() > 0) {
                JSONObject executeJson = new JSONObject();
                executeJson.put("mboxes", (Object)executeMboxesNode);
                defaultParamJson.put("execute", (Object)executeJson);
            }
            if (!StringUtils.isNullOrEmpty((String)propertyToken)) {
                JSONObject tokenJson = new JSONObject();
                tokenJson.put("token", (Object)propertyToken);
                defaultParamJson.put("property", (Object)tokenJson);
            }
            if ((previewParameters = this.getPreviewParameters()) != null) {
                Iterator keys = previewParameters.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    defaultParamJson.put(key, previewParameters.get(key));
                }
            }
            return defaultParamJson;
        }
        catch (JSONException e) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Failed to generate the Target request payload", (Object[])new Object[]{e});
            return null;
        }
    }

    JSONObject getRequestPayload(JSONObject defaultJsonObject, Map<String, Object> prefetch, Map<String, Object> execute, List<Map<String, Object>> notifications, String propertyToken) {
        try {
            JSONObject previewParameters;
            JSONObject defaultParamJson;
            JSONObject jSONObject = defaultParamJson = defaultJsonObject == null ? new JSONObject() : defaultJsonObject;
            if (prefetch != null && !prefetch.isEmpty()) {
                JSONObject prefetchNode = new JSONObject(prefetch);
                defaultParamJson.put("prefetch", (Object)prefetchNode);
            }
            if (execute != null && !execute.isEmpty()) {
                JSONObject executeNode = new JSONObject(execute);
                defaultParamJson.put("execute", (Object)executeNode);
            }
            if (notifications != null && !notifications.isEmpty()) {
                JSONArray notificationArrayNode = new JSONArray();
                for (Map<String, Object> notification : notifications) {
                    JSONObject notificationNode = new JSONObject(notification);
                    notificationArrayNode.put((Object)notificationNode);
                }
                defaultParamJson.put("notifications", (Object)notificationArrayNode);
            }
            if (!StringUtils.isNullOrEmpty((String)propertyToken)) {
                JSONObject tokenJson = new JSONObject();
                tokenJson.put("token", (Object)propertyToken);
                defaultParamJson.put("property", (Object)tokenJson);
            }
            if ((previewParameters = this.getPreviewParameters()) != null) {
                Iterator keys = previewParameters.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    defaultParamJson.put(key, previewParameters.get(key));
                }
            }
            return defaultParamJson;
        }
        catch (JSONException e) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"getRequestPayload - (%s) (%s)", (Object[])new Object[]{"Failed to generate the Target request payload", e});
            return null;
        }
    }

    JSONObject getDisplayNotificationJsonObject(String mboxName, JSONObject cachedMboxJson, TargetParameters parameters, long timestamp, Map<String, String> lifecycleData) {
        try {
            JSONObject notificationNode = new JSONObject();
            notificationNode.put("id", (Object)UUID.randomUUID().toString());
            notificationNode.put("timestamp", timestamp);
            notificationNode.put("type", (Object)"display");
            this.setTargetParametersJson(notificationNode, parameters, lifecycleData);
            JSONObject mboxNode = new JSONObject();
            mboxNode.put("name", (Object)mboxName);
            if (cachedMboxJson == null) {
                return null;
            }
            String mboxState = cachedMboxJson.optString("state", "");
            if (!mboxState.isEmpty()) {
                mboxNode.put("state", (Object)mboxState);
            }
            notificationNode.put("mbox", (Object)mboxNode);
            JSONArray optionsArray = cachedMboxJson.optJSONArray("options");
            if (optionsArray != null) {
                JSONArray tokens = new JSONArray();
                for (int i = 0; i < optionsArray.length(); ++i) {
                    JSONObject option = optionsArray.optJSONObject(i);
                    if (option == null || StringUtils.isNullOrEmpty((String)option.optString("eventToken", ""))) continue;
                    String optionEventToken = option.optString("eventToken", "");
                    tokens.put((Object)optionEventToken);
                }
                if (tokens.length() == 0) {
                    Log.debug((String)"Target", (String)CLASS_NAME, (String)"Unable to create display notification as token is null or empty", (Object[])new Object[0]);
                    return null;
                }
                notificationNode.put("tokens", (Object)tokens);
            }
            return notificationNode;
        }
        catch (JSONException exception) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Failed to create display notification Json(%s)", (Object[])new Object[]{exception});
            return null;
        }
    }

    JSONObject getClickNotificationJsonObject(JSONObject cachedMboxJson, TargetParameters parameters, long timestamp, Map<String, String> lifecycleData) {
        try {
            JSONObject notificationNode = new JSONObject();
            notificationNode.put("id", (Object)UUID.randomUUID().toString());
            notificationNode.put("timestamp", timestamp);
            notificationNode.put("type", (Object)"click");
            this.setTargetParametersJson(notificationNode, parameters, lifecycleData);
            if (cachedMboxJson == null) {
                return notificationNode;
            }
            String mboxName = cachedMboxJson.getString("name");
            JSONObject mboxNode = new JSONObject();
            mboxNode.put("name", (Object)mboxName);
            notificationNode.put("mbox", (Object)mboxNode);
            JSONArray metrics = cachedMboxJson.getJSONArray("metrics");
            JSONArray tokens = new JSONArray();
            for (int i = 0; i < metrics.length(); ++i) {
                JSONObject metric = metrics.optJSONObject(i);
                if (metric == null || !"click".equals(metric.optString("type", "")) || metric.optString("eventToken", "").isEmpty()) continue;
                String metricToken = metric.optString("eventToken", "");
                tokens.put((Object)metricToken);
            }
            if (tokens.length() == 0) {
                throw new JSONException("Tokens list is null or empty in the view notification object");
            }
            notificationNode.put("tokens", (Object)tokens);
            return notificationNode;
        }
        catch (JSONException exception) {
            Log.warning((String)"Target", (String)"Failed to create click notification Json(%s)", (String)cachedMboxJson.toString(), (Object[])new Object[0]);
            return null;
        }
    }

    JSONObject getDefaultJsonObject(Map<String, Object> id, Map<String, Object> context, Map<String, Object> experienceCloud, long environmentId, Map<String, Object> identityData) {
        try {
            JSONObject experienceCloudNode;
            JSONObject idNode;
            JSONObject defaultParamJson = new JSONObject();
            if (id != null && !id.isEmpty()) {
                idNode = new JSONObject(id);
            } else {
                List visitorCustomerIds;
                String visitorMarketingCloudId;
                idNode = new JSONObject();
                if (!StringUtils.isNullOrEmpty((String)this.targetState.getTntId())) {
                    idNode.put("tntId", (Object)this.targetState.getTntId());
                }
                if (!StringUtils.isNullOrEmpty((String)this.targetState.getThirdPartyId())) {
                    idNode.put("thirdPartyId", (Object)this.targetState.getThirdPartyId());
                }
                if (!StringUtils.isNullOrEmpty((String)(visitorMarketingCloudId = DataReader.optString(identityData, (String)"mid", (String)"")))) {
                    idNode.put("marketingCloudVisitorId", (Object)visitorMarketingCloudId);
                }
                if ((visitorCustomerIds = DataReader.optTypedListOfMap(Object.class, identityData, (String)"visitoridslist", null)) != null && !visitorCustomerIds.isEmpty()) {
                    idNode.put("customerIds", (Object)this.getCustomerIDs(visitorCustomerIds));
                }
            }
            if (idNode.length() > 0) {
                defaultParamJson.put("id", (Object)idNode);
            }
            JSONObject contextNode = context != null && !context.isEmpty() ? new JSONObject(context) : this.getContextObject();
            defaultParamJson.put("context", (Object)contextNode);
            if (experienceCloud != null && !experienceCloud.isEmpty()) {
                experienceCloudNode = new JSONObject(experienceCloud);
            } else {
                String visitorBlob = DataReader.optString(identityData, (String)"blob", (String)"");
                String visitorLocationHint = DataReader.optString(identityData, (String)"locationhint", (String)"");
                experienceCloudNode = this.getExperienceCloudObject(visitorBlob, visitorLocationHint);
            }
            defaultParamJson.put("experienceCloud", (Object)experienceCloudNode);
            if (environmentId != 0L) {
                defaultParamJson.put("environmentId", environmentId);
            }
            return defaultParamJson;
        }
        catch (JSONException e) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Failed to create base JSON object for Target request (%s)", (Object[])new Object[]{e});
            return null;
        }
    }

    private JSONArray getExecuteMboxes(List<TargetRequest> targetRequestList, TargetParameters globalParameters, Map<String, String> lifecycleData) {
        if (targetRequestList == null) {
            return null;
        }
        JSONArray mBoxArrayNode = new JSONArray();
        int index = 0;
        for (TargetRequest currentMbox : targetRequestList) {
            try {
                mBoxArrayNode.put((Object)this.createMboxJsonObject(currentMbox.getMboxName(), currentMbox.getTargetParameters(), index, globalParameters, lifecycleData));
                ++index;
            }
            catch (JSONException exception) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"getExecuteMboxes -Failed to create Json Node for mbox %s (%s)", (Object[])new Object[]{currentMbox.getMboxName(), exception});
            }
        }
        return mBoxArrayNode;
    }

    private JSONObject getContextObject() throws JSONException {
        JSONObject contextJson = new JSONObject();
        contextJson.put("channel", (Object)"mobile");
        contextJson.put("mobilePlatform", (Object)this.getPlatformContextObject());
        contextJson.put("application", (Object)this.getAppContextObject());
        contextJson.put("screen", (Object)this.getScreenContextObject());
        String userAgent = this.deviceInfoService.getDefaultUserAgent();
        if (!StringUtils.isNullOrEmpty((String)userAgent)) {
            contextJson.put("userAgent", (Object)userAgent);
        }
        contextJson.put("timeOffsetInMinutes", TargetUtils.getUTCTimeOffsetMinutes());
        return contextJson;
    }

    private JSONObject getScreenContextObject() throws JSONException {
        JSONObject screenJson = new JSONObject();
        DeviceInforming.DisplayInformation displayInformation = this.deviceInfoService.getDisplayInformation();
        if (displayInformation != null) {
            screenJson.put("width", displayInformation.getWidthPixels());
            screenJson.put("height", displayInformation.getHeightPixels());
        }
        screenJson.put("colorDepth", 32);
        int orientation = this.deviceInfoService.getCurrentOrientation();
        if (orientation != 0) {
            screenJson.put("orientation", (Object)(orientation == 1 ? "portrait" : "landscape"));
        }
        return screenJson;
    }

    private JSONObject getAppContextObject() throws JSONException {
        String appVersion;
        String appName;
        JSONObject appJson = new JSONObject();
        String appId = this.deviceInfoService.getApplicationPackageName();
        if (appId != null) {
            appJson.put("id", (Object)appId);
        }
        if ((appName = this.deviceInfoService.getApplicationName()) != null) {
            appJson.put("name", (Object)appName);
        }
        if ((appVersion = this.deviceInfoService.getApplicationVersion()) != null) {
            appJson.put("version", (Object)appVersion);
        }
        return appJson;
    }

    private JSONObject getPlatformContextObject() throws JSONException {
        DeviceInforming.DeviceType deviceType;
        JSONObject platformJson = new JSONObject();
        platformJson.put("platformType", (Object)this.deviceInfoService.getCanonicalPlatformName());
        String deviceManufacturer = this.deviceInfoService.getDeviceManufacturer();
        String deviceName = this.deviceInfoService.getDeviceName();
        if (deviceName != null) {
            platformJson.put("deviceName", (Object)((deviceManufacturer != null ? deviceManufacturer + " " : "") + deviceName));
        }
        if ((deviceType = this.deviceInfoService.getDeviceType()) != null && deviceType != DeviceInforming.DeviceType.UNKNOWN) {
            platformJson.put("deviceType", (Object)deviceType.name().toLowerCase());
        }
        return platformJson;
    }

    private JSONObject getExperienceCloudObject(String visitorBlob, String visitorLocationHint) throws JSONException {
        JSONObject analyticsJson = new JSONObject();
        analyticsJson.put("logging", (Object)"client_side");
        JSONObject experienceCloudJson = new JSONObject();
        experienceCloudJson.put("analytics", (Object)analyticsJson);
        JSONObject audienceManagerJson = new JSONObject();
        if (!StringUtils.isNullOrEmpty((String)visitorBlob)) {
            audienceManagerJson.put("blob", (Object)visitorBlob);
        }
        if (!StringUtils.isNullOrEmpty((String)visitorLocationHint)) {
            audienceManagerJson.put("locationHint", (Object)visitorLocationHint);
        }
        if (audienceManagerJson.length() > 0) {
            experienceCloudJson.put("audienceManager", (Object)audienceManagerJson);
        }
        return experienceCloudJson;
    }

    private JSONArray getCustomerIDs(List<Map<String, Object>> customerIDs) {
        JSONArray customerIDsArrayNode = new JSONArray();
        try {
            for (Map<String, Object> visitorID : customerIDs) {
                JSONObject newVisitorIDNode = new JSONObject();
                String id = DataReader.optString(visitorID, (String)"ID", null);
                if (StringUtils.isNullOrEmpty((String)id)) continue;
                newVisitorIDNode.put("id", (Object)id);
                String type = DataReader.optString(visitorID, (String)"ID_TYPE", null);
                if (StringUtils.isNullOrEmpty((String)type)) continue;
                newVisitorIDNode.put("integrationCode", (Object)type);
                int authenticationStateInt = DataReader.optInt(visitorID, (String)"STATE", (int)-1);
                newVisitorIDNode.put("authenticatedState", (Object)this.getAuthenticationStateToString(VisitorID.AuthenticationState.fromInteger((int)authenticationStateInt)));
                customerIDsArrayNode.put((Object)newVisitorIDNode);
            }
        }
        catch (JSONException exception) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Failed to create json node for customer visitor ids (%s)", (Object[])new Object[]{exception});
        }
        return customerIDsArrayNode;
    }

    private String getAuthenticationStateToString(VisitorID.AuthenticationState value) {
        switch (value) {
            case AUTHENTICATED: {
                return "authenticated";
            }
            case LOGGED_OUT: {
                return "logged_out";
            }
        }
        return "unknown";
    }

    private JSONArray getPrefetchMboxes(List<TargetPrefetch> prefetchList, TargetParameters globalParameters, Map<String, String> lifecycleData) {
        if (prefetchList == null) {
            return null;
        }
        JSONArray prefetchMboxesArrayNode = new JSONArray();
        int index = 0;
        for (TargetPrefetch currentMbox : prefetchList) {
            try {
                prefetchMboxesArrayNode.put((Object)this.createMboxJsonObject(currentMbox.getMboxName(), currentMbox.getTargetParameters(), index, globalParameters, lifecycleData));
                ++index;
            }
            catch (JSONException exception) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"getPrefetchMboxes - Failed to create json node for mbox %s (%s)", (Object[])new Object[]{currentMbox.getMboxName(), exception});
            }
        }
        return prefetchMboxesArrayNode;
    }

    private JSONObject createMboxJsonObject(String mboxName, TargetParameters targetParameters, int index, TargetParameters globalParameters, Map<String, String> lifecycleData) throws JSONException {
        JSONObject mboxNode = new JSONObject();
        mboxNode.put("index", index);
        mboxNode.put("name", (Object)mboxName);
        List<TargetParameters> targetParametersList = Arrays.asList(targetParameters, globalParameters);
        TargetParameters parameters = TargetParameters.merge(targetParametersList);
        this.setTargetParametersJson(mboxNode, parameters, lifecycleData);
        return mboxNode;
    }

    private void setTargetParametersJson(JSONObject jsonNode, TargetParameters parameters, Map<String, String> lifecycleData) throws JSONException {
        JSONObject productNode;
        JSONObject orderNode;
        JSONObject profileParamJson;
        if (parameters == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"setTargetParametersJson - Unable to set the target parameters, TargetParamters are null", (Object[])new Object[0]);
            return;
        }
        JSONObject mboxParametersNode = this.getMboxParameters(parameters.getParameters(), lifecycleData);
        if (mboxParametersNode.length() > 0) {
            jsonNode.put("parameters", (Object)mboxParametersNode);
        }
        if ((profileParamJson = new JSONObject(parameters.getProfileParameters())).length() > 0) {
            jsonNode.put("profileParameters", (Object)profileParamJson);
        }
        if ((orderNode = this.getOrderParameters(parameters.getOrder())) != null && orderNode.length() > 0) {
            jsonNode.put("order", (Object)orderNode);
        }
        if ((productNode = this.getProductParameters(parameters.getProduct())) != null && productNode.length() > 0) {
            jsonNode.put("product", (Object)productNode);
        }
    }

    private JSONObject getMboxParameters(Map<String, String> mboxParameters, Map<String, String> lifecycleData) {
        HashMap<String, String> mboxParametersCopy = new HashMap<String, String>(mboxParameters);
        if (mboxParametersCopy.containsKey("at_property")) {
            mboxParametersCopy.remove("at_property");
        }
        JSONObject mboxParametersJson = new JSONObject(mboxParametersCopy);
        try {
            if (lifecycleData != null && !lifecycleData.isEmpty()) {
                for (Map.Entry<String, String> param : lifecycleData.entrySet()) {
                    mboxParametersJson.put(param.getKey(), (Object)param.getValue());
                }
            }
        }
        catch (JSONException exception) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"getMboxParameters - Failed to append internal parameters to the target request json (%s)", (Object[])new Object[]{exception});
        }
        return mboxParametersJson;
    }

    private JSONObject getOrderParameters(TargetOrder order) {
        if (order == null || StringUtils.isNullOrEmpty((String)order.getId())) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"getOrderParameters - Unable to get the order parameters, TargetOrder is null", (Object[])new Object[0]);
            return null;
        }
        JSONObject orderJson = new JSONObject();
        try {
            List<String> productIds;
            orderJson.put("id", (Object)order.getId());
            if (order.getTotal() != 0.0) {
                orderJson.put("total", order.getTotal());
            }
            if ((productIds = order.getPurchasedProductIds()) != null && !productIds.isEmpty()) {
                JSONArray productIdsJson = new JSONArray("[]");
                for (String productId : productIds) {
                    productIdsJson.put((Object)productId);
                }
                orderJson.put("purchasedProductIds", (Object)productIdsJson);
            }
            return orderJson;
        }
        catch (JSONException ex) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"getOrderParameters - Failed to create target order parameters (%s)", (Object[])new Object[]{ex});
            return null;
        }
    }

    private JSONObject getProductParameters(TargetProduct product) {
        if (product == null || StringUtils.isNullOrEmpty((String)product.getId())) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"getProductParameters - Unable to get the product parameters, TargetProduct is null", (Object[])new Object[0]);
            return null;
        }
        JSONObject productNode = new JSONObject();
        try {
            productNode.put("id", (Object)product.getId());
            if (!StringUtils.isNullOrEmpty((String)product.getCategoryId())) {
                productNode.put("categoryId", (Object)product.getCategoryId());
            }
        }
        catch (JSONException exception) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"getProductParameters - Failed to append product parameters to the target request json (%s)", (Object[])new Object[]{exception});
            return null;
        }
        return productNode;
    }

    private JSONObject getPreviewParameters() {
        if (this.targetPreviewManager.getPreviewToken() != null && this.targetPreviewManager.getPreviewParameters() != null) {
            try {
                return new JSONObject(this.targetPreviewManager.getPreviewParameters());
            }
            catch (JSONException e) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"getPreviewParameters - Could not compile the target preview params with the Target request (%s)", (Object[])new Object[]{e.getMessage()});
            }
        }
        return null;
    }
}

