/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.JSONUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class TargetState {
    private static final String CLASS_NAME = "TargetState";
    private final NamedCollection dataStore;
    private final Map<String, JSONObject> prefetchedMbox = new HashMap<String, JSONObject>();
    private final Map<String, JSONObject> loadedMbox = new HashMap<String, JSONObject>();
    private final List<JSONObject> notifications = new ArrayList<JSONObject>();
    private Map<String, Object> storedConfigurationSharedState = null;
    private String tntId = "";
    private String thirdPartyId = "";
    private String edgeHost = "";
    private String sessionId = "";
    private long sessionTimestampInSeconds = 0L;
    private static final List<String> LOADED_MBOX_ACCEPTED_KEYS = Arrays.asList("name", "metrics");

    TargetState(NamedCollection dataStore) {
        this.dataStore = dataStore;
        if (dataStore == null) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Unable to initialize TargetState, datastore is null", (Object[])new Object[0]);
            return;
        }
        this.tntId = dataStore.getString("TNT_ID", "");
        this.thirdPartyId = dataStore.getString("THIRD_PARTY_ID", "");
        this.edgeHost = dataStore.getString("EDGE_HOST", "");
        this.sessionId = dataStore.getString("SESSION_ID", "");
        this.sessionTimestampInSeconds = dataStore.getLong("SESSION_TIMESTAMP", 0L);
    }

    void updateConfigurationSharedState(Map<String, Object> configuration) {
        if (TargetUtils.isNullOrEmpty(configuration)) {
            return;
        }
        String newClientCode = DataReader.optString(configuration, (String)"target.clientCode", (String)"");
        if (this.storedConfigurationSharedState != null && !newClientCode.equals(this.getClientCode())) {
            this.updateEdgeHost(null);
        }
        this.storedConfigurationSharedState = configuration;
    }

    MobilePrivacyStatus getMobilePrivacyStatus() {
        String privacyString = DataReader.optString(this.storedConfigurationSharedState, (String)"global.privacy", (String)MobilePrivacyStatus.UNKNOWN.getValue());
        return MobilePrivacyStatus.fromString((String)privacyString);
    }

    int getSessionTimeout() {
        return DataReader.optInt(this.storedConfigurationSharedState, (String)"target.sessionTimeout", (int)1800);
    }

    String getClientCode() {
        return DataReader.optString(this.storedConfigurationSharedState, (String)"target.clientCode", (String)"");
    }

    long getEnvironmentId() {
        return DataReader.optLong(this.storedConfigurationSharedState, (String)"target.environmentId", (long)0L);
    }

    String getPropertyToken() {
        return DataReader.optString(this.storedConfigurationSharedState, (String)"target.propertyToken", (String)"");
    }

    String getTargetServer() {
        return DataReader.optString(this.storedConfigurationSharedState, (String)"target.server", (String)"");
    }

    int getNetworkTimeout() {
        return DataReader.optInt(this.storedConfigurationSharedState, (String)"target.timeout", (int)2);
    }

    String getSessionId() {
        if (StringUtils.isNullOrEmpty((String)this.sessionId) || this.isSessionExpired()) {
            this.sessionId = UUID.randomUUID().toString();
            if (this.dataStore != null) {
                this.dataStore.setString("SESSION_ID", this.sessionId);
            }
            this.updateSessionTimestamp(false);
        }
        return this.sessionId;
    }

    String getEdgeHost() {
        if (this.isSessionExpired()) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"getEdgeHost - Resetting edge host to null as session id expired.", (Object[])new Object[0]);
            this.updateEdgeHost(null);
        } else if (StringUtils.isNullOrEmpty((String)this.edgeHost) && this.dataStore != null) {
            this.edgeHost = this.dataStore.getString("EDGE_HOST", null);
        }
        return this.edgeHost;
    }

    String getTntId() {
        return this.tntId;
    }

    String getThirdPartyId() {
        return this.thirdPartyId;
    }

    Map<String, Object> getStoredConfigurationSharedState() {
        return this.storedConfigurationSharedState;
    }

    boolean isPreviewEnabled() {
        return DataReader.optBoolean(this.storedConfigurationSharedState, (String)"target.previewEnabled", (boolean)true);
    }

    void updateSessionTimestamp(boolean resetSessionTimestamp) {
        if (resetSessionTimestamp) {
            this.sessionTimestampInSeconds = 0L;
            if (this.dataStore != null) {
                Log.trace((String)"Target", (String)CLASS_NAME, (String)"updateSessionTimestamp - Attempting to remove the session timestamp", (Object[])new Object[0]);
                this.dataStore.remove("SESSION_TIMESTAMP");
            }
            return;
        }
        this.sessionTimestampInSeconds = TimeUtils.getUnixTimeInSeconds();
        if (this.dataStore != null) {
            Log.trace((String)"Target", (String)CLASS_NAME, (String)"updateSessionTimestamp - Attempting to update the session timestamp", (Object[])new Object[0]);
            this.dataStore.setLong("SESSION_TIMESTAMP", this.sessionTimestampInSeconds);
        }
    }

    void updateSessionId(String updatedSessionId) {
        this.sessionId = updatedSessionId;
        if (this.dataStore != null) {
            if (StringUtils.isNullOrEmpty((String)this.sessionId)) {
                Log.trace((String)"Target", (String)CLASS_NAME, (String)"updateSessionId - Attempting to remove the session id", (Object[])new Object[0]);
                this.dataStore.remove("SESSION_ID");
            } else {
                Log.trace((String)"Target", (String)CLASS_NAME, (String)"updateSessionId - Attempting to update the session id", (Object[])new Object[0]);
                this.dataStore.setString("SESSION_ID", updatedSessionId);
            }
        }
    }

    void updateTntId(String updatedTntId) {
        this.tntId = updatedTntId;
        if (this.dataStore != null) {
            if (StringUtils.isNullOrEmpty((String)updatedTntId)) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"setTntIdInternal - Removed tntId from the data store, provided tntId value is null or empty.", (Object[])new Object[0]);
                this.dataStore.remove("TNT_ID");
            } else {
                Log.debug((String)"Target", (String)"setTntIdInternal - Persisted new tntId (%s) in the data store.", (String)updatedTntId, (Object[])new Object[0]);
                this.dataStore.setString("TNT_ID", updatedTntId);
            }
        } else {
            Log.debug((String)"Target", (String)"setTntIdInternal - Failed to persist tntID, %s", (String)"Data store is not available.", (Object[])new Object[0]);
        }
    }

    void updateThirdPartyId(String updatedThirdPartyId) {
        this.thirdPartyId = updatedThirdPartyId;
        if (this.dataStore != null) {
            if (StringUtils.isNullOrEmpty((String)this.thirdPartyId)) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"setThirdPartyId - Removed thirdPartyId from the data store, provided thirdPartyId value is null or empty.", (Object[])new Object[0]);
                this.dataStore.remove("THIRD_PARTY_ID");
            } else {
                Log.debug((String)"Target", (String)"setThirdPartyId - Persisted new thirdPartyId (%s) in the data store.", (String)this.thirdPartyId, (Object[])new Object[0]);
                this.dataStore.setString("THIRD_PARTY_ID", this.thirdPartyId);
            }
        } else {
            Log.debug((String)"Target", (String)"setTntIsetThirdPartyIddInternal - Failed to persist thirdPartyId, %s", (String)"Data store is not available.", (Object[])new Object[0]);
        }
    }

    void updateEdgeHost(String updatedEdgeHost) {
        if (this.edgeHost == null && updatedEdgeHost == null || this.edgeHost != null && this.edgeHost.equals(updatedEdgeHost)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"updateEdgeHost - Data store is not updated as the provided edge host is same as the existing edgeHost", (Object[])new Object[0]);
            return;
        }
        this.edgeHost = updatedEdgeHost;
        if (this.dataStore != null) {
            if (StringUtils.isNullOrEmpty((String)this.edgeHost)) {
                this.dataStore.remove("EDGE_HOST");
            } else {
                this.dataStore.setString("EDGE_HOST", this.edgeHost);
            }
        }
    }

    void resetSession() {
        this.updateSessionId("");
        this.updateSessionTimestamp(true);
    }

    Map<String, Object> generateSharedState() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (!StringUtils.isNullOrEmpty((String)this.tntId)) {
            data.put("tntid", this.tntId);
        }
        if (!StringUtils.isNullOrEmpty((String)this.thirdPartyId)) {
            data.put("thirdpartyid", this.thirdPartyId);
        }
        return data;
    }

    void mergePrefetchedMboxJson(Map<String, JSONObject> mboxMap) {
        if (TargetUtils.isNullOrEmpty(mboxMap)) {
            return;
        }
        this.prefetchedMbox.putAll(mboxMap);
    }

    Map<String, JSONObject> getPrefetchedMbox() {
        return this.prefetchedMbox;
    }

    void clearPrefetchedMboxes() {
        this.prefetchedMbox.clear();
    }

    void saveLoadedMbox(@NonNull Map<String, JSONObject> mBoxResponses) {
        if (TargetUtils.isNullOrEmpty(mBoxResponses)) {
            return;
        }
        for (Map.Entry<String, JSONObject> mbox : mBoxResponses.entrySet()) {
            JSONObject clearedMboxNode;
            String mboxName = mbox.getKey();
            JSONObject mboxNode = mbox.getValue();
            if (StringUtils.isNullOrEmpty((String)mboxName) || this.prefetchedMbox.containsKey(mboxName) || mboxNode == null) continue;
            try {
                clearedMboxNode = new JSONObject(mboxNode.toString());
            }
            catch (JSONException e) {
                continue;
            }
            Iterator iterator = mboxNode.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (LOADED_MBOX_ACCEPTED_KEYS.contains(key)) continue;
                clearedMboxNode.remove(key);
            }
            this.loadedMbox.put(mboxName, clearedMboxNode);
        }
    }

    void removeDuplicateLoadedMboxes() {
        for (String mboxName : this.prefetchedMbox.keySet()) {
            if (mboxName == null) continue;
            this.loadedMbox.remove(mboxName);
        }
    }

    Map<String, JSONObject> getLoadedMbox() {
        return this.loadedMbox;
    }

    void clearNotifications() {
        this.notifications.clear();
    }

    void addNotification(JSONObject notification) {
        if (JSONUtils.isNullOrEmpty((JSONObject)notification)) {
            return;
        }
        this.notifications.add(notification);
    }

    List<JSONObject> getNotifications() {
        return this.notifications;
    }

    private boolean isSessionExpired() {
        long currentTimeSeconds = TimeUtils.getUnixTimeInSeconds();
        return this.sessionTimestampInSeconds > 0L && currentTimeSeconds - this.sessionTimestampInSeconds > (long)this.getSessionTimeout();
    }
}

