/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.userprofile;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.userprofile.JSONUtils;
import com.adobe.marketing.mobile.userprofile.MissingPlatformServicesException;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class ProfileData {
    private static final String USER_PROFILE_DATASTORE_NAME = "ADBUserProfile";
    private static final String KEY_USER_PROFILE = "user_profile";
    private static final String EMPTY_JSON = "{}";
    private static final String CLASS_NAME = "PersistentProfileData";
    private final NamedCollection namedCollection;
    private Map<String, Object> data = new HashMap<String, Object>();

    ProfileData() throws MissingPlatformServicesException {
        this.namedCollection = ServiceProvider.getInstance().getDataStoreService().getNamedCollection(USER_PROFILE_DATASTORE_NAME);
        if (this.namedCollection == null) {
            throw new MissingPlatformServicesException("Failed to create a NamedCollection service with the collection name [ADBUserProfile]");
        }
    }

    @VisibleForTesting
    ProfileData(NamedCollection namedCollection) {
        this.namedCollection = namedCollection;
    }

    boolean loadPersistenceData() {
        String json = this.namedCollection.getString(KEY_USER_PROFILE, EMPTY_JSON);
        try {
            if (json == null) {
                return true;
            }
            JSONObject jsonObject = new JSONObject(json);
            this.data = JSONUtils.convertJsonObjectToNestedMap(jsonObject);
            return true;
        }
        catch (JSONException e) {
            Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"Could not load persistent profile data: %s", (Object[])new Object[]{e});
            return false;
        }
    }

    boolean persist() {
        try {
            if (this.namedCollection == null) {
                return false;
            }
            String json = new JSONObject(this.data).toString();
            this.namedCollection.setString(KEY_USER_PROFILE, json);
            Log.trace((String)"UserProfile", (String)CLASS_NAME, (String)"Profile Data is persisted : %s", (Object[])new Object[]{json});
            return true;
        }
        catch (Exception e) {
            Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"Profile Data is not persisted : %s", (Object[])new Object[]{e});
            return false;
        }
    }

    void delete(@NonNull List<String> keys) {
        for (String key : keys) {
            this.data.remove(key);
        }
    }

    @Nullable
    Object get(String key) {
        return this.data.get(key);
    }

    @Nullable
    Map<String, Object> getMap(String key) {
        try {
            return DataReader.getTypedMap(Object.class, this.data, (String)key);
        }
        catch (DataReaderException e) {
            return null;
        }
    }

    void updateOrDelete(@NonNull Map<String, Object> profileAttributes) {
        for (Map.Entry<String, Object> entry : profileAttributes.entrySet()) {
            this.updateOrDelete(entry.getKey(), entry.getValue());
        }
    }

    private void updateOrDelete(@NonNull String key, @Nullable Object value) {
        if (value == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, value);
        }
    }

    Map<String, Object> getMap() {
        return Collections.unmodifiableMap(this.data);
    }
}

