/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.userprofile;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.UserProfile;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.userprofile.MissingPlatformServicesException;
import com.adobe.marketing.mobile.userprofile.ProfileData;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserProfileExtension
extends Extension {
    static final String CLASS_NAME = "UserProfileExtension";
    private ProfileData profileData;

    protected UserProfileExtension(ExtensionApi extensionApi) {
        super(extensionApi);
    }

    protected String getVersion() {
        return UserProfile.extensionVersion();
    }

    @NonNull
    protected String getName() {
        return "com.adobe.module.userProfile";
    }

    protected String getFriendlyName() {
        return "UserProfile";
    }

    protected void onRegistered() {
        this.getApi().registerEventListener("com.adobe.eventType.userProfile", "com.adobe.eventSource.requestProfile", this::handleProfileRequestEvent);
        this.getApi().registerEventListener("com.adobe.eventType.userProfile", "com.adobe.eventSource.requestReset", this::handleProfileResetEvent);
        this.getApi().registerEventListener("com.adobe.eventType.rulesEngine", "com.adobe.eventSource.responseContent", this::handleRulesEvent);
        if (this.loadProfileDataIfNeeded() && !this.profileData.getMap().isEmpty()) {
            this.updateSharedStateAndDispatchEvent(null);
        }
    }

    void handleProfileRequestEvent(@NonNull Event event) {
        if (this.profileData == null) {
            Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Unable to work with Persisted profile data.", (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        if (eventData == null || eventData.isEmpty()) {
            Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Unexpected Null/empty Value (Event data). Ignoring event", (Object[])new Object[0]);
            return;
        }
        if (eventData.containsKey("userprofileupdatekey")) {
            this.handleProfileUpdateEvent(event);
        } else if (eventData.containsKey("userprofilegetattributes")) {
            this.handleProfileGetAttributesEvent(event);
        } else {
            Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"No update/get request key in eventData. Ignoring event", (Object[])new Object[0]);
        }
    }

    void handleProfileResetEvent(@NonNull Event event) {
        if (this.profileData == null) {
            Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Unable to work with Persisted profile data.", (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        if (eventData == null || eventData.isEmpty()) {
            Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Unexpected Null Value (event data), discarding the user profile request reset event.", (Object[])new Object[0]);
            return;
        }
        if (!eventData.containsKey("userprofileremovekeys")) {
            Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"No remove request key in eventData. Ignoring event", (Object[])new Object[0]);
            return;
        }
        this.handleProfileDeleteEvent(event);
    }

    void handleProfileUpdateEvent(@NonNull Event event) {
        try {
            Map profileAttributes = DataReader.getTypedMap(Object.class, (Map)event.getEventData(), (String)"userprofileupdatekey");
            if (profileAttributes.size() > 0) {
                this.updateProfilesAndDispatchSharedState(profileAttributes, event);
            }
        }
        catch (Exception e) {
            Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"Could not extract the profile update request data from the Event.", (Object[])new Object[0]);
        }
    }

    void handleProfileGetAttributesEvent(@NonNull Event event) {
        HashMap<String, Object> map;
        block4: {
            map = new HashMap<String, Object>();
            try {
                List nameList = DataReader.getTypedList(String.class, (Map)event.getEventData(), (String)"userprofilegetattributes");
                if (nameList != null && nameList.size() > 0) {
                    for (String name : nameList) {
                        Object attribute = this.profileData.get(name);
                        if (attribute == null) continue;
                        map.put(name, attribute);
                    }
                    break block4;
                }
                return;
            }
            catch (Exception e) {
                Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"Could not find specific data from persisted profile data - (%s)", (Object[])new Object[]{e});
                return;
            }
        }
        HashMap<String, HashMap<String, Object>> eventDataMap = new HashMap<String, HashMap<String, Object>>();
        eventDataMap.put("userprofilegetattributes", map);
        Event responseEvent = new Event.Builder("UserProfile Response Event", "com.adobe.eventType.userProfile", "com.adobe.eventSource.responseProfile").setEventData(eventDataMap).inResponseToEvent(event).build();
        this.getApi().dispatch(responseEvent);
    }

    void handleProfileDeleteEvent(@NonNull Event event) {
        try {
            List deleteKeys = DataReader.getTypedList(String.class, (Map)event.getEventData(), (String)"userprofileremovekeys");
            if (deleteKeys.size() > 0) {
                this.deleteProfileAndDispatchSharedState(deleteKeys, event);
            }
        }
        catch (Exception e) {
            Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"Could not extract the profile request data from the Event - (%s)", (Object[])new Object[]{e});
        }
    }

    void handleRulesEvent(@NonNull Event event) {
        if (this.profileData == null) {
            Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Unable to work with Persisted profile data.", (Object[])new Object[0]);
            return;
        }
        try {
            Map triggeredConsequence = DataReader.getTypedMap(Object.class, (Map)event.getEventData(), (String)"triggeredconsequence");
            if (triggeredConsequence == null || triggeredConsequence.isEmpty()) {
                return;
            }
            String consequenceType = DataReader.getString((Map)triggeredConsequence, (String)"type");
            if (!"csp".equals(consequenceType)) {
                return;
            }
            String consequenceId = DataReader.getString((Map)triggeredConsequence, (String)"id");
            Map consequenceDetail = DataReader.getTypedMap(Object.class, (Map)triggeredConsequence, (String)"detail");
            if (consequenceDetail == null || consequenceDetail.isEmpty()) {
                Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Unable to process UserProfileExtension Consequence. Invalid detail provided for consequence id (%s)", (Object[])new Object[]{consequenceId});
                return;
            }
            Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Processing UserProfileExtension Consequence with id (%s)", (Object[])new Object[]{consequenceId});
            String operation = DataReader.getString((Map)consequenceDetail, (String)"operation");
            if ("write".equals(operation)) {
                this.handleWriteConsequence(consequenceDetail, event);
            } else if ("delete".equals(operation)) {
                this.handleDeleteConsequence(consequenceDetail, event);
            } else {
                Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Invalid UserProfileExtension consequence operation", (Object[])new Object[0]);
            }
        }
        catch (Exception exp) {
            Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"Could not extract the consequence information from the rules response event - (%s)", (Object[])new Object[]{exp});
        }
    }

    private void handleWriteConsequence(@NonNull Map<String, Object> consequenceDetails, @NonNull Event event) {
        try {
            String writeKey = DataReader.getString(consequenceDetails, (String)"key");
            Object writeValue = consequenceDetails.get("value");
            if (StringUtils.isNullOrEmpty((String)writeKey)) {
                Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Invalid write key from the user profile consequence", (Object[])new Object[0]);
                return;
            }
            Object updatedWriteValue = writeValue == null ? null : this.replaceValueForIAMKey(writeKey, writeValue);
            HashMap<String, Object> profileAttribute = new HashMap<String, Object>();
            profileAttribute.put(writeKey, updatedWriteValue);
            this.updateProfilesAndDispatchSharedState(profileAttribute, event);
        }
        catch (Exception e) {
            Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"Could not extract the profile update request data from the rule consequence details.", (Object[])new Object[0]);
        }
    }

    private void handleDeleteConsequence(@NonNull Map<String, Object> consequenceDetails, @NonNull Event event) {
        try {
            String deleteKey = DataReader.getString(consequenceDetails, (String)"key");
            if (StringUtils.isNullOrEmpty((String)deleteKey)) {
                Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Invalid delete key from the user profile consequence", (Object[])new Object[0]);
                return;
            }
            ArrayList<String> profileKeys = new ArrayList<String>(1);
            profileKeys.add(deleteKey);
            this.deleteProfileAndDispatchSharedState(profileKeys, event);
        }
        catch (Exception e) {
            Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"Could not extract the profile update request data from the rule consequence details.", (Object[])new Object[0]);
        }
    }

    private void updateProfilesAndDispatchSharedState(@NonNull Map<String, Object> profileAttribute, @NonNull Event event) {
        this.profileData.updateOrDelete(profileAttribute);
        if (this.profileData.persist()) {
            this.updateSharedStateAndDispatchEvent(event);
        }
    }

    private void deleteProfileAndDispatchSharedState(@NonNull List<String> keys, @NonNull Event event) {
        this.profileData.delete(keys);
        if (this.profileData.persist()) {
            this.updateSharedStateAndDispatchEvent(event);
        }
    }

    private Object replaceValueForIAMKey(@NonNull String key, @Nullable Object value) {
        if (key.equals("a.triggered") || key.equals("a.clicked") || key.equals("a.viewed")) {
            Map<String, Object> messagesAggregateMap = this.profileData.getMap(key);
            if (messagesAggregateMap == null) {
                messagesAggregateMap = new HashMap<String, Object>();
            }
            String messageId = String.valueOf(value);
            int count = DataReader.optInt(messagesAggregateMap, (String)messageId, (int)0);
            messagesAggregateMap.put(messageId, ++count);
            return messagesAggregateMap;
        }
        return value;
    }

    private void updateSharedStateAndDispatchEvent(@Nullable Event event) {
        HashMap<String, Map<String, Object>> eventDataMap = new HashMap<String, Map<String, Object>>();
        if (this.profileData != null) {
            eventDataMap.put("userprofiledata", this.profileData.getMap());
        }
        this.getApi().createSharedState(eventDataMap, event);
        Event responseEvent = new Event.Builder("UserProfile Response Event", "com.adobe.eventType.userProfile", "com.adobe.eventSource.responseProfile").setEventData(eventDataMap).build();
        this.getApi().dispatch(responseEvent);
    }

    private boolean loadProfileDataIfNeeded() {
        if (this.profileData == null) {
            try {
                this.profileData = new ProfileData();
            }
            catch (MissingPlatformServicesException e) {
                Log.debug((String)"UserProfile", (String)CLASS_NAME, (String)"Unable to work with Persisted profile data - (%s)", (Object[])new Object[]{e});
                return false;
            }
            return this.profileData.loadPersistenceData();
        }
        return true;
    }
}

