/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.userprofile;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.services.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class JSONUtils {
    private static final String CLASS_NAME = "JSONUtils";

    JSONUtils() {
    }

    static Map<String, Object> convertJsonObjectToNestedMap(@NonNull JSONObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    JSONObject nestedJsonObject = (JSONObject)value;
                    map.put(key, JSONUtils.convertJsonObjectToNestedMap(nestedJsonObject));
                    continue;
                }
                if (value instanceof JSONArray) {
                    Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"Profile Data doesn't support Array value.", (Object[])new Object[0]);
                    continue;
                }
                map.put(key, value);
            }
            catch (Exception e) {
                Log.error((String)"UserProfile", (String)CLASS_NAME, (String)"The value of [%s] is not supported: %s", (Object[])new Object[]{key, e});
            }
        }
        return map;
    }
}

