/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.junit5;

import com.adobe.testing.s3mock.S3MockApplication;
import com.adobe.testing.s3mock.testsupport.common.S3MockStarter;
import com.amazonaws.services.s3.AmazonS3;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class S3MockExtension
extends S3MockStarter
implements BeforeAllCallback,
AfterAllCallback,
ParameterResolver {
    private int mockAccess;

    public static Builder builder() {
        return new Builder();
    }

    public S3MockExtension() {
        super(null);
    }

    private S3MockExtension(Map<String, Object> properties) {
        super(properties);
    }

    public void beforeAll(ExtensionContext context) {
        this.startOnlySingleInstance();
    }

    public void afterAll(ExtensionContext context) {
        this.stopWhenLastConsumerFinished();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.paramHasType(parameterContext, S3MockApplication.class) || this.paramHasType(parameterContext, AmazonS3.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.paramHasType(parameterContext, S3MockApplication.class)) {
            return this.s3MockFileStore;
        }
        if (this.paramHasType(parameterContext, AmazonS3.class)) {
            return this.createS3Client();
        }
        return null;
    }

    private boolean paramHasType(ParameterContext parameterContext, Class<?> cls) {
        Class<?> requiredType = parameterContext.getParameter().getType();
        return requiredType.isAssignableFrom(cls);
    }

    private synchronized void stopWhenLastConsumerFinished() {
        if (--this.mockAccess == 0) {
            this.stop();
        }
    }

    private synchronized void startOnlySingleInstance() {
        if (this.mockAccess++ == 0) {
            this.start();
        }
    }

    public static class Builder
    extends S3MockStarter.BaseBuilder<S3MockExtension> {
        public S3MockExtension build() {
            return new S3MockExtension(this.arguments);
        }
    }
}

