/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.MetadataDirective;
import com.adobe.testing.s3mock.dto.BatchDeleteRequest;
import com.adobe.testing.s3mock.dto.BatchDeleteResponse;
import com.adobe.testing.s3mock.dto.Bucket;
import com.adobe.testing.s3mock.dto.BucketContents;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadRequest;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListAllMyBucketsResult;
import com.adobe.testing.s3mock.dto.ListBucketResult;
import com.adobe.testing.s3mock.dto.ListBucketResultV2;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.MultipartUpload;
import com.adobe.testing.s3mock.dto.ObjectIdentifier;
import com.adobe.testing.s3mock.dto.ObjectRef;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Part;
import com.adobe.testing.s3mock.dto.Range;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.dto.Tagging;
import com.adobe.testing.s3mock.store.FileStore;
import com.adobe.testing.s3mock.store.S3Exception;
import com.adobe.testing.s3mock.store.S3Object;
import com.adobe.testing.s3mock.util.AwsChunkedDecodingInputStream;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.adobe.testing.s3mock.util.MetadataUtil;
import com.adobe.testing.s3mock.util.StringEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@CrossOrigin(origins={"*"})
@RequestMapping(value={"${com.adobe.testing.s3mock.contextPath:}"})
public class FileStoreController {
    private static final String RANGES_BYTES = "bytes";
    private static final String STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String RESPONSE_HEADER_CONTENT_TYPE = "response-content-type";
    private static final String RESPONSE_HEADER_CONTENT_LANGUAGE = "response-content-language";
    private static final String RESPONSE_HEADER_EXPIRES = "response-expires";
    private static final String RESPONSE_HEADER_CACHE_CONTROL = "response-cache-control";
    private static final String RESPONSE_HEADER_CONTENT_DISPOSITION = "response-content-disposition";
    private static final String RESPONSE_HEADER_CONTENT_ENCODING = "response-content-encoding";
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreController.class);
    private static final Owner TEST_OWNER = new Owner(123L, "s3-mock-file-store");
    private static final Comparator<String> KEY_COMPARATOR = Comparator.naturalOrder();
    private static final Comparator<BucketContents> BUCKET_CONTENTS_COMPARATOR = Comparator.comparing(BucketContents::getKey, KEY_COMPARATOR);
    private static final MediaType FALLBACK_MEDIA_TYPE = new MediaType("binary", "octet-stream");
    private static final Long MINIMUM_PART_SIZE = 0x500000L;
    private final Map<String, String> fileStorePagingStateCache = new ConcurrentHashMap<String, String>();
    private final FileStore fileStore;

    public FileStoreController(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<ListAllMyBucketsResult> listBuckets() {
        return ResponseEntity.ok((Object)new ListAllMyBucketsResult(TEST_OWNER, this.fileStore.listBuckets()));
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.PUT})
    public ResponseEntity<String> createBucket(@PathVariable String bucketName) {
        try {
            this.fileStore.createBucket(bucketName);
            return ResponseEntity.ok().build();
        }
        catch (RuntimeException e) {
            LOG.error("Bucket could not be created!", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> headBucket(@PathVariable String bucketName) {
        if (this.fileStore.doesBucketExist(bucketName).booleanValue()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteBucket(@PathVariable String bucketName) {
        boolean deleted;
        this.verifyBucketExistence(bucketName);
        try {
            if (!this.fileStore.getS3Objects(bucketName, null).isEmpty()) {
                throw new S3Exception(HttpStatus.CONFLICT.value(), "BucketNotEmpty", "The bucket you tried to delete is not empty.");
            }
            deleted = this.fileStore.deleteBucket(bucketName);
        }
        catch (IOException e) {
            LOG.error("Bucket could not be deleted!", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @Deprecated
    public ResponseEntity<ListBucketResult> listObjectsInsideBucket(@PathVariable String bucketName, @RequestParam(required=false) String prefix, @RequestParam(required=false) String delimiter, @RequestParam(required=false) String marker, @RequestParam(name="encoding-type", required=false) String encodingType, @RequestParam(name="max-keys", defaultValue="1000", required=false) Integer maxKeys) {
        this.verifyBucketExistence(bucketName);
        if (maxKeys < 0) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "maxKeys should be non-negative");
        }
        if (StringUtils.isNotEmpty((CharSequence)encodingType) && !"url".equals(encodingType)) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "encodingtype can only be none or 'url'");
        }
        boolean useUrlEncoding = Objects.equals("url", encodingType);
        try {
            List<BucketContents> contents = this.getBucketContents(bucketName, prefix);
            contents = FileStoreController.filterBucketContentsBy(contents, marker);
            boolean isTruncated = false;
            String nextMarker = null;
            Set<String> commonPrefixes = FileStoreController.collapseCommonPrefixes(prefix, delimiter, contents);
            contents = FileStoreController.filterBucketContentsBy(contents, commonPrefixes);
            if (maxKeys < contents.size()) {
                contents = contents.subList(0, maxKeys);
                isTruncated = true;
                if (maxKeys > 0) {
                    nextMarker = contents.get(maxKeys - 1).getKey();
                }
            }
            String returnPrefix = prefix;
            Set<String> returnCommonPrefixes = commonPrefixes;
            if (useUrlEncoding) {
                contents = this.applyUrlEncoding(contents);
                returnPrefix = StringUtils.isNotBlank((CharSequence)prefix) ? StringEncoding.encode(prefix) : prefix;
                returnCommonPrefixes = this.applyUrlEncoding(commonPrefixes);
            }
            return ResponseEntity.ok((Object)new ListBucketResult(bucketName, returnPrefix, marker, maxKeys, isTruncated, encodingType, nextMarker, contents, returnCommonPrefixes));
        }
        catch (IOException e) {
            LOG.error("Object(s) could not retrieved from bucket {}", (Object)bucketName, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @RequestMapping(value={"/{bucketName}"}, params={"list-type=2"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<ListBucketResultV2> listObjectsInsideBucketV2(@PathVariable String bucketName, @RequestParam(required=false) String prefix, @RequestParam(required=false) String delimiter, @RequestParam(name="encoding-type", required=false) String encodingtype, @RequestParam(name="start-after", required=false) String startAfter, @RequestParam(name="max-keys", defaultValue="1000", required=false) Integer maxKeys, @RequestParam(name="continuation-token", required=false) String continuationToken) {
        if (StringUtils.isNotEmpty((CharSequence)encodingtype) && !"url".equals(encodingtype)) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "encodingtype can only be none or 'url'");
        }
        boolean useUrlEncoding = Objects.equals("url", encodingtype);
        this.verifyBucketExistence(bucketName);
        try {
            List<BucketContents> contents = this.getBucketContents(bucketName, prefix);
            String nextContinuationToken = null;
            boolean isTruncated = false;
            if (continuationToken != null) {
                String continueAfter = this.fileStorePagingStateCache.get(continuationToken);
                contents = FileStoreController.filterBucketContentsBy(contents, continueAfter);
                this.fileStorePagingStateCache.remove(continuationToken);
            } else {
                contents = FileStoreController.filterBucketContentsBy(contents, startAfter);
            }
            Set<String> commonPrefixes = FileStoreController.collapseCommonPrefixes(prefix, delimiter, contents);
            contents = FileStoreController.filterBucketContentsBy(contents, commonPrefixes);
            if (contents.size() > maxKeys) {
                isTruncated = true;
                nextContinuationToken = UUID.randomUUID().toString();
                contents = contents.subList(0, maxKeys);
                this.fileStorePagingStateCache.put(nextContinuationToken, contents.get(maxKeys - 1).getKey());
            }
            String returnPrefix = prefix;
            String returnStartAfter = startAfter;
            Set<String> returnCommonPrefixes = commonPrefixes;
            if (useUrlEncoding) {
                contents = this.applyUrlEncoding(contents);
                returnPrefix = StringUtils.isNotBlank((CharSequence)prefix) ? StringEncoding.encode(prefix) : prefix;
                returnStartAfter = StringUtils.isNotBlank((CharSequence)startAfter) ? StringEncoding.encode(startAfter) : startAfter;
                returnCommonPrefixes = this.applyUrlEncoding(commonPrefixes);
            }
            return ResponseEntity.ok((Object)new ListBucketResultV2(bucketName, returnPrefix, maxKeys, isTruncated, contents, returnCommonPrefixes, continuationToken, String.valueOf(contents.size()), nextContinuationToken, returnStartAfter, encodingtype));
        }
        catch (IOException e) {
            LOG.error("Object(s) could not retrieved from bucket {}", (Object)bucketName, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @RequestMapping(value={"/{bucketName:.+}/"}, params={"uploads"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<ListMultipartUploadsResult> listMultipartUploads(@PathVariable String bucketName, @RequestParam(required=false) String prefix, @RequestParam String uploads) {
        this.verifyBucketExistence(bucketName);
        List<MultipartUpload> multipartUploads = this.fileStore.listMultipartUploads(bucketName).stream().filter(m -> StringUtils.isBlank((CharSequence)prefix) || m.getKey().startsWith(prefix)).map(m -> new MultipartUpload(StringEncoding.decode(m.getKey()), m.getUploadId(), m.getOwner(), m.getInitiator(), m.getInitiated())).collect(Collectors.toList());
        int maxUploads = Math.max(1000, multipartUploads.size());
        boolean isTruncated = false;
        String uploadIdMarker = null;
        String nextUploadIdMarker = null;
        String keyMarker = null;
        String nextKeyMarker = null;
        String delimiter = null;
        List<String> commonPrefixes = Collections.emptyList();
        return ResponseEntity.ok((Object)new ListMultipartUploadsResult(bucketName, keyMarker, delimiter, prefix, uploadIdMarker, maxUploads, false, nextKeyMarker, nextUploadIdMarker, multipartUploads, commonPrefixes));
    }

    @RequestMapping(value={"/{bucketName}"}, params={"delete"}, method={RequestMethod.POST}, produces={"application/xml"})
    public ResponseEntity<BatchDeleteResponse> batchDeleteObjects(@PathVariable String bucketName, @RequestBody BatchDeleteRequest body) {
        this.verifyBucketExistence(bucketName);
        BatchDeleteResponse response = new BatchDeleteResponse();
        for (ObjectIdentifier object : body.getObjectsToDelete()) {
            try {
                if (!this.fileStore.deleteObject(bucketName, StringEncoding.encode(object.getKey()))) continue;
                response.addDeletedObject(object);
            }
            catch (IOException e) {
                LOG.error("Object could not be deleted!", (Throwable)e);
            }
        }
        return ResponseEntity.ok((Object)response);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.HEAD})
    public ResponseEntity<String> headObject(@PathVariable String bucketName, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        S3Object s3Object = this.fileStore.getS3Object(bucketName, filename);
        if (s3Object != null) {
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers -> headers.setAll(MetadataUtil.createUserMetadataHeaders(s3Object)))).headers(headers -> {
                if (s3Object.isEncrypted()) {
                    headers.set("x-amz-server-side-encryption-aws-kms-key-id", s3Object.getKmsKeyId());
                }
            })).contentType(this.parseMediaType(s3Object.getContentType())).eTag("\"" + s3Object.getEtag() + "\"")).contentLength(Long.parseLong(s3Object.getSize())).lastModified(s3Object.getLastModified())).build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteObject(@PathVariable String bucketName, HttpServletRequest request) {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        try {
            this.fileStore.deleteObject(bucketName, filename);
        }
        catch (IOException e) {
            LOG.error("Object could not be deleted!", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId"}, method={RequestMethod.DELETE}, produces={"application/xml"})
    public ResponseEntity<Void> abortMultipartUpload(@PathVariable String bucketName, @RequestParam String uploadId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.fileStore.abortMultipartUpload(bucketName, filename, uploadId);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<StreamingResponseBody> getObject(@PathVariable String bucketName, @RequestHeader(value="Range", required=false) Range range, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="If-None-Match", required=false) List<String> noMatch, HttpServletRequest request) throws IOException {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        S3Object s3Object = this.verifyObjectExistence(bucketName, filename);
        this.verifyObjectMatching(match, noMatch, s3Object.getEtag());
        if (range != null) {
            return this.getObjectWithRange(range, s3Object);
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag("\"" + s3Object.getEtag() + "\"")).header("Content-Encoding", new String[]{s3Object.getContentEncoding()})).header("Accept-Ranges", new String[]{RANGES_BYTES})).headers(headers -> headers.setAll(MetadataUtil.createUserMetadataHeaders(s3Object)))).lastModified(s3Object.getLastModified())).contentLength(s3Object.getDataFile().length()).contentType(this.parseMediaType(s3Object.getContentType())).headers(headers -> headers.setAll(this.addOverrideHeaders(request.getQueryString())))).body(outputStream -> Files.copy(s3Object.getDataFile().toPath(), outputStream));
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"tagging"}, method={RequestMethod.GET})
    public ResponseEntity<Tagging> getObjectTagging(@PathVariable String bucketName, HttpServletRequest request) {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        S3Object s3Object = this.verifyObjectExistence(bucketName, filename);
        ArrayList<Tag> tagList = new ArrayList<Tag>(s3Object.getTags());
        Tagging result = new Tagging(tagList);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag("\"" + s3Object.getEtag() + "\"")).lastModified(s3Object.getLastModified())).body((Object)result);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<ListPartsResult> multipartListParts(@PathVariable String bucketName, @RequestParam String uploadId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        List<Part> parts = this.fileStore.getMultipartUploadParts(bucketName, filename, uploadId);
        return ResponseEntity.ok((Object)new ListPartsResult(bucketName, filename, uploadId, parts));
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"tagging"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putObjectTagging(@PathVariable String bucketName, @RequestBody Tagging body, HttpServletRequest request) {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        S3Object s3Object = this.verifyObjectExistence(bucketName, filename);
        try {
            this.fileStore.setObjectTags(bucketName, filename, body.getTagSet());
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag("\"" + s3Object.getEtag() + "\"")).lastModified(s3Object.getLastModified())).build();
        }
        catch (IOException e) {
            LOG.error("Tags could not be set!", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId", "partNumber"}, headers={"!x-amz-copy-source", "!x-amz-copy-source-range"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> putObjectPart(@PathVariable String bucketName, @RequestParam String uploadId, @RequestParam String partNumber, @RequestHeader(value="x-amz-server-side-encryption", required=false) String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, @RequestHeader(value="x-amz-content-sha256", required=false) String sha256Header, HttpServletRequest request) throws IOException {
        this.verifyBucketExistence(bucketName);
        this.verifyPartNumberLimits(partNumber);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        String etag = this.fileStore.putPart(bucketName, filename, uploadId, partNumber, (InputStream)request.getInputStream(), FileStoreController.isV4ChunkedWithSigningEnabled(sha256Header));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag("\"" + etag + "\"")).build();
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, headers={"x-amz-copy-source"}, params={"uploadId", "partNumber"}, method={RequestMethod.PUT}, produces={"application/xml"})
    public ResponseEntity<CopyPartResult> copyObjectPart(@RequestHeader(value="x-amz-copy-source") ObjectRef copySource, @RequestHeader(value="x-amz-copy-source-range", required=false) Range copyRange, @RequestHeader(value="x-amz-server-side-encryption", required=false) String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, @PathVariable String destinationBucket, @RequestParam String uploadId, @RequestParam String partNumber, HttpServletRequest request) throws IOException {
        this.verifyBucketExistence(destinationBucket);
        String destinationFile = FileStoreController.filenameFrom(destinationBucket, request);
        String partEtag = this.fileStore.copyPart(copySource.getBucket(), copySource.getKey(), copyRange, partNumber, destinationBucket, destinationFile, uploadId);
        return ResponseEntity.ok((Object)CopyPartResult.from(new Date(), "\"" + partEtag + "\""));
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putObject(@PathVariable String bucketName, @RequestHeader(value="x-amz-server-side-encryption", required=false) String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, @RequestHeader(name="x-amz-tagging", required=false) List<Tag> tags, @RequestHeader(value="Content-Encoding", required=false) String contentEncoding, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Content-MD5", required=false) String contentMd5, @RequestHeader(value="x-amz-content-sha256", required=false) String sha256Header, HttpServletRequest request) throws IOException {
        ResponseEntity responseEntity;
        block8: {
            this.verifyBucketExistence(bucketName);
            String filename = FileStoreController.filenameFrom(bucketName, request);
            ServletInputStream inputStream = request.getInputStream();
            try {
                InputStream stream = FileStoreController.verifyMd5((InputStream)inputStream, contentMd5, sha256Header);
                Map<String, String> userMetadata = MetadataUtil.getUserMetadata(request);
                S3Object s3Object = this.fileStore.putS3Object(bucketName, filename, this.parseMediaType(contentType).toString(), contentEncoding, stream, FileStoreController.isV4ChunkedWithSigningEnabled(sha256Header), userMetadata, encryption, kmsKeyId);
                this.fileStore.setObjectTags(bucketName, filename, tags);
                responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag("\"" + s3Object.getEtag() + "\"")).lastModified(s3Object.getLastModified())).header("x-amz-server-side-encryption-aws-kms-key-id", new String[]{kmsKeyId})).build();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    LOG.error("Object could not be uploaded!", (Throwable)e);
                    throw new S3Exception(HttpStatus.INTERNAL_SERVER_ERROR.value(), "InternalServerError", "Error persisting object.");
                }
            }
            inputStream.close();
        }
        return responseEntity;
    }

    private static InputStream verifyMd5(InputStream inputStream, String contentMd5, String sha256Header) throws IOException, NoSuchAlgorithmException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileStoreController.copyTo(inputStream, byteArrayOutputStream);
        InputStream stream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        if (FileStoreController.isV4ChunkedWithSigningEnabled(sha256Header)) {
            stream = new AwsChunkedDecodingInputStream(stream);
        }
        FileStoreController.verifyMd5(stream, contentMd5);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private static void verifyMd5(InputStream inputStream, String contentMd5) throws NoSuchAlgorithmException, IOException {
        String md5;
        if (contentMd5 != null && !(md5 = DigestUtil.getBase64Digest(inputStream)).equals(contentMd5)) {
            LOG.error("Content-MD5 {} does not match object md5 {}", (Object)contentMd5, (Object)md5);
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "BadRequest", "Content-MD5 does not match object md5");
        }
    }

    static void copyTo(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) > 0) {
            target.write(buf, 0, length);
        }
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, headers={"x-amz-copy-source"}, params={"!uploadId"}, method={RequestMethod.PUT}, produces={"application/xml"})
    public ResponseEntity<CopyObjectResult> copyObject(@PathVariable String destinationBucket, @RequestHeader(value="x-amz-copy-source") ObjectRef objectRef, @RequestHeader(value="x-amz-metadata-directive", defaultValue="COPY") MetadataDirective metadataDirective, @RequestHeader(value="x-amz-server-side-encryption", required=false) String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, HttpServletRequest request) throws IOException {
        this.verifyBucketExistence(destinationBucket);
        String destinationFile = FileStoreController.filenameFrom(destinationBucket, request);
        CopyObjectResult copyObjectResult = MetadataDirective.REPLACE == metadataDirective ? this.fileStore.copyS3ObjectEncrypted(objectRef.getBucket(), objectRef.getKey(), destinationBucket, destinationFile, encryption, kmsKeyId, MetadataUtil.getUserMetadata(request)) : this.fileStore.copyS3ObjectEncrypted(objectRef.getBucket(), objectRef.getKey(), destinationBucket, destinationFile, encryption, kmsKeyId);
        if (copyObjectResult == null) {
            return ResponseEntity.notFound().header("x-amz-server-side-encryption-aws-kms-key-id", new String[]{kmsKeyId}).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("x-amz-server-side-encryption-aws-kms-key-id", new String[]{kmsKeyId})).body((Object)copyObjectResult);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploads"}, method={RequestMethod.POST}, produces={"application/xml"})
    public ResponseEntity<InitiateMultipartUploadResult> initiateMultipartUpload(@PathVariable String bucketName, @RequestHeader(value="x-amz-server-side-encryption", required=false) String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        Map<String, String> userMetadata = MetadataUtil.getUserMetadata(request);
        String uploadId = UUID.randomUUID().toString();
        this.fileStore.prepareMultipartUpload(bucketName, filename, this.parseMediaType(request.getContentType()).toString(), request.getHeader("Content-Encoding"), uploadId, TEST_OWNER, TEST_OWNER, userMetadata);
        return ResponseEntity.ok((Object)new InitiateMultipartUploadResult(bucketName, StringEncoding.decode(filename), uploadId));
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId"}, method={RequestMethod.POST}, produces={"application/xml"})
    public ResponseEntity<CompleteMultipartUploadResult> completeMultipartUpload(@PathVariable String bucketName, @RequestParam String uploadId, @RequestHeader(value="x-amz-server-side-encryption", required=false) String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, @RequestBody CompleteMultipartUploadRequest requestBody, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.validateMultipartParts(bucketName, filename, uploadId, requestBody.getParts());
        String eTag = this.fileStore.completeMultipartUpload(bucketName, filename, uploadId, requestBody.getParts(), encryption, kmsKeyId);
        return ResponseEntity.ok((Object)new CompleteMultipartUploadResult(request.getRequestURL().toString(), bucketName, filename, eTag));
    }

    private ResponseEntity<StreamingResponseBody> getObjectWithRange(Range range, S3Object s3Object) {
        long fileSize = s3Object.getDataFile().length();
        long bytesToRead = Math.min(fileSize - 1L, range.getEnd()) - range.getStart() + 1L;
        if (bytesToRead < 0L || fileSize < range.getStart()) {
            return ResponseEntity.status((int)HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE.value()).build();
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((int)HttpStatus.PARTIAL_CONTENT.value()).headers(headers -> headers.setAll(MetadataUtil.createUserMetadataHeaders(s3Object)))).header("Accept-Ranges", new String[]{RANGES_BYTES})).header("Content-Range", new String[]{String.format("bytes %s-%s/%s", range.getStart(), bytesToRead + range.getStart() - 1L, s3Object.getSize())})).eTag("\"" + s3Object.getEtag() + "\"")).contentType(this.parseMediaType(s3Object.getContentType())).lastModified(s3Object.getLastModified())).contentLength(bytesToRead).body(outputStream -> {
            try (FileInputStream fis = new FileInputStream(s3Object.getDataFile());){
                fis.skip(range.getStart());
                IOUtils.copy((InputStream)new BoundedInputStream((InputStream)fis, bytesToRead), (OutputStream)outputStream);
            }
        });
    }

    private static String filenameFrom(String bucketName, HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        return StringEncoding.encode(StringEncoding.decode(requestUri.substring(requestUri.indexOf(bucketName) + bucketName.length() + 1)));
    }

    static Set<String> collapseCommonPrefixes(String queryPrefix, String delimiter, List<BucketContents> contents) {
        HashSet<String> commonPrefixes = new HashSet<String>();
        if (StringUtils.isEmpty((CharSequence)delimiter)) {
            return commonPrefixes;
        }
        String normalizedQueryPrefix = queryPrefix == null ? "" : queryPrefix;
        for (BucketContents c : contents) {
            int delimiterIndex;
            String key = c.getKey();
            if (!key.startsWith(normalizedQueryPrefix) || (delimiterIndex = key.indexOf(delimiter, normalizedQueryPrefix.length())) <= 0) continue;
            commonPrefixes.add(key.substring(0, delimiterIndex + delimiter.length()));
        }
        return commonPrefixes;
    }

    private List<BucketContents> applyUrlEncoding(List<BucketContents> contents) {
        return contents.stream().map(c -> new BucketContents(StringEncoding.encode(c.getKey()), c.getLastModified(), c.getEtag(), c.getSize(), c.getStorageClass(), c.getOwner())).collect(Collectors.toList());
    }

    private Set<String> applyUrlEncoding(Set<String> contents) {
        return contents.stream().map(StringEncoding::encode).collect(Collectors.toSet());
    }

    static List<BucketContents> filterBucketContentsBy(List<BucketContents> contents, String startAfter) {
        if (StringUtils.isNotEmpty((CharSequence)startAfter)) {
            return contents.stream().filter(p -> KEY_COMPARATOR.compare(p.getKey(), startAfter) > 0).collect(Collectors.toList());
        }
        return contents;
    }

    static List<BucketContents> filterBucketContentsBy(List<BucketContents> contents, Set<String> commonPrefixes) {
        if (commonPrefixes != null && !commonPrefixes.isEmpty()) {
            return contents.stream().filter(c -> commonPrefixes.stream().noneMatch(p -> c.getKey().startsWith((String)p))).collect(Collectors.toList());
        }
        return contents;
    }

    private List<BucketContents> getBucketContents(String bucketName, String prefix) throws IOException {
        String encodedPrefix = null != prefix ? StringEncoding.encode(prefix) : null;
        List<S3Object> s3Objects = this.fileStore.getS3Objects(bucketName, encodedPrefix);
        LOG.debug(String.format("Found %s objects in bucket %s", s3Objects.size(), bucketName));
        return s3Objects.stream().map(s3Object -> new BucketContents(StringEncoding.decode(s3Object.getName()), s3Object.getModificationDate(), s3Object.getEtag(), s3Object.getSize(), "STANDARD", TEST_OWNER)).sorted(BUCKET_CONTENTS_COMPARATOR).collect(Collectors.toList());
    }

    private static boolean isV4ChunkedWithSigningEnabled(String sha256Header) {
        return sha256Header != null && sha256Header.equals(STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD);
    }

    private Map<String, String> addOverrideHeaders(String query) {
        if (StringUtils.isNotBlank((CharSequence)query)) {
            return Arrays.stream(query.split("&")).filter(param -> StringUtils.isNotBlank((CharSequence)this.mapHeaderName(StringEncoding.decode(StringUtils.substringBefore((String)param, (String)"="))))).collect(Collectors.toMap(param -> this.mapHeaderName(StringEncoding.decode(StringUtils.substringBefore((String)param, (String)"="))), param -> StringEncoding.decode(StringUtils.substringAfter((String)param, (String)"="))));
        }
        return Collections.emptyMap();
    }

    private String mapHeaderName(String name) {
        switch (name) {
            case "response-cache-control": {
                return "Cache-Control";
            }
            case "response-content-disposition": {
                return "Content-Disposition";
            }
            case "response-content-encoding": {
                return "Content-Encoding";
            }
            case "response-content-language": {
                return "Content-Language";
            }
            case "response-content-type": {
                return "Content-Type";
            }
            case "response-expires": {
                return "Expires";
            }
        }
        return null;
    }

    private void verifyObjectMatching(List<String> match, List<String> noneMatch, String etag) {
        if (match != null && !match.contains(etag)) {
            throw new S3Exception(HttpStatus.PRECONDITION_FAILED.value(), "PreconditionFailed", "Precondition Failed");
        }
        if (noneMatch != null && noneMatch.contains(etag)) {
            throw new S3Exception(HttpStatus.NOT_MODIFIED.value(), "NotModified", "Not Modified");
        }
    }

    private S3Object verifyObjectExistence(String bucketName, String filename) {
        S3Object s3Object = this.fileStore.getS3Object(bucketName, filename);
        if (s3Object == null) {
            throw new S3Exception(HttpStatus.NOT_FOUND.value(), "NoSuchKey", "The specified key does not exist.");
        }
        return s3Object;
    }

    private void verifyBucketExistence(String bucketName) {
        Bucket bucket = this.fileStore.getBucket(bucketName);
        if (bucket == null) {
            throw new S3Exception(HttpStatus.NOT_FOUND.value(), "NoSuchBucket", "The specified bucket does not exist.");
        }
    }

    private void verifyPartNumberLimits(String partNumberString) {
        int partNumber;
        try {
            partNumber = Integer.parseInt(partNumberString);
        }
        catch (NumberFormatException nfe) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "Part number must be an integer between 1 and 10000, inclusive");
        }
        if (partNumber < 1 || partNumber > 10000) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "Part number must be an integer between 1 and 10000, inclusive");
        }
    }

    private MediaType parseMediaType(String contentType) {
        try {
            return MediaType.parseMediaType((String)contentType);
        }
        catch (InvalidMediaTypeException e) {
            return FALLBACK_MEDIA_TYPE;
        }
    }

    private void validateMultipartParts(String bucketName, String filename, String uploadId, List<Part> requestedParts) throws S3Exception {
        List<Part> uploadedParts = this.fileStore.getMultipartUploadParts(bucketName, filename, uploadId);
        if (uploadedParts.size() == 0) {
            throw new S3Exception(HttpStatus.NOT_FOUND.value(), "NoSuchUpload", "The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.");
        }
        for (int i = 0; i < uploadedParts.size() - 1; ++i) {
            Part part = uploadedParts.get(i);
            if (part.getSize() >= MINIMUM_PART_SIZE) continue;
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "EntityTooSmall", "Your proposed upload is smaller than the minimum allowed object size. Each part must be at least 5 MB in size, except the last part.");
        }
        Map<Integer, String> uploadedPartsMap = uploadedParts.stream().collect(Collectors.toMap(Part::getPartNumber, Part::getETag));
        Integer prevPartNumber = 0;
        for (Part part : requestedParts) {
            if (!uploadedPartsMap.containsKey(part.getPartNumber()) || !uploadedPartsMap.get(part.getPartNumber()).equals(part.getETag().replaceAll("^\"|\"$", ""))) {
                throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidPart", "One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag.");
            }
            if (part.getPartNumber() < prevPartNumber) {
                throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidPartOrder", "The list of parts was not in ascending order. The parts list must be specified in order by part number.");
            }
            prevPartNumber = part.getPartNumber();
        }
    }
}

