/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.FaviconController;
import com.adobe.testing.s3mock.FileStoreController;
import com.adobe.testing.s3mock.KmsValidationFilter;
import com.adobe.testing.s3mock.S3MockProperties;
import com.adobe.testing.s3mock.dto.ErrorResponse;
import com.adobe.testing.s3mock.store.FileStore;
import com.adobe.testing.s3mock.store.KmsKeyStore;
import com.adobe.testing.s3mock.store.S3Exception;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.servlet.filter.OrderedFormContentFilter;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Configuration
@EnableConfigurationProperties(value={S3MockProperties.class})
class S3MockConfiguration
implements WebMvcConfigurer {
    private ServerConnector httpServerConnector;

    S3MockConfiguration() {
    }

    @Bean
    ServletWebServerFactory webServerFactory(S3MockProperties properties) {
        JettyServletWebServerFactory factory = new JettyServletWebServerFactory();
        factory.addServerCustomizers(new JettyServerCustomizer[]{server -> server.addConnector(this.createHttpConnector(server, properties.getHttpPort()))});
        return factory;
    }

    private Connector createHttpConnector(Server server, int httpPort) {
        this.httpServerConnector = new ServerConnector(server);
        this.httpServerConnector.setPort(httpPort);
        return this.httpServerConnector;
    }

    ServerConnector getHttpServerConnector() {
        return this.httpServerConnector;
    }

    @Bean
    Filter kmsFilter(KmsKeyStore kmsKeyStore, MappingJackson2XmlHttpMessageConverter messageConverter) {
        return new KmsValidationFilter(kmsKeyStore, messageConverter);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_XML});
        configurer.favorPathExtension(false);
        configurer.mediaType("xml", MediaType.TEXT_XML);
    }

    @Bean
    MappingJackson2XmlHttpMessageConverter messageConverter() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.APPLICATION_XML);
        mediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
        mediaTypes.add(MediaType.APPLICATION_OCTET_STREAM);
        MappingJackson2XmlHttpMessageConverter xmlConverter = new MappingJackson2XmlHttpMessageConverter();
        xmlConverter.setSupportedMediaTypes(mediaTypes);
        return xmlConverter;
    }

    @Bean
    OrderedFormContentFilter httpPutFormContentFilter() {
        return new OrderedFormContentFilter(){

            protected boolean shouldNotFilter(HttpServletRequest request) {
                return true;
            }
        };
    }

    @Bean
    FaviconController faviconController() {
        return new FaviconController();
    }

    @Bean
    FileStoreController fileStoreController(FileStore fileStore) {
        return new FileStoreController(fileStore);
    }

    @Bean
    S3MockExceptionHandler s3MockExceptionHandler() {
        return new S3MockExceptionHandler();
    }

    @ControllerAdvice
    static class S3MockExceptionHandler
    extends ResponseEntityExceptionHandler {
        private static final Logger LOG = LoggerFactory.getLogger(S3MockExceptionHandler.class);

        S3MockExceptionHandler() {
        }

        @ExceptionHandler
        public ResponseEntity<ErrorResponse> handleS3Exception(S3Exception s3Exception) {
            LOG.info("Responding with status {}: {}", (Object)s3Exception.getStatus(), (Object)s3Exception.getMessage());
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setCode(s3Exception.getCode());
            errorResponse.setMessage(s3Exception.getMessage());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_XML);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)s3Exception.getStatus()).headers(headers)).body((Object)errorResponse);
        }
    }
}

