/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.store.DomainProperties;
import com.adobe.testing.s3mock.store.FileStore;
import com.adobe.testing.s3mock.store.KmsKeyStore;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DomainProperties.class})
class DomainConfiguration {
    DomainConfiguration() {
    }

    @Bean
    FileStore fileStore(DomainProperties properties) {
        return new FileStore(properties.getRoot(), properties.isRetainFilesOnExit(), properties.getInitialBuckets());
    }

    @Bean
    KmsKeyStore kmsKeyStore(DomainProperties properties) {
        return new KmsKeyStore(properties.getValidKmsKeys());
    }
}

