/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.S3MockConfiguration;
import com.adobe.testing.s3mock.store.KmsKeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.Banner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableAutoConfiguration(exclude={SecurityAutoConfiguration.class}, excludeName={"org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration"})
@ComponentScan
public class S3MockApplication {
    public static final int DEFAULT_HTTPS_PORT = 9191;
    public static final int DEFAULT_HTTP_PORT = 9090;
    public static final int RANDOM_PORT = 0;
    public static final String DEFAULT_SERVER_SSL_KEY_STORE = "classpath:s3mock.jks";
    public static final String DEFAULT_SERVER_SSL_KEY_STORE_PASSWORD = "password";
    public static final String DEFAULT_SERVER_SSL_KEY_ALIAS = "selfsigned";
    public static final String DEFAULT_SERVER_SSL_KEY_PASSWORD = "password";
    public static final String PROP_INITIAL_BUCKETS = "com.adobe.testing.s3mock.domain.initialBuckets";
    private static final String LEGACY_PROP_INITIAL_BUCKETS = "initialBuckets";
    public static final String PROP_ROOT_DIRECTORY = "com.adobe.testing.s3mock.domain.root";
    private static final String LEGACY_PROP_ROOT_DIRECTORY = "root";
    public static final String PROP_HTTPS_PORT = "server.port";
    public static final String PROP_HTTP_PORT = "http.port";
    public static final String SERVER_SSL_KEY_STORE = "server.ssl.key-store";
    public static final String SERVER_SSL_KEY_STORE_PASSWORD = "server.ssl.key-store-password";
    public static final String SERVER_SSL_KEY_ALIAS = "server.ssl.key-alias";
    public static final String SERVER_SSL_KEY_PASSWORD = "server.ssl.key-password";
    public static final String PROP_SECURE_CONNECTION = "secureConnection";
    public static final String PROP_SILENT = "silent";
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired
    private KmsKeyStore kmsKeyStore;
    @Autowired
    private Environment environment;
    @Autowired
    private S3MockConfiguration config;

    public static void main(String[] args) {
        S3MockApplication.start(args);
    }

    public static S3MockApplication start(String ... args) {
        return S3MockApplication.start(Collections.emptyMap(), args);
    }

    public static S3MockApplication start(Map<String, Object> properties, String ... args) {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put(PROP_HTTPS_PORT, 9191);
        defaults.put(PROP_HTTP_PORT, 9090);
        defaults.put(SERVER_SSL_KEY_STORE, DEFAULT_SERVER_SSL_KEY_STORE);
        defaults.put(SERVER_SSL_KEY_STORE_PASSWORD, "password");
        defaults.put(SERVER_SSL_KEY_ALIAS, DEFAULT_SERVER_SSL_KEY_ALIAS);
        defaults.put(SERVER_SSL_KEY_PASSWORD, "password");
        Banner.Mode bannerMode = Banner.Mode.CONSOLE;
        if (Boolean.parseBoolean(String.valueOf(properties.remove(PROP_SILENT)))) {
            defaults.put("logging.level.root", "WARN");
            bannerMode = Banner.Mode.OFF;
        }
        ConfigurableApplicationContext ctx = new SpringApplicationBuilder(new Class[]{S3MockApplication.class}).properties(S3MockApplication.translateLegacyProperties(defaults)).properties(S3MockApplication.translateLegacyProperties(properties)).bannerMode(bannerMode).run(args);
        return (S3MockApplication)ctx.getBean(S3MockApplication.class);
    }

    private static Map<String, Object> translateLegacyProperties(Map<String, Object> properties) {
        HashMap<String, Object> translated = new HashMap<String, Object>(properties);
        S3MockApplication.translateLegacyProperty(translated, PROP_ROOT_DIRECTORY, LEGACY_PROP_ROOT_DIRECTORY);
        S3MockApplication.translateLegacyProperty(translated, PROP_INITIAL_BUCKETS, LEGACY_PROP_INITIAL_BUCKETS);
        S3MockApplication.translateLegacyProperty(translated, "com.adobe.testing.s3mock.domain.retainFilesOnExit", "retainFilesOnExit");
        S3MockApplication.translateLegacyProperty(translated, "com.adobe.testing.s3mock.domain.validKmsKeys", "validKmsKeys");
        S3MockApplication.translateLegacyProperty(translated, "com.adobe.testing.s3mock.httpPort", PROP_HTTP_PORT);
        return translated;
    }

    private static void translateLegacyProperty(Map<String, Object> properties, String propertyName, String legacyPropertyName) {
        if (!properties.containsKey(propertyName)) {
            String legacyEnvironmentProperty;
            String legacySystemProperty;
            if (properties.containsKey(legacyPropertyName)) {
                properties.put(propertyName, properties.get(legacyPropertyName));
            }
            if ((legacySystemProperty = System.getProperty(legacyPropertyName)) != null) {
                properties.put(propertyName, legacySystemProperty);
            }
            if ((legacyEnvironmentProperty = System.getenv(legacyPropertyName)) != null) {
                properties.put(propertyName, legacyEnvironmentProperty);
            }
        }
    }

    public void stop() {
        SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }

    @Deprecated
    public int getPort() {
        return Integer.parseInt(this.environment.getProperty("local.server.port"));
    }

    @Deprecated
    public int getHttpPort() {
        return this.config.getHttpServerConnector().getLocalPort();
    }

    @Deprecated
    public void registerKMSKeyRef(String keyRef) {
        this.kmsKeyStore.registerKMSKeyRef(keyRef);
    }
}

