/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class DigestUtil {
    public static String getHexDigest(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        return DigestUtil.getHexDigest(null, inputStream);
    }

    public static String getHexDigest(String salt, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        return new String(Hex.encodeHex((byte[])DigestUtil.getBytes(salt, inputStream)));
    }

    public static String getBase64Digest(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        return DigestUtil.getBase64Digest(null, inputStream);
    }

    public static String getBase64Digest(String salt, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        return Base64.encodeBase64String((byte[])DigestUtil.getBytes(salt, inputStream));
    }

    private static byte[] getBytes(String salt, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        int numBytes;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        if (salt != null) {
            messageDigest.update(salt.getBytes(StandardCharsets.UTF_8));
        }
        byte[] bytes = new byte[1024];
        while ((numBytes = inputStream.read(bytes)) != -1) {
            messageDigest.update(bytes, 0, numBytes);
        }
        return messageDigest.digest();
    }
}

