/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.store.S3Object;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public final class MetadataUtil {
    private static final String HEADER_X_AMZ_META_PREFIX = "x-amz-meta-";

    public static Map<String, String> createUserMetadataHeaders(S3Object s3Object) {
        HashMap<String, String> metadataHeaders = new HashMap<String, String>();
        if (s3Object.getUserMetadata() != null) {
            s3Object.getUserMetadata().forEach((key, value) -> metadataHeaders.put(HEADER_X_AMZ_META_PREFIX + key, (String)value));
        }
        return metadataHeaders;
    }

    public static Map<String, String> getUserMetadata(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().filter(header -> header.startsWith(HEADER_X_AMZ_META_PREFIX)).collect(Collectors.toMap(header -> header.substring(HEADER_X_AMZ_META_PREFIX.length()), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
    }
}

