/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.dto.ListAllMyBucketsResult;
import com.adobe.testing.s3mock.dto.ListBucketResult;
import com.adobe.testing.s3mock.dto.ListBucketResultV2;
import com.adobe.testing.s3mock.service.BucketService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@CrossOrigin(origins={"*"})
@RequestMapping(value={"${com.adobe.testing.s3mock.contextPath:}"})
public class BucketController {
    private final BucketService bucketService;

    public BucketController(BucketService bucketService) {
        this.bucketService = bucketService;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<ListAllMyBucketsResult> listBuckets() {
        ListAllMyBucketsResult listAllMyBucketsResult = this.bucketService.listBuckets();
        return ResponseEntity.ok((Object)listAllMyBucketsResult);
    }

    @RequestMapping(value={"/{bucketName:[a-z0-9.-]+}", "/{bucketName:.+}"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> createBucket(@PathVariable String bucketName) {
        this.bucketService.verifyBucketNameIsAllowed(bucketName);
        this.bucketService.verifyBucketDoesNotExist(bucketName);
        this.bucketService.createBucket(bucketName);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/{bucketName:[a-z0-9.-]+}"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> headBucket(@PathVariable String bucketName) {
        this.bucketService.verifyBucketExists(bucketName);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/{bucketName:[a-z0-9.-]+}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteBucket(@PathVariable String bucketName) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketIsEmpty(bucketName);
        this.bucketService.deleteBucket(bucketName);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(params={"!uploads"}, value={"/{bucketName:[a-z0-9.-]+}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @Deprecated
    public ResponseEntity<ListBucketResult> listObjects(@PathVariable String bucketName, @RequestParam(required=false) String prefix, @RequestParam(required=false) String delimiter, @RequestParam(required=false) String marker, @RequestParam(name="encoding-type", required=false) String encodingType, @RequestParam(name="max-keys", defaultValue="1000", required=false) Integer maxKeys) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyMaxKeys(maxKeys);
        this.bucketService.verifyEncodingType(encodingType);
        ListBucketResult listBucketResult = this.bucketService.listObjectsV1(bucketName, prefix, delimiter, marker, encodingType, maxKeys);
        return ResponseEntity.ok((Object)listBucketResult);
    }

    @RequestMapping(value={"/{bucketName:[a-z0-9.-]+}"}, params={"list-type=2"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<ListBucketResultV2> listObjectsV2(@PathVariable String bucketName, @RequestParam(required=false) String prefix, @RequestParam(required=false) String delimiter, @RequestParam(name="encoding-type", required=false) String encodingType, @RequestParam(name="start-after", required=false) String startAfter, @RequestParam(name="max-keys", defaultValue="1000", required=false) Integer maxKeys, @RequestParam(name="continuation-token", required=false) String continuationToken) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyMaxKeys(maxKeys);
        this.bucketService.verifyEncodingType(encodingType);
        ListBucketResultV2 listBucketResultV2 = this.bucketService.listObjectsV2(bucketName, prefix, delimiter, encodingType, startAfter, maxKeys, continuationToken);
        return ResponseEntity.ok((Object)listBucketResultV2);
    }
}

