/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.Delete;
import com.adobe.testing.s3mock.dto.DeleteResult;
import com.adobe.testing.s3mock.dto.DeletedS3Object;
import com.adobe.testing.s3mock.dto.Error;
import com.adobe.testing.s3mock.dto.S3ObjectIdentifier;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.AwsChunkedDecodingInputStream;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.adobe.testing.s3mock.util.HeaderUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectService {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectService.class);
    private final BucketStore bucketStore;
    private final ObjectStore objectStore;

    public ObjectService(BucketStore bucketStore, ObjectStore objectStore) {
        this.bucketStore = bucketStore;
        this.objectStore = objectStore;
    }

    public S3ObjectMetadata getS3Object(String bucketName, String key) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        if (uuid == null) {
            return null;
        }
        return this.objectStore.getS3ObjectMetadata(bucketMetadata, uuid);
    }

    public CopyObjectResult copyS3Object(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey, String encryption, String kmsKeyId, Map<String, String> userMetadata) {
        BucketMetadata sourceBucketMetadata = this.bucketStore.getBucketMetadata(sourceBucketName);
        BucketMetadata destinationBucketMetadata = this.bucketStore.getBucketMetadata(destinationBucketName);
        UUID sourceId = sourceBucketMetadata.getID(sourceKey);
        if (sourceId == null) {
            return null;
        }
        if (sourceKey.equals(destinationKey) && sourceBucketName.equals(destinationBucketName)) {
            return this.objectStore.pretendToCopyS3Object(sourceBucketMetadata, sourceId, userMetadata);
        }
        UUID destinationId = this.bucketStore.addToBucket(destinationKey, destinationBucketName);
        try {
            return this.objectStore.copyS3Object(sourceBucketMetadata, sourceId, destinationBucketMetadata, destinationId, destinationKey, encryption, kmsKeyId, userMetadata);
        }
        catch (Exception e) {
            this.bucketStore.removeFromBucket(destinationKey, destinationBucketName);
            throw e;
        }
    }

    public S3ObjectMetadata putS3Object(String bucketName, String key, String contentType, String contentEncoding, InputStream dataStream, boolean useV4ChunkedWithSigningFormat, Map<String, String> userMetadata, String encryption, String kmsKeyId, List<Tag> tags) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            id = this.bucketStore.addToBucket(key, bucketName);
        }
        return this.objectStore.storeS3ObjectMetadata(bucketMetadata, id, key, contentType, contentEncoding, dataStream, useV4ChunkedWithSigningFormat, userMetadata, encryption, kmsKeyId, null, tags);
    }

    public DeleteResult deleteObjects(String bucketName, Delete delete) {
        DeleteResult response = new DeleteResult();
        for (S3ObjectIdentifier object : delete.getObjectsToDelete()) {
            try {
                if (this.deleteObject(bucketName, object.getKey())) {
                    response.addDeletedObject(DeletedS3Object.from(object));
                    continue;
                }
                response.addError(new Error("NoSuchKey", object.getKey(), "The specified key does not exist.", object.getVersionId()));
            }
            catch (IllegalStateException e) {
                response.addError(new Error("InternalError", object.getKey(), "We encountered an internal error. Please try again.", object.getVersionId()));
                LOG.error("Object could not be deleted!", (Throwable)e);
            }
        }
        return response;
    }

    public boolean deleteObject(String bucketName, String key) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            return false;
        }
        if (this.objectStore.deleteObject(bucketMetadata, id)) {
            return this.bucketStore.removeFromBucket(key, bucketName);
        }
        return false;
    }

    public void setObjectTags(String bucketName, String key, List<Tag> tags) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        this.objectStore.storeObjectTags(bucketMetadata, uuid, tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream verifyMd5(InputStream inputStream, String contentMd5, String sha256Header) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.copyTo(inputStream, byteArrayOutputStream);
        InputStream stream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            if (HeaderUtil.isV4ChunkedWithSigningEnabled(sha256Header)) {
                stream = new AwsChunkedDecodingInputStream(stream);
            }
            this.verifyMd5(stream, contentMd5);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public void verifyMd5(InputStream inputStream, String contentMd5) {
        String md5;
        if (contentMd5 != null && !(md5 = DigestUtil.base64Digest(inputStream)).equals(contentMd5)) {
            LOG.error("Content-MD5 {} does not match object md5 {}", (Object)contentMd5, (Object)md5);
            throw S3Exception.BAD_REQUEST_MD5;
        }
    }

    private void copyTo(InputStream source, OutputStream target) {
        try {
            int length;
            byte[] buf = new byte[8192];
            while ((length = source.read(buf)) > 0) {
                target.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            LOG.error("Could not copy streams.", (Throwable)e);
            throw new IllegalStateException("Could not copy streams.", e);
        }
    }

    public void verifyObjectMatching(List<String> match, List<String> noneMatch, String etag) {
        if (match != null && !match.contains(etag)) {
            throw S3Exception.PRECONDITION_FAILED;
        }
        if (noneMatch != null && noneMatch.contains(etag)) {
            throw S3Exception.NOT_MODIFIED;
        }
    }

    public S3ObjectMetadata verifyObjectExists(String bucketName, String key) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        if (uuid == null) {
            throw S3Exception.NO_SUCH_KEY;
        }
        S3ObjectMetadata s3ObjectMetadata = this.objectStore.getS3ObjectMetadata(bucketMetadata, uuid);
        if (s3ObjectMetadata == null) {
            throw S3Exception.NO_SUCH_KEY;
        }
        return s3ObjectMetadata;
    }
}

