/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class BucketMetadata {
    private String name;
    private String creationDate;
    private Path path;
    private Map<String, UUID> objects = new HashMap<String, UUID>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Map<String, UUID> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<String, UUID> objects) {
        this.objects = objects;
    }

    public boolean doesKeyExist(String key) {
        return this.getID(key) != null;
    }

    public UUID addKey(String key) {
        if (this.doesKeyExist(key)) {
            return this.getID(key);
        }
        UUID uuid = UUID.nameUUIDFromBytes(key.getBytes(StandardCharsets.UTF_8));
        this.objects.put(key, uuid);
        return uuid;
    }

    public boolean removeKey(String key) {
        UUID removed = this.objects.remove(key);
        return removed != null;
    }

    public UUID getID(String key) {
        return this.objects.get(key);
    }

    public String toString() {
        return "BucketMetadata{name='" + this.name + '\'' + ", creationDate='" + this.creationDate + '\'' + ", path=" + this.path + ", objects=" + this.objects + '}';
    }
}

