/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.store.BucketMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketStore {
    private static final Logger LOG = LoggerFactory.getLogger(BucketStore.class);
    private static final Map<String, Object> lockStore = new ConcurrentHashMap<String, Object>();
    private static final String BUCKET_META_FILE = "bucketMetadata";
    private final File rootFolder;
    private final boolean retainFilesOnExit;
    private final DateTimeFormatter s3ObjectDateFormat;
    private final ObjectMapper objectMapper;

    public BucketStore(File rootFolder, boolean retainFilesOnExit, List<String> initialBuckets, DateTimeFormatter s3ObjectDateFormat, ObjectMapper objectMapper) {
        this.rootFolder = rootFolder;
        this.retainFilesOnExit = retainFilesOnExit;
        this.s3ObjectDateFormat = s3ObjectDateFormat;
        this.objectMapper = objectMapper;
        initialBuckets.forEach(this::createBucket);
    }

    public List<BucketMetadata> listBuckets() {
        return this.findBucketPaths().stream().map(path -> path.getFileName().toString()).map(this::getBucketMetadata).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketMetadata getBucketMetadata(String bucketName) {
        try {
            Path metaFilePath = this.getMetaFilePath(bucketName);
            if (!metaFilePath.toFile().exists()) {
                return null;
            }
            Object object = lockStore.get(bucketName);
            synchronized (object) {
                return (BucketMetadata)this.objectMapper.readValue(metaFilePath.toFile(), BucketMetadata.class);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read bucket metadata-file " + bucketName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UUID addToBucket(String key, String bucketName) {
        Object object = lockStore.get(bucketName);
        synchronized (object) {
            BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
            UUID uuid = bucketMetadata.addKey(key);
            this.writeToDisk(bucketMetadata);
            return uuid;
        }
    }

    public List<UUID> lookupKeysInBucket(String prefix, String bucketName) {
        BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
        String normalizedPrefix = prefix == null ? "" : prefix;
        return bucketMetadata.getObjects().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(normalizedPrefix)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeFromBucket(String key, String bucketName) {
        Object object = lockStore.get(bucketName);
        synchronized (object) {
            BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
            boolean removed = bucketMetadata.removeKey(key);
            this.writeToDisk(bucketMetadata);
            return removed;
        }
    }

    private List<Path> findBucketPaths() {
        ArrayList<Path> bucketPaths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.rootFolder.toPath(), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path path : stream) {
                bucketPaths.add(path);
            }
        }
        catch (IOException e) {
            LOG.error("Could not Iterate over Bucket-Folders", (Throwable)e);
            throw new IllegalStateException("Could not Iterate over Bucket-Folders.", e);
        }
        return bucketPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketMetadata createBucket(String bucketName) {
        BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
        if (bucketMetadata != null) {
            throw new IllegalStateException("Bucket already exists.");
        }
        lockStore.putIfAbsent(bucketName, new Object());
        Object object = lockStore.get(bucketName);
        synchronized (object) {
            File bucketFolder = this.createBucketFolder(bucketName);
            BucketMetadata newBucketMetadata = new BucketMetadata();
            newBucketMetadata.setName(bucketName);
            newBucketMetadata.setCreationDate(this.s3ObjectDateFormat.format(LocalDateTime.now()));
            newBucketMetadata.setPath(bucketFolder.toPath());
            this.writeToDisk(newBucketMetadata);
            return newBucketMetadata;
        }
    }

    public Boolean doesBucketExist(String bucketName) {
        return this.getBucketMetadata(bucketName) != null;
    }

    public boolean isBucketEmpty(String bucketName) {
        BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
        if (bucketMetadata != null) {
            return bucketMetadata.getObjects().isEmpty();
        }
        throw new IllegalStateException("Requested Bucket does not exist: " + bucketName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteBucket(String bucketName) {
        try {
            Object object = lockStore.get(bucketName);
            synchronized (object) {
                BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
                if (bucketMetadata != null && bucketMetadata.getObjects().isEmpty()) {
                    FileUtils.deleteDirectory((File)bucketMetadata.getPath().toFile());
                    lockStore.remove(bucketName);
                    return true;
                }
                return false;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create bucket directory!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDisk(BucketMetadata bucketMetadata) {
        try {
            File metaFile = this.getMetaFilePath(bucketMetadata.getName()).toFile();
            if (!this.retainFilesOnExit) {
                metaFile.deleteOnExit();
            }
            Object object = lockStore.get(bucketMetadata.getName());
            synchronized (object) {
                this.objectMapper.writeValue(metaFile, (Object)bucketMetadata);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write bucket metadata-file", e);
        }
    }

    private Path getBucketFolderPath(String bucketName) {
        return Paths.get(this.rootFolder.getPath(), bucketName);
    }

    private File createBucketFolder(String bucketName) {
        try {
            File bucketFolder = this.getBucketFolderPath(bucketName).toFile();
            FileUtils.forceMkdir((File)bucketFolder);
            if (!this.retainFilesOnExit) {
                bucketFolder.deleteOnExit();
            }
            return bucketFolder;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create bucket directory!", e);
        }
    }

    private Path getMetaFilePath(String bucketName) {
        return Paths.get(this.getBucketFolderPath(bucketName).toString(), BUCKET_META_FILE);
    }
}

