/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.AwsChunkedDecodingInputStream;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStore {
    private static final Map<UUID, Object> lockStore = new ConcurrentHashMap<UUID, Object>();
    private static final String META_FILE = "metadata";
    private static final String DATA_FILE = "fileData";
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStore.class);
    private final boolean retainFilesOnExit;
    private final DateTimeFormatter s3ObjectDateFormat;
    private final ObjectMapper objectMapper;

    public ObjectStore(boolean retainFilesOnExit, DateTimeFormatter s3ObjectDateFormat, ObjectMapper objectMapper) {
        this.retainFilesOnExit = retainFilesOnExit;
        this.s3ObjectDateFormat = s3ObjectDateFormat;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3ObjectMetadata storeS3ObjectMetadata(BucketMetadata bucket, UUID id, String key, String contentType, String contentEncoding, InputStream dataStream, boolean useV4ChunkedWithSigningFormat, Map<String, String> userMetadata, String encryption, String kmsKeyId, String etag, List<Tag> tags) {
        Instant now = Instant.now();
        boolean encrypted = StringUtils.isNotBlank((CharSequence)encryption) && StringUtils.isNotBlank((CharSequence)kmsKeyId);
        S3ObjectMetadata s3ObjectMetadata = new S3ObjectMetadata();
        s3ObjectMetadata.setId(id);
        s3ObjectMetadata.setKey(key);
        s3ObjectMetadata.setContentType(contentType);
        s3ObjectMetadata.setContentEncoding(contentEncoding);
        s3ObjectMetadata.setUserMetadata(userMetadata);
        s3ObjectMetadata.setTags(tags);
        s3ObjectMetadata.setEncrypted(encrypted);
        s3ObjectMetadata.setKmsEncryption(encryption);
        s3ObjectMetadata.setKmsKeyId(kmsKeyId);
        s3ObjectMetadata.setModificationDate(this.s3ObjectDateFormat.format(now));
        s3ObjectMetadata.setLastModified(now.toEpochMilli());
        lockStore.putIfAbsent(id, new Object());
        Object object = lockStore.get(id);
        synchronized (object) {
            this.createObjectRootFolder(bucket, id);
            File dataFile = this.inputStreamToFile(this.wrapStream(dataStream, useV4ChunkedWithSigningFormat), this.getDataFilePath(bucket, id));
            s3ObjectMetadata.setDataPath(dataFile.toPath());
            s3ObjectMetadata.setSize(Long.toString(dataFile.length()));
            s3ObjectMetadata.setEtag(etag != null ? etag : DigestUtil.hexDigest(kmsKeyId, dataFile));
            this.writeMetafile(bucket, s3ObjectMetadata);
        }
        return s3ObjectMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeObjectTags(BucketMetadata bucket, UUID id, List<Tag> tags) {
        Object object = lockStore.get(id);
        synchronized (object) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id);
            s3ObjectMetadata.setTags(tags);
            this.writeMetafile(bucket, s3ObjectMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeUserMetadata(BucketMetadata bucket, UUID id, Map<String, String> metadata) {
        Object object = lockStore.get(id);
        synchronized (object) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id);
            s3ObjectMetadata.setUserMetadata(metadata);
            this.writeMetafile(bucket, s3ObjectMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3ObjectMetadata getS3ObjectMetadata(BucketMetadata bucket, UUID id) {
        S3ObjectMetadata theObject = null;
        Path metaPath = this.getMetaFilePath(bucket, id);
        if (Files.exists(metaPath, new LinkOption[0])) {
            Object object = lockStore.get(id);
            synchronized (object) {
                try {
                    theObject = (S3ObjectMetadata)this.objectMapper.readValue(metaPath.toFile(), S3ObjectMetadata.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read object metadata-file " + id, e);
                }
            }
        }
        return theObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyObjectResult copyS3Object(BucketMetadata sourceBucket, UUID sourceId, BucketMetadata destinationBucket, UUID destinationId, String destinationKey, String encryption, String kmsKeyId, Map<String, String> userMetadata) {
        S3ObjectMetadata copiedObject;
        S3ObjectMetadata sourceObject = this.getS3ObjectMetadata(sourceBucket, sourceId);
        if (sourceObject == null) {
            return null;
        }
        Object object = lockStore.get(sourceId);
        synchronized (object) {
            try (InputStream inputStream = Files.newInputStream(sourceObject.getDataPath(), new OpenOption[0]);){
                copiedObject = this.storeS3ObjectMetadata(destinationBucket, destinationId, destinationKey, sourceObject.getContentType(), sourceObject.getContentEncoding(), inputStream, false, userMetadata == null || userMetadata.isEmpty() ? sourceObject.getUserMetadata() : userMetadata, encryption, kmsKeyId, null, sourceObject.getTags());
            }
            catch (IOException e) {
                LOG.error("Can't write file to disk!", (Throwable)e);
                throw new IllegalStateException("Can't write file to disk!", e);
            }
        }
        return new CopyObjectResult(copiedObject.getModificationDate(), copiedObject.getEtag());
    }

    public CopyObjectResult pretendToCopyS3Object(BucketMetadata sourceBucket, UUID sourceId, Map<String, String> userMetadata) {
        S3ObjectMetadata sourceObject = this.getS3ObjectMetadata(sourceBucket, sourceId);
        if (sourceObject == null) {
            return null;
        }
        this.storeUserMetadata(sourceBucket, sourceId, userMetadata == null || userMetadata.isEmpty() ? sourceObject.getUserMetadata() : userMetadata);
        return new CopyObjectResult(sourceObject.getModificationDate(), sourceObject.getEtag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteObject(BucketMetadata bucket, UUID id) {
        S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id);
        if (s3ObjectMetadata != null) {
            Object object = lockStore.get(id);
            synchronized (object) {
                try {
                    FileUtils.deleteDirectory((File)this.getObjectFolderPath(bucket, id).toFile());
                }
                catch (IOException e) {
                    LOG.error("Can't delete directory.", (Throwable)e);
                    throw new IllegalStateException("Can't delete directory.", e);
                }
                lockStore.remove(id);
                return true;
            }
        }
        return false;
    }

    File inputStreamToFile(InputStream inputStream, Path filePath) {
        File targetFile = filePath.toFile();
        try {
            if (targetFile.createNewFile() && !this.retainFilesOnExit) {
                targetFile.deleteOnExit();
            }
            try (InputStream is = inputStream;
                 OutputStream os = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);){
                int read;
                byte[] bytes = new byte[1024];
                while ((read = is.read(bytes)) != -1) {
                    os.write(bytes, 0, read);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Can't write file to disk!", (Throwable)e);
            throw new IllegalStateException("Can't write file to disk!", e);
        }
        return targetFile;
    }

    InputStream wrapStream(InputStream dataStream, boolean useV4ChunkedWithSigningFormat) {
        InputStream inStream = useV4ChunkedWithSigningFormat ? new AwsChunkedDecodingInputStream(dataStream) : dataStream;
        return inStream;
    }

    private boolean createObjectRootFolder(BucketMetadata bucket, UUID id) {
        File objectRootFolder = this.getObjectFolderPath(bucket, id).toFile();
        return objectRootFolder.mkdirs();
    }

    private Path getObjectFolderPath(BucketMetadata bucket, UUID id) {
        return Paths.get(bucket.getPath().toString(), id.toString());
    }

    private Path getMetaFilePath(BucketMetadata bucket, UUID id) {
        return Paths.get(this.getObjectFolderPath(bucket, id).toString(), META_FILE);
    }

    Path getDataFilePath(BucketMetadata bucket, UUID id) {
        return Paths.get(this.getObjectFolderPath(bucket, id).toString(), DATA_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeMetafile(BucketMetadata bucket, S3ObjectMetadata s3ObjectMetadata) {
        try {
            Object object = lockStore.get(s3ObjectMetadata.getId());
            synchronized (object) {
                File metaFile = this.getMetaFilePath(bucket, s3ObjectMetadata.getId()).toFile();
                if (!this.retainFilesOnExit) {
                    metaFile.deleteOnExit();
                }
                this.objectMapper.writeValue(metaFile, (Object)s3ObjectMetadata);
                return true;
            }
        }
        catch (IOException e) {
            LOG.error("Could not write object metadata-file.", (Throwable)e);
            throw new IllegalStateException("Could not write object metadata-file.", e);
        }
    }
}

