/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.KmsKeyStore;
import com.adobe.testing.s3mock.store.MultipartStore;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.StoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={StoreProperties.class})
class StoreConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StoreConfiguration.class);
    private static final DateTimeFormatter S3_OBJECT_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));

    StoreConfiguration() {
    }

    @Bean
    ObjectStore fileStore(StoreProperties properties, ObjectMapper objectMapper) {
        return new ObjectStore(properties.isRetainFilesOnExit(), S3_OBJECT_DATE_FORMAT, objectMapper);
    }

    @Bean
    BucketStore bucketStore(StoreProperties properties, File bucketRootFolder, ObjectMapper objectMapper) {
        return new BucketStore(bucketRootFolder, properties.isRetainFilesOnExit(), properties.getInitialBuckets(), S3_OBJECT_DATE_FORMAT, objectMapper);
    }

    @Bean
    MultipartStore multipartStore(StoreProperties properties, ObjectStore objectStore) {
        return new MultipartStore(properties.isRetainFilesOnExit(), objectStore);
    }

    @Bean
    KmsKeyStore kmsKeyStore(StoreProperties properties) {
        return new KmsKeyStore(properties.getValidKmsKeys());
    }

    @Bean
    File bucketRootFolder(File rootFolder) {
        return rootFolder;
    }

    @Bean
    File rootFolder(StoreProperties properties) {
        File root = properties.getRoot() == null || properties.getRoot().isEmpty() ? new File(FileUtils.getTempDirectory(), "s3mockFileStore" + new Date().getTime()) : new File(properties.getRoot());
        if (!properties.isRetainFilesOnExit()) {
            root.deleteOnExit();
        }
        if (!root.mkdir()) {
            throw new IllegalStateException("Root folder could not be created. Path: " + root.getAbsolutePath());
        }
        LOG.info("Using \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.isRetainFilesOnExit());
        return root;
    }
}

