/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;

public final class HeaderUtil {
    private static final String RESPONSE_HEADER_CONTENT_TYPE = "response-content-type";
    private static final String RESPONSE_HEADER_CONTENT_LANGUAGE = "response-content-language";
    private static final String RESPONSE_HEADER_EXPIRES = "response-expires";
    private static final String RESPONSE_HEADER_CACHE_CONTROL = "response-cache-control";
    private static final String RESPONSE_HEADER_CONTENT_DISPOSITION = "response-content-disposition";
    private static final String RESPONSE_HEADER_CONTENT_ENCODING = "response-content-encoding";
    private static final String HEADER_X_AMZ_META_PREFIX = "x-amz-meta-";
    private static final String STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final MediaType FALLBACK_MEDIA_TYPE = new MediaType("binary", "octet-stream");

    public static Map<String, String> createUserMetadataHeaders(S3ObjectMetadata s3ObjectMetadata) {
        HashMap<String, String> metadataHeaders = new HashMap<String, String>();
        if (s3ObjectMetadata.getUserMetadata() != null) {
            s3ObjectMetadata.getUserMetadata().forEach((key, value) -> metadataHeaders.put(HEADER_X_AMZ_META_PREFIX + key, (String)value));
        }
        return metadataHeaders;
    }

    public static Map<String, String> getUserMetadata(HttpHeaders headers) {
        return headers.keySet().stream().filter(header -> header.startsWith(HEADER_X_AMZ_META_PREFIX) && headers.getFirst(header) != null).collect(Collectors.toMap(header -> header.substring(HEADER_X_AMZ_META_PREFIX.length()), arg_0 -> ((HttpHeaders)headers).getFirst(arg_0)));
    }

    public static Map<String, String> createEncryptionHeaders(S3ObjectMetadata s3ObjectMetadata) {
        HashMap<String, String> encryptionHeaders = new HashMap<String, String>();
        if (s3ObjectMetadata.isEncrypted()) {
            encryptionHeaders.put("x-amz-server-side-encryption", s3ObjectMetadata.getKmsEncryption());
            encryptionHeaders.put("x-amz-server-side-encryption-aws-kms-key-id", s3ObjectMetadata.getKmsKeyId());
        }
        return encryptionHeaders;
    }

    public static boolean isV4ChunkedWithSigningEnabled(String sha256Header) {
        return sha256Header != null && sha256Header.equals(STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD);
    }

    public static MediaType parseMediaType(String contentType) {
        try {
            return MediaType.parseMediaType((String)contentType);
        }
        catch (InvalidMediaTypeException e) {
            return FALLBACK_MEDIA_TYPE;
        }
    }

    public static Map<String, String> createOverrideHeaders(Map<String, String> queryParams) {
        return queryParams.entrySet().stream().map(entry -> {
            if (StringUtils.isNotBlank((CharSequence)HeaderUtil.mapHeaderName((String)entry.getKey()))) {
                return new AbstractMap.SimpleEntry<String, String>(HeaderUtil.mapHeaderName((String)entry.getKey()), (String)entry.getValue());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private static String mapHeaderName(String name) {
        switch (name) {
            case "response-cache-control": {
                return "Cache-Control";
            }
            case "response-content-disposition": {
                return "Content-Disposition";
            }
            case "response-content-encoding": {
                return "Content-Encoding";
            }
            case "response-content-language": {
                return "Content-Language";
            }
            case "response-content-type": {
                return "Content-Type";
            }
            case "response-expires": {
                return "Expires";
            }
        }
        return "";
    }
}

