/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringEncoding {
    private static final Logger LOG = LoggerFactory.getLogger(StringEncoding.class);
    private static final String[] ENCODED_CHARACTERS_WITH_SLASHES = new String[]{"+", "*", "%7E", "%2F"};
    private static final String[] ENCODED_CHARACTERS_WITH_SLASHES_REPLACEMENTS = new String[]{"%20", "%2A", "~", "/"};
    private static final String[] ENCODED_CHARACTERS_WITHOUT_SLASHES = new String[]{"+", "*", "%7E"};
    private static final String[] ENCODED_CHARACTERS_WITHOUT_SLASHES_REPLACEMENTS = new String[]{"%20", "%2A", "~"};

    public static String urlDecode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error decoding string {}", (Object)value, (Object)e);
            throw new RuntimeException("Unable to decode value", e);
        }
    }

    public static String urlEncodeIgnoreSlashes(String value) {
        return StringEncoding.urlEncode(value, true);
    }

    public static String urlEncode(String value) {
        return StringEncoding.urlEncode(value, false);
    }

    private static String urlEncode(String value, boolean ignoreSlashes) {
        String encoded;
        if (value == null) {
            return null;
        }
        try {
            encoded = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error encoding string {}", (Object)value, (Object)e);
            throw new RuntimeException("Unable to encode value", e);
        }
        if (!ignoreSlashes) {
            return StringUtils.replaceEach((String)encoded, (String[])ENCODED_CHARACTERS_WITHOUT_SLASHES, (String[])ENCODED_CHARACTERS_WITHOUT_SLASHES_REPLACEMENTS);
        }
        return StringUtils.replaceEach((String)encoded, (String[])ENCODED_CHARACTERS_WITH_SLASHES, (String[])ENCODED_CHARACTERS_WITH_SLASHES_REPLACEMENTS);
    }
}

