/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class AwsChunkedInputStream
extends InputStream {
    protected long readDecodedLength = 0L;
    protected BufferedInputStream source;
    protected BufferedReader reader;
    protected long chunkLength = 0L;
    protected int chunks = 0;
    protected String checksum;
    protected ChecksumAlgorithm algorithm;
    protected final boolean hasChecksum;
    protected final long decodedLength;

    public AwsChunkedInputStream(InputStream source, long decodedLength, boolean hasChecksum) {
        this.reader = new BufferedReader(new InputStreamReader(source, StandardCharsets.UTF_8));
        this.decodedLength = decodedLength;
        this.hasChecksum = hasChecksum;
    }

    @Override
    public int read() throws IOException {
        if (this.chunkLength == -1L) {
            return -1;
        }
        if (this.chunkLength == 0L) {
            String hexLength = this.readHexLength();
            if (hexLength == null) {
                return -1;
            }
            this.setChunkLength(hexLength);
            if (this.chunkLength == 0L) {
                this.extractAlgorithmAndChecksum();
                this.chunkLength = -1L;
                return -1;
            }
            ++this.chunks;
        }
        ++this.readDecodedLength;
        --this.chunkLength;
        return this.reader.read();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public ChecksumAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    private void setChunkLength(String hexLength) {
        this.chunkLength = Long.parseLong(hexLength.trim(), 16);
    }

    private void extractAlgorithmAndChecksum() throws IOException {
        String typeAndChecksumString;
        if (this.hasChecksum && (typeAndChecksumString = this.reader.readLine()) != null && !typeAndChecksumString.isBlank()) {
            String[] split = typeAndChecksumString.split(":");
            String type = split[0];
            this.algorithm = ChecksumAlgorithm.fromHeader(type);
            this.checksum = split[1];
        }
    }

    private String readHexLength() throws IOException {
        String hexLength = this.reader.readLine();
        if (hexLength != null && hexLength.isBlank()) {
            hexLength = this.reader.readLine();
        }
        if (hexLength != null && !hexLength.isBlank()) {
            hexLength = hexLength.split(";")[0];
        }
        return hexLength;
    }
}

