/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.AccessControlPolicy;
import com.adobe.testing.s3mock.dto.CanonicalUser;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.Grant;
import com.adobe.testing.s3mock.dto.LegalHold;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Retention;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.store.StoreBase;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStore
extends StoreBase {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStore.class);
    private static final String META_FILE = "objectMetadata.json";
    private static final String ACL_FILE = "objectAcl.json";
    private static final String DATA_FILE = "binaryData";
    private final Map<UUID, Object> lockStore = new ConcurrentHashMap<UUID, Object>();
    private final boolean retainFilesOnExit;
    private final DateTimeFormatter s3ObjectDateFormat;
    private final ObjectMapper objectMapper;

    public ObjectStore(boolean retainFilesOnExit, DateTimeFormatter s3ObjectDateFormat, ObjectMapper objectMapper) {
        this.retainFilesOnExit = retainFilesOnExit;
        this.s3ObjectDateFormat = s3ObjectDateFormat;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3ObjectMetadata storeS3ObjectMetadata(BucketMetadata bucket, UUID id, String key, String contentType, Map<String, String> storeHeaders, Path path, Map<String, String> userMetadata, Map<String, String> encryptionHeaders, String etag, List<Tag> tags, ChecksumAlgorithm checksumAlgorithm, String checksum, Owner owner, StorageClass storageClass) {
        this.lockStore.putIfAbsent(id, new Object());
        Object object = this.lockStore.get(id);
        synchronized (object) {
            this.createObjectRootFolder(bucket, id);
            File dataFile = this.inputPathToFile(path, this.getDataFilePath(bucket, id), this.retainFilesOnExit);
            Instant now = Instant.now();
            S3ObjectMetadata s3ObjectMetadata = new S3ObjectMetadata(id, key, Long.toString(dataFile.length()), this.s3ObjectDateFormat.format(now), etag != null ? etag : DigestUtil.hexDigest(encryptionHeaders.get("x-amz-server-side-encryption-aws-kms-key-id"), dataFile), contentType, now.toEpochMilli(), dataFile.toPath(), userMetadata, tags, null, null, owner, storeHeaders, encryptionHeaders, checksumAlgorithm, checksum, storageClass);
            this.writeMetafile(bucket, s3ObjectMetadata);
            return s3ObjectMetadata;
        }
    }

    private AccessControlPolicy privateCannedAcl(Owner owner) {
        Grant grant = new Grant(new CanonicalUser(owner.id(), owner.displayName(), null, null), Grant.Permission.FULL_CONTROL);
        return new AccessControlPolicy(owner, Collections.singletonList(grant));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeObjectTags(BucketMetadata bucket, UUID id, List<Tag> tags) {
        Object object = this.lockStore.get(id);
        synchronized (object) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id);
            this.writeMetafile(bucket, new S3ObjectMetadata(s3ObjectMetadata.id(), s3ObjectMetadata.key(), s3ObjectMetadata.size(), s3ObjectMetadata.modificationDate(), s3ObjectMetadata.etag(), s3ObjectMetadata.contentType(), s3ObjectMetadata.lastModified(), s3ObjectMetadata.dataPath(), s3ObjectMetadata.userMetadata(), tags, s3ObjectMetadata.legalHold(), s3ObjectMetadata.retention(), s3ObjectMetadata.owner(), s3ObjectMetadata.storeHeaders(), s3ObjectMetadata.encryptionHeaders(), s3ObjectMetadata.checksumAlgorithm(), s3ObjectMetadata.checksum(), s3ObjectMetadata.storageClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLegalHold(BucketMetadata bucket, UUID id, LegalHold legalHold) {
        Object object = this.lockStore.get(id);
        synchronized (object) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id);
            this.writeMetafile(bucket, new S3ObjectMetadata(s3ObjectMetadata.id(), s3ObjectMetadata.key(), s3ObjectMetadata.size(), s3ObjectMetadata.modificationDate(), s3ObjectMetadata.etag(), s3ObjectMetadata.contentType(), s3ObjectMetadata.lastModified(), s3ObjectMetadata.dataPath(), s3ObjectMetadata.userMetadata(), s3ObjectMetadata.tags(), legalHold, s3ObjectMetadata.retention(), s3ObjectMetadata.owner(), s3ObjectMetadata.storeHeaders(), s3ObjectMetadata.encryptionHeaders(), s3ObjectMetadata.checksumAlgorithm(), s3ObjectMetadata.checksum(), s3ObjectMetadata.storageClass()));
        }
    }

    public void storeAcl(BucketMetadata bucket, UUID id, AccessControlPolicy policy) {
        this.writeAclFile(bucket, id, policy);
    }

    public AccessControlPolicy readAcl(BucketMetadata bucket, UUID id) {
        AccessControlPolicy policy = this.readAclFile(bucket, id);
        if (policy == null) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id);
            return this.privateCannedAcl(s3ObjectMetadata.owner());
        }
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRetention(BucketMetadata bucket, UUID id, Retention retention) {
        Object object = this.lockStore.get(id);
        synchronized (object) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id);
            this.writeMetafile(bucket, new S3ObjectMetadata(s3ObjectMetadata.id(), s3ObjectMetadata.key(), s3ObjectMetadata.size(), s3ObjectMetadata.modificationDate(), s3ObjectMetadata.etag(), s3ObjectMetadata.contentType(), s3ObjectMetadata.lastModified(), s3ObjectMetadata.dataPath(), s3ObjectMetadata.userMetadata(), s3ObjectMetadata.tags(), s3ObjectMetadata.legalHold(), retention, s3ObjectMetadata.owner(), s3ObjectMetadata.storeHeaders(), s3ObjectMetadata.encryptionHeaders(), s3ObjectMetadata.checksumAlgorithm(), s3ObjectMetadata.checksum(), s3ObjectMetadata.storageClass()));
        }
    }

    public S3ObjectMetadata getS3ObjectMetadata(BucketMetadata bucket, UUID id) {
        Path metaPath = this.getMetaFilePath(bucket, id);
        if (Files.exists(metaPath, new LinkOption[0])) {
            Object object = this.lockStore.get(id);
            synchronized (object) {
                try {
                    return (S3ObjectMetadata)this.objectMapper.readValue(metaPath.toFile(), S3ObjectMetadata.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read object metadata-file " + String.valueOf(id), e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyObjectResult copyS3Object(BucketMetadata sourceBucket, UUID sourceId, BucketMetadata destinationBucket, UUID destinationId, String destinationKey, Map<String, String> encryptionHeaders, Map<String, String> userMetadata, StorageClass storageClass) {
        S3ObjectMetadata sourceObject = this.getS3ObjectMetadata(sourceBucket, sourceId);
        if (sourceObject == null) {
            return null;
        }
        Object object = this.lockStore.get(sourceId);
        synchronized (object) {
            S3ObjectMetadata copiedObject = this.storeS3ObjectMetadata(destinationBucket, destinationId, destinationKey, sourceObject.contentType(), sourceObject.storeHeaders(), sourceObject.dataPath(), userMetadata == null || userMetadata.isEmpty() ? sourceObject.userMetadata() : userMetadata, encryptionHeaders == null || encryptionHeaders.isEmpty() ? sourceObject.encryptionHeaders() : encryptionHeaders, null, sourceObject.tags(), sourceObject.checksumAlgorithm(), sourceObject.checksum(), sourceObject.owner(), storageClass != null ? storageClass : sourceObject.storageClass());
            return new CopyObjectResult(copiedObject.modificationDate(), copiedObject.etag());
        }
    }

    public CopyObjectResult pretendToCopyS3Object(BucketMetadata sourceBucket, UUID sourceId, Map<String, String> userMetadata, Map<String, String> encryptionHeaders, StorageClass storageClass) {
        S3ObjectMetadata sourceObject = this.getS3ObjectMetadata(sourceBucket, sourceId);
        if (sourceObject == null) {
            return null;
        }
        this.verifyPretendCopy(sourceObject, userMetadata, encryptionHeaders, storageClass);
        this.writeMetafile(sourceBucket, new S3ObjectMetadata(sourceObject.id(), sourceObject.key(), sourceObject.size(), sourceObject.modificationDate(), sourceObject.etag(), sourceObject.contentType(), Instant.now().toEpochMilli(), sourceObject.dataPath(), userMetadata == null || userMetadata.isEmpty() ? sourceObject.userMetadata() : userMetadata, sourceObject.tags(), sourceObject.legalHold(), sourceObject.retention(), sourceObject.owner(), sourceObject.storeHeaders(), encryptionHeaders == null || encryptionHeaders.isEmpty() ? sourceObject.encryptionHeaders() : encryptionHeaders, sourceObject.checksumAlgorithm(), sourceObject.checksum(), storageClass != null ? storageClass : sourceObject.storageClass()));
        return new CopyObjectResult(sourceObject.modificationDate(), sourceObject.etag());
    }

    private void verifyPretendCopy(S3ObjectMetadata sourceObject, Map<String, String> userMetadata, Map<String, String> encryptionHeaders, StorageClass storageClass) {
        boolean storageClassUnChanged;
        boolean userDataUnChanged = userMetadata == null || userMetadata.isEmpty();
        boolean encryptionHeadersUnChanged = encryptionHeaders == null || encryptionHeaders.isEmpty();
        boolean bl = storageClassUnChanged = storageClass == null || storageClass == sourceObject.storageClass();
        if (userDataUnChanged && storageClassUnChanged && encryptionHeadersUnChanged) {
            throw S3Exception.INVALID_COPY_REQUEST_SAME_KEY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteObject(BucketMetadata bucket, UUID id) {
        S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id);
        if (s3ObjectMetadata != null) {
            Object object = this.lockStore.get(id);
            synchronized (object) {
                try {
                    FileUtils.deleteDirectory((File)this.getObjectFolderPath(bucket, id).toFile());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not delete object-directory " + String.valueOf(id), e);
                }
                this.lockStore.remove(id);
                return true;
            }
        }
        return false;
    }

    void loadObjects(BucketMetadata bucketMetadata, Collection<UUID> ids) {
        int loaded = 0;
        for (UUID id : ids) {
            this.lockStore.putIfAbsent(id, new Object());
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucketMetadata, id);
            if (s3ObjectMetadata == null) continue;
            ++loaded;
        }
        LOG.info("Loaded {}/{} objects for bucket {}", new Object[]{loaded, ids.size(), bucketMetadata.name()});
    }

    private void createObjectRootFolder(BucketMetadata bucket, UUID id) {
        File objectRootFolder = this.getObjectFolderPath(bucket, id).toFile();
        if (objectRootFolder.mkdirs() && !this.retainFilesOnExit) {
            objectRootFolder.deleteOnExit();
        }
    }

    private Path getObjectFolderPath(BucketMetadata bucket, UUID id) {
        return Paths.get(bucket.path().toString(), id.toString());
    }

    private Path getMetaFilePath(BucketMetadata bucket, UUID id) {
        return Paths.get(this.getObjectFolderPath(bucket, id).toString(), META_FILE);
    }

    private Path getAclFilePath(BucketMetadata bucket, UUID id) {
        return Paths.get(this.getObjectFolderPath(bucket, id).toString(), ACL_FILE);
    }

    private Path getDataFilePath(BucketMetadata bucket, UUID id) {
        return Paths.get(this.getObjectFolderPath(bucket, id).toString(), DATA_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetafile(BucketMetadata bucket, S3ObjectMetadata s3ObjectMetadata) {
        UUID id = s3ObjectMetadata.id();
        try {
            Object object = this.lockStore.get(id);
            synchronized (object) {
                File metaFile = this.getMetaFilePath(bucket, id).toFile();
                if (!this.retainFilesOnExit) {
                    metaFile.deleteOnExit();
                }
                this.objectMapper.writeValue(metaFile, (Object)s3ObjectMetadata);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write object metadata-file " + String.valueOf(id), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessControlPolicy readAclFile(BucketMetadata bucket, UUID id) {
        try {
            Object object = this.lockStore.get(id);
            synchronized (object) {
                File aclFile = this.getAclFilePath(bucket, id).toFile();
                if (!aclFile.exists()) {
                    return null;
                }
                String toDeserialize = FileUtils.readFileToString((File)aclFile, (Charset)Charset.defaultCharset());
                return (AccessControlPolicy)this.objectMapper.readValue(toDeserialize, AccessControlPolicy.class);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read object acl-file " + String.valueOf(id), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAclFile(BucketMetadata bucket, UUID id, AccessControlPolicy policy) {
        try {
            Object object = this.lockStore.get(id);
            synchronized (object) {
                File aclFile = this.getAclFilePath(bucket, id).toFile();
                if (!this.retainFilesOnExit) {
                    aclFile.deleteOnExit();
                }
                FileUtils.write((File)aclFile, (CharSequence)this.objectMapper.writeValueAsString((Object)policy), (Charset)Charset.defaultCharset());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write object acl-file " + String.valueOf(id), e);
        }
    }
}

