/**
 *                       ######
 *                       ######
 * ############    ####( ######  #####. ######  ############   ############
 * #############  #####( ######  #####. ######  #############  #############
 *        ######  #####( ######  #####. ######  #####  ######  #####  ######
 * ###### ######  #####( ######  #####. ######  #####  #####   #####  ######
 * ###### ######  #####( ######  #####. ######  #####          #####  ######
 * #############  #############  #############  #############  #####  ######
 *  ############   ############  #############   ############  #####  ######
 *                                      ######
 *                               #############
 *                               ############
 *
 * Adyen Java API Library
 *
 * Copyright (c) 2017 Adyen B.V.
 * This file is open source and available under the MIT license.
 * See the LICENSE file for more info.
 */
package com.adyen.service.resource.DirectoryLookup;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import com.adyen.Config;
import com.adyen.Service;
import com.adyen.httpclient.ClientInterface;
import com.adyen.httpclient.HTTPClientException;
import com.adyen.service.Resource;

/**
 * Created by rikt on 6/28/17.
 */
public class Directory extends Resource {

    public Directory(Service service) {

        super(service,
              service.getClient().getConfig().getHppEndpoint() + "/directory.shtml",
              Arrays.asList(
                      "currencyCode",
                      "merchantAccount",
                      "paymentAmount",
                      "skinCode",
                      "merchantReference",
                      "sessionValidity",
                      "merchantSig"
              )
        );
    }
//
//    public String directoryLookup(Map<String, String> postParameters) throws HTTPClientException, IOException {
//        ClientInterface httpClient = (ClientInterface) this.getClient().getHttpClient();
//        return httpClient.post(endpoint, postParameters, service.getClient().getConfig());
//    }


}
