/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.Util;

import com.adyen.model.Amount;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Util {
    public static <T> String implode(String glue, List<T> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        Iterator<T> iter = list.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(iter.next());
        while (iter.hasNext()) {
            sb.append(glue).append(iter.next());
        }
        return sb.toString();
    }

    public static Amount createAmount(String amount, String currency) {
        return Util.createAmount(new BigDecimal(amount), currency);
    }

    public static Amount createAmount(BigDecimal amount, String currency) {
        Amount amountData = new Amount();
        amountData.setCurrency(currency);
        Integer scale = Util.getDecimalPlaces(currency);
        Long amountValue = new BigDecimal(10).pow(scale).multiply(amount.setScale((int)scale, RoundingMode.HALF_UP)).longValue();
        amountData.setValue(amountValue);
        return amountData;
    }

    public static int getDecimalPlaces(String currency) {
        switch (currency) {
            case "JPY": 
            case "IDR": 
            case "KRW": 
            case "BYR": 
            case "VND": 
            case "CVE": 
            case "DJF": 
            case "GNF": 
            case "PYG": 
            case "RWF": 
            case "UGX": 
            case "VUV": 
            case "XAF": 
            case "XOF": 
            case "XPF": 
            case "GHC": 
            case "KMF": {
                return 0;
            }
            case "MRO": {
                return 1;
            }
            case "BHD": 
            case "JOD": 
            case "KWD": 
            case "OMR": 
            case "LYD": 
            case "TND": {
                return 3;
            }
        }
        return 2;
    }

    public static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static String calculateSessionValidity() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        Date sessionDate = calendar.getTime();
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(sessionDate);
    }
}

